/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.partitioner;

import com.datatorrent.api.DefaultPartition;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Partitioner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessPartitioner<T extends Operator>
implements Partitioner<T>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(StatelessPartitioner.class);
    private static final long serialVersionUID = 201411071710L;
    @Min(value=1L)
    private int partitionCount = 1;

    public StatelessPartitioner() {
    }

    public StatelessPartitioner(String value) {
        this(Integer.parseInt(value));
    }

    public StatelessPartitioner(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Collection<Partitioner.Partition<T>> definePartitions(Collection<Partitioner.Partition<T>> partitions, Partitioner.PartitioningContext context) {
        Collection<Object> newPartitions;
        int newPartitionCount = DefaultPartition.getRequiredPartitionCount((Partitioner.PartitioningContext)context, (int)this.partitionCount);
        logger.debug("define partitions, partitionCount current {} requested {}", (Object)partitions.size(), (Object)newPartitionCount);
        DefaultPartition partition = (DefaultPartition)partitions.iterator().next();
        if (partitions.iterator().next().getStats() == null) {
            newPartitions = Lists.newArrayList();
            for (int partitionCounter = 0; partitionCounter < newPartitionCount; ++partitionCounter) {
                newPartitions.add(new DefaultPartition(partition.getPartitionedInstance()));
            }
            List inputPortList = context.getInputPorts();
            if (inputPortList != null && !inputPortList.isEmpty()) {
                DefaultPartition.assignPartitionKeys(newPartitions, (Operator.InputPort)((Operator.InputPort)inputPortList.iterator().next()));
            }
        } else {
            newPartitions = context.getParallelPartitionCount() != 0 ? StatelessPartitioner.repartitionParallel(partitions, context) : (partition.getPartitionKeys().isEmpty() ? StatelessPartitioner.repartitionInputOperator(partitions) : StatelessPartitioner.repartition(partitions));
        }
        logger.debug("new partition size {}", (Object)newPartitions.size());
        return newPartitions;
    }

    public void partitioned(Map<Integer, Partitioner.Partition<T>> partitions) {
    }

    public static <T extends Operator> Collection<Partitioner.Partition<T>> repartition(Collection<Partitioner.Partition<T>> partitions) {
        ArrayList<Partitioner.Partition<T>> newPartitions = new ArrayList<Partitioner.Partition<T>>();
        HashMap<Integer, Partitioner.Partition<T>> lowLoadPartitions = new HashMap<Integer, Partitioner.Partition<T>>();
        for (Partitioner.Partition<T> p : partitions) {
            int load = p.getLoad();
            if (load < 0) {
                Partitioner.PartitionKeys pks = (Partitioner.PartitionKeys)p.getPartitionKeys().values().iterator().next();
                Iterator i$ = pks.partitions.iterator();
                while (i$.hasNext()) {
                    int reducedMask;
                    int partitionKey = (Integer)i$.next();
                    Partitioner.Partition siblingPartition = (Partitioner.Partition)lowLoadPartitions.remove(partitionKey & (reducedMask = pks.mask >>> 1));
                    if (siblingPartition == null) {
                        lowLoadPartitions.put(partitionKey & reducedMask, p);
                        continue;
                    }
                    Partitioner.PartitionKeys newPks = new Partitioner.PartitionKeys(reducedMask, (Set)Sets.newHashSet((Object[])new Integer[]{partitionKey & reducedMask}));
                    Operator.InputPort port = (Operator.InputPort)siblingPartition.getPartitionKeys().keySet().iterator().next();
                    siblingPartition.getPartitionKeys().put(port, newPks);
                    newPartitions.add(siblingPartition);
                }
                continue;
            }
            if (load > 0) {
                Set newKeys;
                int newMask;
                Map keys = p.getPartitionKeys();
                Map.Entry e = keys.entrySet().iterator().next();
                if (((Partitioner.PartitionKeys)e.getValue()).partitions.size() == 1) {
                    newMask = ((Partitioner.PartitionKeys)e.getValue()).mask << 1 | 1;
                    int key = (Integer)((Partitioner.PartitionKeys)e.getValue()).partitions.iterator().next();
                    int key2 = newMask ^ ((Partitioner.PartitionKeys)e.getValue()).mask | key;
                    newKeys = Sets.newHashSet((Object[])new Integer[]{key, key2});
                } else {
                    newMask = ((Partitioner.PartitionKeys)e.getValue()).mask;
                    newKeys = ((Partitioner.PartitionKeys)e.getValue()).partitions;
                }
                Iterator i$ = newKeys.iterator();
                while (i$.hasNext()) {
                    int key = (Integer)i$.next();
                    DefaultPartition newPartition = new DefaultPartition(p.getPartitionedInstance());
                    newPartition.getPartitionKeys().put(e.getKey(), new Partitioner.PartitionKeys(newMask, (Set)Sets.newHashSet((Object[])new Integer[]{key})));
                    newPartitions.add((Partitioner.Partition<T>)newPartition);
                }
                continue;
            }
            newPartitions.add(p);
        }
        newPartitions.addAll(lowLoadPartitions.values());
        return newPartitions;
    }

    public static <T extends Operator> Collection<Partitioner.Partition<T>> repartitionInputOperator(Collection<Partitioner.Partition<T>> partitions) {
        ArrayList<Partitioner.Partition<T>> newPartitions = new ArrayList<Partitioner.Partition<T>>();
        ArrayList<Partitioner.Partition<T>> lowLoadPartitions = new ArrayList<Partitioner.Partition<T>>();
        for (Partitioner.Partition<T> p : partitions) {
            int load = p.getLoad();
            if (load < 0) {
                if (!lowLoadPartitions.isEmpty()) {
                    newPartitions.add((Partitioner.Partition<T>)lowLoadPartitions.remove(0));
                    continue;
                }
                lowLoadPartitions.add(p);
                continue;
            }
            if (load > 0) {
                newPartitions.add((Partitioner.Partition<T>)new DefaultPartition(p.getPartitionedInstance()));
                newPartitions.add((Partitioner.Partition<T>)new DefaultPartition(p.getPartitionedInstance()));
                continue;
            }
            newPartitions.add(p);
        }
        newPartitions.addAll(lowLoadPartitions);
        return newPartitions;
    }

    public static <T extends Operator> Collection<Partitioner.Partition<T>> repartitionParallel(Collection<Partitioner.Partition<T>> partitions, Partitioner.PartitioningContext context) {
        ArrayList newPartitions = Lists.newArrayList();
        newPartitions.addAll(partitions);
        int morePartitionsToCreate = context.getParallelPartitionCount() - newPartitions.size();
        if (morePartitionsToCreate < 0) {
            Iterator partitionIterator = newPartitions.iterator();
            while (morePartitionsToCreate++ < 0) {
                partitionIterator.next();
                partitionIterator.remove();
            }
        } else {
            Operator anOperator = (Operator)((Partitioner.Partition)newPartitions.iterator().next()).getPartitionedInstance();
            while (morePartitionsToCreate-- > 0) {
                DefaultPartition partition = new DefaultPartition((Object)anOperator);
                newPartitions.add(partition);
            }
        }
        return newPartitions;
    }
}

