/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContainerOptConfigurator
implements Context.ContainerOptConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(BasicContainerOptConfigurator.class);
    private static final String XMX = "-Xmx";
    private static final String XMS = "-Xms";
    private static final String XSS = "-Xss";
    private static final String[] OPT_LIST = new String[]{"-Xms", "-Xmx", "-Xss"};
    private static final String GENERIC = "Generic";
    private static final int GB_TO_B = 0x40000000;
    private static final int MB_TO_B = 0x100000;
    private static final int KB_TO_B = 1024;

    public String getJVMOptions(List<DAG.OperatorMeta> operatorMetaList) {
        Set genericProperties = null;
        long xmx = 0L;
        long xms = 0L;
        long xss = 0L;
        ArrayList jvmOptsList = Lists.newArrayList();
        for (DAG.OperatorMeta operatorMeta : operatorMetaList) {
            Map<String, Object> operatorMap = this.parseJvmOpts((String)operatorMeta.getValue(Context.OperatorContext.JVM_OPTIONS), (Integer)operatorMeta.getValue(Context.OperatorContext.MEMORY_MB));
            LOG.info("property map for operator {}", operatorMap);
            Set operatorPropertySet = (Set)operatorMap.get(GENERIC);
            if (genericProperties == null) {
                genericProperties = operatorPropertySet;
            } else if (operatorPropertySet != null && !genericProperties.equals(operatorPropertySet)) {
                throw new AssertionError((Object)("Properties don't match: " + genericProperties + " " + operatorPropertySet));
            }
            jvmOptsList.add(operatorMap);
        }
        for (Map map : jvmOptsList) {
            String value;
            if (map.containsKey(XMX)) {
                value = (String)map.get(XMX);
                xmx += this.getOptValue(value);
            }
            if (map.containsKey(XMS)) {
                value = (String)map.get(XMS);
                xms += this.getOptValue(value);
            }
            if (!map.containsKey(XSS)) continue;
            value = (String)map.get(XSS);
            xss += this.getOptValue(value);
        }
        StringBuilder builder = new StringBuilder(" ");
        builder.append(XMX).append(xmx);
        if (xms != 0L) {
            builder.append(" ").append(XMS).append(xms);
        }
        if (xss != 0L) {
            builder.append(" ").append(XSS).append(xss);
        }
        if (genericProperties != null) {
            for (String property : genericProperties) {
                builder.append(" ").append(property);
            }
        }
        return builder.toString();
    }

    private long getOptValue(String value) {
        long result = value.endsWith("g") || value.endsWith("G") ? Long.valueOf(value.substring(0, value.length() - 1)) * 0x40000000L : (value.endsWith("m") || value.endsWith("M") ? Long.valueOf(value.substring(0, value.length() - 1)) * 0x100000L : (value.endsWith("k") || value.endsWith("K") ? Long.valueOf(value.substring(0, value.length() - 1)) * 1024L : Long.valueOf(value)));
        return result;
    }

    private Map<String, Object> parseJvmOpts(String jvmOpts, int memory) {
        HashSet currentProperties = null;
        HashMap map = Maps.newHashMap();
        if (jvmOpts != null && jvmOpts.length() > 1) {
            String[] splits;
            for (String split : splits = jvmOpts.split("(\\s+)")) {
                boolean foundProperty = false;
                for (String opt : OPT_LIST) {
                    if (!split.startsWith(opt)) continue;
                    foundProperty = true;
                    map.put(opt, split.substring(opt.length()));
                    break;
                }
                if (foundProperty) continue;
                if (currentProperties == null) {
                    currentProperties = Sets.newHashSet();
                }
                currentProperties.add(split);
            }
        }
        if (map.get(XMX) == null) {
            int memoryOverhead = memory / 4;
            int heapSize = memory - memoryOverhead;
            if (memoryOverhead > 1024) {
                heapSize = memory - 1024;
            }
            map.put(XMX, heapSize + "m");
        }
        map.put(GENERIC, currentProperties);
        return map;
    }
}

