/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

public interface NumberAggregate {
    public Number getMin();

    public Number getMax();

    public Number getSum();

    public Number getAvg();

    public void addNumber(Number var1);

    public static class DoubleAggregate
    implements NumberAggregate {
        private int count = 0;
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;
        private double sum = 0.0;
        private boolean ignoreSum = false;
        private boolean ignoreAvg = false;

        public DoubleAggregate() {
        }

        public DoubleAggregate(boolean ignoreSum, boolean ignoreAvg) {
            this.ignoreSum = ignoreSum;
            this.ignoreAvg = ignoreAvg;
        }

        @Override
        public void addNumber(Number num) {
            double doubleVal = num.doubleValue();
            if (this.min > doubleVal) {
                this.min = doubleVal;
            }
            if (this.max < doubleVal) {
                this.max = doubleVal;
            }
            this.sum += doubleVal;
            ++this.count;
        }

        @Override
        public Number getMin() {
            return this.count == 0 ? null : Double.valueOf(this.min);
        }

        @Override
        public Number getMax() {
            return this.count == 0 ? null : Double.valueOf(this.max);
        }

        @Override
        public Number getAvg() {
            return this.count == 0 || this.ignoreAvg ? null : Double.valueOf(this.sum / (double)this.count);
        }

        @Override
        public Number getSum() {
            return this.ignoreSum ? null : Double.valueOf(this.sum);
        }
    }

    public static class LongAggregate
    implements NumberAggregate {
        private int count = 0;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private long sum = 0L;
        private boolean ignoreSum = false;
        private boolean ignoreAvg = false;

        public LongAggregate() {
        }

        public LongAggregate(boolean ignoreSum, boolean ignoreAvg) {
            this.ignoreSum = ignoreSum;
            this.ignoreAvg = ignoreAvg;
        }

        @Override
        public void addNumber(Number num) {
            long longVal = num.longValue();
            if (this.min > longVal) {
                this.min = longVal;
            }
            if (this.max < longVal) {
                this.max = longVal;
            }
            this.sum += longVal;
            ++this.count;
        }

        @Override
        public Number getMin() {
            return this.count == 0 ? null : Long.valueOf(this.min);
        }

        @Override
        public Number getMax() {
            return this.count == 0 ? null : Long.valueOf(this.max);
        }

        @Override
        public Number getAvg() {
            return this.count == 0 || this.ignoreAvg ? null : Long.valueOf(this.sum / (long)this.count);
        }

        @Override
        public Number getSum() {
            return this.ignoreSum ? null : Long.valueOf(this.sum);
        }
    }
}

