/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableObject
implements Serializable {
    private static final long serialVersionUID = 201505211622L;
    private static final Logger logger = LoggerFactory.getLogger(SerializableObject.class);

    public Object readResolve() throws ObjectStreamException {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(this.getClass());
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException ex) {
                logger.warn("Accessing copy constructor {} failed.", constructor, (Object)ex);
            }
            try {
                return constructor.newInstance(this);
            }
            catch (IllegalArgumentException | ReflectiveOperationException ex) {
                throw new RuntimeException("Instantiation using copy constructor failed!", ex);
            }
        }
        catch (NoSuchMethodException snme) {
            logger.debug("No copy constructor detected for class {}, trying default constructor.", (Object)this.getClass().getSimpleName());
            try {
                SerializableObject newInstance = (SerializableObject)this.getClass().newInstance();
                this.transferStateTo(newInstance);
                return newInstance;
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Deserialization using default constructor failed!", ex);
            }
        }
    }

    public void transferStateTo(Object dest) {
        Class<?> clazz = this.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException ex) {
                    logger.warn("Cannot set field {} accessible.", (Object)field, (Object)ex);
                }
                try {
                    field.set(dest, field.get(this));
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException("Getter/Setter argument failed using reflection on " + field, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Getter/Setter access failed using reflection on " + field, ex);
                }
                if (field.getType().isPrimitive()) continue;
                try {
                    field.set(this, null);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.warn("Failed to set field {} to null; generally it's harmless, but with reference counted data structure this may be an issue.", (Object)field, (Object)ex);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }
}

