/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.codec;

import com.datatorrent.api.StreamCodec;
import com.datatorrent.api.StringCodec;
import com.datatorrent.common.util.JacksonObjectMapperProvider;
import com.datatorrent.netlet.util.Slice;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStreamCodec<T>
implements StreamCodec<T> {
    private ObjectMapper mapper;
    private static final Logger logger = LoggerFactory.getLogger(JsonStreamCodec.class);

    public JsonStreamCodec() {
        this.mapper = new JacksonObjectMapperProvider().getContext(null);
    }

    public JsonStreamCodec(Map<Class<?>, Class<? extends StringCodec<?>>> codecs) {
        JacksonObjectMapperProvider jomp = new JacksonObjectMapperProvider();
        if (codecs != null) {
            for (Map.Entry<Class<?>, Class<StringCodec<?>>> entry : codecs.entrySet()) {
                try {
                    final StringCodec<?> codec = entry.getValue().newInstance();
                    jomp.addSerializer(new SerializerBase(entry.getKey()){

                        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                            jgen.writeString(codec.toString(value));
                        }
                    });
                }
                catch (Exception ex) {
                    logger.error("Caught exception when instantiating codec for class {}", (Object)entry.getKey().getName(), (Object)ex);
                }
            }
        }
        this.mapper = jomp.getContext(null);
    }

    public Object fromByteArray(Slice data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data.buffer, data.offset, data.length);
        try {
            return this.mapper.readValue((InputStream)bis, Object.class);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Slice toByteArray(T o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.mapper.writeValue((OutputStream)bos, o);
            byte[] bytes = bos.toByteArray();
            return new Slice(bytes, 0, bytes.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getPartition(T o) {
        return o.hashCode();
    }
}

