/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import com.datatorrent.api.StorageAgent;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSStorageAgent
implements StorageAgent,
Serializable {
    public static final String TMP_FILE = "_tmp";
    protected static final String STATELESS_CHECKPOINT_WINDOW_ID = Long.toHexString(-1L);
    public final String path;
    protected final transient FileContext fileContext;
    protected static final transient Kryo kryo = new Kryo();
    private static final long serialVersionUID = 201404031201L;
    private static final Logger logger = LoggerFactory.getLogger(FSStorageAgent.class);

    protected FSStorageAgent() {
        this.path = null;
        this.fileContext = null;
    }

    public FSStorageAgent(String path, Configuration conf) {
        this.path = path;
        try {
            logger.debug("Initialize storage agent with {}.", (Object)path);
            Path lPath = new Path(path);
            URI pathUri = lPath.toUri();
            this.fileContext = pathUri.getScheme() != null ? FileContext.getFileContext((URI)pathUri, (Configuration)(conf == null ? new Configuration() : conf)) : FileContext.getFileContext((Configuration)(conf == null ? new Configuration() : conf));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Object object, int operatorId, long windowId) throws IOException {
        String operatorIdStr = String.valueOf(operatorId);
        Path lPath = new Path(this.path + "/" + operatorIdStr + "/" + TMP_FILE);
        String window = Long.toHexString(windowId);
        boolean stateSaved = false;
        FSDataOutputStream stream = null;
        stream = this.fileContext.create(lPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.CreateParent.createParent()});
        FSStorageAgent.store((OutputStream)stream, object);
        stateSaved = true;
        try {
            if (stream != null) {
                stream.close();
            }
            if (!stateSaved) return;
        }
        catch (IOException ie) {
            try {
                stateSaved = false;
                throw new RuntimeException(ie);
            }
            catch (Throwable throwable) {
                if (!stateSaved) throw throwable;
                logger.debug("Saving {}: {}", (Object)operatorId, (Object)window);
                this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                throw throwable;
            }
        }
        logger.debug("Saving {}: {}", (Object)operatorId, (Object)window);
        this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
        return;
        catch (Throwable t) {
            try {
                logger.debug("while saving {} {}", new Object[]{operatorId, window, t});
                stateSaved = false;
                throw Throwables.propagate((Throwable)t);
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (!stateSaved) throw throwable;
                }
                catch (IOException ie) {
                    try {
                        stateSaved = false;
                        throw new RuntimeException(ie);
                    }
                    catch (Throwable throwable2) {
                        if (!stateSaved) throw throwable2;
                        logger.debug("Saving {}: {}", (Object)operatorId, (Object)window);
                        this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                        throw throwable2;
                    }
                }
                logger.debug("Saving {}: {}", (Object)operatorId, (Object)window);
                this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(int operatorId, long windowId) throws IOException {
        Path lPath = new Path(this.path + "/" + String.valueOf(operatorId) + "/" + Long.toHexString(windowId));
        logger.debug("Loading: {}", (Object)lPath);
        try (FSDataInputStream stream = this.fileContext.open(lPath);){
            Object object = FSStorageAgent.retrieve((InputStream)stream);
            return object;
        }
    }

    public void delete(int operatorId, long windowId) throws IOException {
        Path lPath = new Path(this.path + "/" + String.valueOf(operatorId) + "/" + Long.toHexString(windowId));
        logger.debug("Deleting: {}", (Object)lPath);
        this.fileContext.delete(lPath, false);
    }

    public long[] getWindowIds(int operatorId) throws IOException {
        Path lPath = new Path(this.path + "/" + String.valueOf(operatorId));
        RemoteIterator fileStatusRemoteIterator = this.fileContext.listStatus(lPath);
        if (!fileStatusRemoteIterator.hasNext()) {
            throw new IOException("Storage Agent has not saved anything yet!");
        }
        ArrayList<Long> lwindows = new ArrayList<Long>();
        do {
            FileStatus fileStatus;
            String name;
            if ((name = (fileStatus = (FileStatus)fileStatusRemoteIterator.next()).getPath().getName()).equals(TMP_FILE)) continue;
            lwindows.add(STATELESS_CHECKPOINT_WINDOW_ID.equals(name) ? -1L : Long.parseLong(name, 16));
        } while (fileStatusRemoteIterator.hasNext());
        long[] windowIds = new long[lwindows.size()];
        for (int i = 0; i < windowIds.length; ++i) {
            windowIds[i] = (Long)lwindows.get(i);
        }
        return windowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(OutputStream stream, Object operator) {
        Kryo kryo = FSStorageAgent.kryo;
        synchronized (kryo) {
            Output output = new Output(4096, Integer.MAX_VALUE);
            output.setOutputStream(stream);
            FSStorageAgent.kryo.writeClassAndObject(output, operator);
            output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object retrieve(InputStream stream) {
        Kryo kryo = FSStorageAgent.kryo;
        synchronized (kryo) {
            FSStorageAgent.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            Input input = new Input(stream);
            return FSStorageAgent.kryo.readClassAndObject(input);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return new FSStorageAgent(this.path, null);
    }
}

