/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.stram.StreamingContainerManager;
import com.datatorrent.stram.plan.physical.PTContainer;
import com.datatorrent.stram.plan.physical.PTOperator;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Journal {
    private static final Logger LOG = LoggerFactory.getLogger(Journal.class);
    private final StreamingContainerManager scm;
    private final AtomicReference<Output> output;
    private final AtomicBoolean replayMode;

    public Journal(StreamingContainerManager scm) {
        this.scm = scm;
        this.output = new AtomicReference();
        this.replayMode = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(@Nullable OutputStream out) throws IOException {
        Output output;
        if (out != null) {
            output = new Output(4096, -1){

                public void flush() throws KryoException {
                    super.flush();
                    try {
                        this.getOutputStream().flush();
                    }
                    catch (IOException e) {
                        throw new KryoException((Throwable)e);
                    }
                }
            };
            output.setOutputStream(out);
        } else {
            output = null;
        }
        Output oldOut = this.output.getAndSet(output);
        if (oldOut != null && oldOut.getOutputStream() != out) {
            Output output2 = oldOut;
            synchronized (output2) {
                oldOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void write(Recoverable op) {
        block9: {
            Output out;
            if (this.replayMode.get()) {
                throw new IllegalStateException("Request to write while journal is replaying operations");
            }
            Integer classId = RecoverableOperation.getId(op.getClass());
            if (classId == null) {
                throw new IllegalArgumentException("Class not registered " + op.getClass());
            }
            while ((out = this.output.get()) != null) {
                Output output = out;
                synchronized (output) {
                    try {
                        LOG.debug("WAL write {}", (Object)RecoverableOperation.get(classId));
                        out.writeInt(classId.intValue());
                        op.write(out);
                        out.flush();
                        break block9;
                    }
                    catch (KryoException e) {
                        if (this.output.get() == out) {
                            throw e;
                        }
                    }
                }
            }
            LOG.warn("Journal output stream is null. Skipping write to the WAL.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replay(InputStream input) {
        if (this.replayMode.compareAndSet(false, true)) {
            Input in = new Input(input);
            try {
                LOG.debug("Start replaying WAL");
                block7: while (!in.eof()) {
                    int opId = in.readInt();
                    RecoverableOperation recoverableOperation = RecoverableOperation.get(opId);
                    if (recoverableOperation == null) {
                        throw new IllegalArgumentException("No reader registered for id " + opId);
                    }
                    LOG.debug("Replaying {}", (Object)recoverableOperation);
                    switch (recoverableOperation) {
                        case OPERATOR_STATE: 
                        case CONTAINER_STATE: {
                            recoverableOperation.operation.read(this.scm.getPhysicalPlan(), in);
                            continue block7;
                        }
                        case OPERATOR_PROPERTY: 
                        case PHYSICAL_OPERATOR_PROPERTY: {
                            recoverableOperation.operation.read(this.scm, in);
                            continue block7;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported recoverable operation " + (Object)((Object)recoverableOperation));
                }
            }
            finally {
                LOG.debug("Done replaying WAL");
                this.replayMode.set(false);
            }
        } else {
            throw new IllegalStateException("Request to replay while journal is already replaying other operations");
        }
    }

    public static interface Recoverable {
        public void read(Object var1, Input var2) throws KryoException;

        public void write(Output var1) throws KryoException;
    }

    private static enum RecoverableOperation {
        OPERATOR_STATE(PTOperator.SET_OPERATOR_STATE),
        CONTAINER_STATE(PTContainer.SET_CONTAINER_STATE),
        OPERATOR_PROPERTY(StreamingContainerManager.SET_OPERATOR_PROPERTY),
        PHYSICAL_OPERATOR_PROPERTY(StreamingContainerManager.SET_PHYSICAL_OPERATOR_PROPERTY);

        private static final Map<Class<? extends Recoverable>, Integer> classToId;
        private final Recoverable operation;

        private RecoverableOperation(Recoverable operation) {
            this.operation = operation;
        }

        private static RecoverableOperation get(int id) {
            return id < RecoverableOperation.values().length ? RecoverableOperation.values()[id] : null;
        }

        private static Integer getId(Class<? extends Recoverable> operationClass) {
            return classToId.get(operationClass);
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (RecoverableOperation recoverableOperation : RecoverableOperation.values()) {
                builder.put(recoverableOperation.operation.getClass(), (Object)recoverableOperation.ordinal());
            }
            classToId = builder.build();
        }
    }
}

