/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.api.DAG;
import com.datatorrent.api.LocalMode;
import com.datatorrent.api.StreamingApplication;
import com.datatorrent.stram.StramLocalCluster;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import org.apache.hadoop.conf.Configuration;

public class LocalModeImpl
extends LocalMode {
    private final LogicalPlan lp = new LogicalPlan();

    public DAG getDAG() {
        return this.lp;
    }

    public DAG cloneDAG() throws Exception {
        return StramLocalCluster.cloneLogicalPlan(this.lp);
    }

    public DAG prepareDAG(StreamingApplication app, Configuration conf) throws Exception {
        if (app == null && conf == null) {
            throw new IllegalArgumentException("Require app or configuration to populate logical plan.");
        }
        if (conf == null) {
            conf = new Configuration(false);
        }
        LogicalPlanConfiguration lpc = new LogicalPlanConfiguration(conf);
        String appName = app != null ? app.getClass().getName() : "unknown";
        lpc.prepareDAG(this.lp, app, appName);
        return this.lp;
    }

    public LocalMode.Controller getController() {
        try {
            return new StramLocalCluster(this.lp);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating local cluster", e);
        }
    }
}

