/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import java.util.Map;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.log4j.DTLoggerFactory;

public abstract class StramUtils {
    public static <T> Class<? extends T> classForName(String className, Class<T> superClass) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className).asSubclass(superClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz, e);
        }
    }

    public static abstract class YarnContainerMain {
        static {
            Map<String, String> envs = System.getenv();
            String containerIdString = envs.get(ApplicationConstants.Environment.CONTAINER_ID.name());
            if (containerIdString != null) {
                System.setProperty("dt.cid", containerIdString);
            }
            System.setProperty("hadoop.log.file", "dt.log");
            if (envs.get("CDH_YARN_HOME") != null) {
                String[] keys;
                for (String key : keys = new String[]{"log.dir", "log.file", "root.logger"}) {
                    String v = System.getProperty("hadoop." + key);
                    if (v == null) continue;
                    System.setProperty(key, v);
                }
            }
            DTLoggerFactory.getInstance().initialize();
        }
    }
}

