/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.api.StringCodec;
import com.datatorrent.netlet.util.DTThrowable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringCodecs {
    private static final ConcurrentHashMap<ClassLoader, Boolean> classLoaders = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<? extends StringCodec<?>>> codecs = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(StringCodecs.class);

    private StringCodecs() {
    }

    public static void loadDefaultConverters() {
        LOG.debug("Loading default converters for BeanUtils");
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                for (Class<?> clazz = value.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    StringCodec instance;
                    Class codec = (Class)codecs.get(clazz);
                    if (codec == null) continue;
                    try {
                        instance = (StringCodec)codec.newInstance();
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException("Internal Error - it's impossible for this exception to be thrown!", ex);
                    }
                    catch (InstantiationException ex) {
                        throw new RuntimeException("Internal Error - it's impossible for this exception to be thrown!", ex);
                    }
                    return instance.toString(value);
                }
                return value.toString();
            }
        }, String.class);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                return value == null ? null : URI.create(value.toString());
            }
        }, URI.class);
    }

    public static void clear() {
        for (Map.Entry<Class<?>, Class<StringCodec<?>>> entry : codecs.entrySet()) {
            ConvertUtils.deregister(entry.getKey());
        }
        codecs.clear();
    }

    public static void loadConverters(Map<Class<?>, Class<? extends StringCodec<?>>> map) {
        StringCodecs.check();
        if (map == null) {
            return;
        }
        for (Map.Entry<Class<?>, Class<StringCodec<?>>> entry : map.entrySet()) {
            try {
                StringCodecs.register(entry.getValue(), entry.getKey());
            }
            catch (Exception ex) {
                DTThrowable.rethrow((Exception)ex);
            }
        }
    }

    public static void check() {
        if (classLoaders.putIfAbsent(Thread.currentThread().getContextClassLoader(), Boolean.TRUE) == null) {
            StringCodecs.loadDefaultConverters();
            for (Map.Entry<Class<?>, Class<StringCodec<?>>> entry : codecs.entrySet()) {
                try {
                    final StringCodec<?> codecInstance = entry.getValue().newInstance();
                    ConvertUtils.register((Converter)new Converter(){

                        public Object convert(Class type, Object value) {
                            return value == null ? null : codecInstance.fromString(value.toString());
                        }
                    }, entry.getKey());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static <T> void deregister(Class<T> clazz) {
        ConvertUtils.deregister(clazz);
        codecs.remove(clazz);
    }

    public static <T> void register(Class<? extends StringCodec<?>> codec, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        StringCodecs.check();
        final StringCodec<?> codecInstance = codec.newInstance();
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                return value == null ? null : codecInstance.fromString(value.toString());
            }
        }, clazz);
        codecs.put(clazz, codec);
    }
}

