/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class AppDataSource {
    private Type type;
    private String operatorName;
    private String portName;
    private final QueryInfo query = new QueryInfo();
    private final ResultInfo result = new ResultInfo();
    private Map<String, String> schemaKeys;

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.operatorName + "." + this.portName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getPortName() {
        return this.portName;
    }

    public QueryInfo getQuery() {
        return this.query;
    }

    public ResultInfo getResult() {
        return this.result;
    }

    public Map<String, String> getSchemaKeys() {
        return this.schemaKeys;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSchemaKeys(Map<String, String> schemaKeys) {
        this.schemaKeys = schemaKeys;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setQueryOperatorName(String name) {
        this.query.operatorName = name;
    }

    public void setQueryUrl(String queryUrl) {
        this.query.url = queryUrl;
    }

    public void setQueryTopic(String queryTopic) {
        this.query.topic = queryTopic;
    }

    public void setResultOperatorName(String name) {
        this.result.operatorName = name;
    }

    public void setResultUrl(String resultUrl) {
        this.result.url = resultUrl;
    }

    public void setResultTopic(String resultTopic) {
        this.result.topic = resultTopic;
    }

    public void setResultAppendQIDTopic(boolean b) {
        this.result.appendQIDToTopic = b;
    }

    public static enum Type {
        DAG("dag"),
        APP_STATS("appStats"),
        OPERATOR_STATS("operatorStats"),
        CUSTOM_METRICS("metrics");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class ResultInfo {
        public String operatorName;
        public String url;
        public String topic;
        public boolean appendQIDToTopic;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class QueryInfo {
        public String operatorName;
        public String url;
        public String topic;
    }
}

