/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.api.Stats;
import com.datatorrent.bufferserver.util.Codec;
import java.util.Comparator;

public class Checkpoint
implements Stats.Checkpoint {
    public final long windowId;
    public final int applicationWindowCount;
    public final int checkpointWindowCount;
    public static final Checkpoint INITIAL_CHECKPOINT = new Checkpoint(-1L, 0, 0);
    private static final long serialVersionUID = 201402152116L;

    public Checkpoint(long windowId, int appCount, int checkpointCount) {
        this.windowId = windowId;
        this.applicationWindowCount = appCount;
        this.checkpointWindowCount = checkpointCount;
    }

    public String toString() {
        return '{' + Codec.getStringWindowId((long)this.windowId) + ", " + this.applicationWindowCount + ", " + this.checkpointWindowCount + '}';
    }

    public static Checkpoint min(Checkpoint first, Checkpoint second) {
        if (first.windowId < second.windowId) {
            return first;
        }
        return second;
    }

    public static Checkpoint max(Checkpoint first, Checkpoint second) {
        if (first.windowId < second.windowId) {
            return second;
        }
        return first;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (int)(this.windowId ^ this.windowId >>> 32);
        hash = 29 * hash + this.applicationWindowCount;
        hash = 29 * hash + this.checkpointWindowCount;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Checkpoint other = (Checkpoint)obj;
        if (this.windowId != other.windowId) {
            return false;
        }
        if (this.applicationWindowCount != other.applicationWindowCount) {
            return false;
        }
        return this.checkpointWindowCount == other.checkpointWindowCount;
    }

    public long getWindowId() {
        return this.windowId;
    }

    public static class CheckpointComparator
    implements Comparator<Checkpoint> {
        @Override
        public int compare(Checkpoint o1, Checkpoint o2) {
            return Long.compare(o1.windowId, o2.windowId);
        }
    }
}

