/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.stram.plan.logical.requests.LogicalPlanRequest;
import java.util.concurrent.atomic.AtomicLong;

public abstract class StramEvent {
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final long id;
    private long timestamp = System.currentTimeMillis();
    private String reason;

    public abstract String getType();

    protected StramEvent() {
        this.id = nextId.getAndIncrement();
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public static class ContainerErrorEvent
    extends StramEvent {
        private String containerId;
        private String errorMessage;

        public ContainerErrorEvent(String containerId, String errorMessage) {
            this.containerId = containerId;
            this.errorMessage = errorMessage;
        }

        @Override
        public String getType() {
            return "ContainerError";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class OperatorErrorEvent
    extends PhysicalOperatorEvent {
        private String containerId;
        private String errorMessage;

        public OperatorErrorEvent(String operatorName, int operatorId, String containerId, String errorMessage) {
            super(operatorName, operatorId);
            this.containerId = containerId;
            this.errorMessage = errorMessage;
        }

        @Override
        public String getType() {
            return "OperatorError";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class ChangeLogicalPlanEvent
    extends StramEvent {
        private LogicalPlanRequest request;

        public ChangeLogicalPlanEvent(LogicalPlanRequest request) {
            this.request = request;
        }

        @Override
        public String getType() {
            return "ChangeLogicalPlan";
        }

        public LogicalPlanRequest getRequest() {
            return this.request;
        }

        public void setRequest(LogicalPlanRequest request) {
            this.request = request;
        }
    }

    public static class StopContainerEvent
    extends StramEvent {
        String containerId;
        int exitStatus;

        public StopContainerEvent(String containerId, int exitStatus) {
            this.containerId = containerId;
            this.exitStatus = exitStatus;
        }

        @Override
        public String getType() {
            return "StopContainer";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }

        public void setExitStatus(int exitStatus) {
            this.exitStatus = exitStatus;
        }
    }

    public static class StartContainerEvent
    extends StramEvent {
        String containerId;
        String containerNodeId;

        public StartContainerEvent(String containerId, String containerNodeId) {
            this.containerId = containerId;
            this.containerNodeId = containerNodeId;
        }

        @Override
        public String getType() {
            return "StartContainer";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerNodeId() {
            return this.containerNodeId;
        }

        public void setContainerNodeId(String containerNodeId) {
            this.containerNodeId = containerNodeId;
        }
    }

    public static class SetPhysicalOperatorPropertyEvent
    extends PhysicalOperatorEvent {
        private String propertyName;
        private String propertyValue;

        public SetPhysicalOperatorPropertyEvent(String operatorName, int operatorId, String propertyName, String propertyValue) {
            super(operatorName, operatorId);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Override
        public String getType() {
            return "SetPhysicalOperatorProperty";
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }

    public static class StopOperatorEvent
    extends PhysicalOperatorEvent {
        private String containerId;

        public StopOperatorEvent(String operatorName, int operatorId, String containerId) {
            super(operatorName, operatorId);
            this.containerId = containerId;
        }

        @Override
        public String getType() {
            return "StopOperator";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }
    }

    public static class StartOperatorEvent
    extends PhysicalOperatorEvent {
        private String containerId;

        public StartOperatorEvent(String operatorName, int operatorId, String containerId) {
            super(operatorName, operatorId);
            this.containerId = containerId;
        }

        @Override
        public String getType() {
            return "StartOperator";
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }
    }

    public static class RemoveOperatorEvent
    extends PhysicalOperatorEvent {
        public RemoveOperatorEvent(String operatorName, int operatorId) {
            super(operatorName, operatorId);
        }

        @Override
        public String getType() {
            return "RemoveOperator";
        }
    }

    public static class CreateOperatorEvent
    extends PhysicalOperatorEvent {
        public CreateOperatorEvent(String operatorName, int operatorId) {
            super(operatorName, operatorId);
        }

        @Override
        public String getType() {
            return "CreateOperator";
        }
    }

    public static abstract class PhysicalOperatorEvent
    extends OperatorEvent {
        private final int operatorId;

        public PhysicalOperatorEvent(String operatorName, int operatorId) {
            super(operatorName);
            this.operatorId = operatorId;
        }

        public int getOperatorId() {
            return this.operatorId;
        }
    }

    public static class PartitionEvent
    extends OperatorEvent {
        private int oldNumPartitions;
        private int newNumPartitions;

        public PartitionEvent(String operatorName, int oldNumPartitions, int newNumPartitions) {
            super(operatorName);
            this.oldNumPartitions = oldNumPartitions;
            this.newNumPartitions = newNumPartitions;
        }

        @Override
        public String getType() {
            return "Partition";
        }

        public int getOldNumPartitions() {
            return this.oldNumPartitions;
        }

        public void setOldNumPartitions(int oldNumPartitions) {
            this.oldNumPartitions = oldNumPartitions;
        }

        public int getNewNumPartitions() {
            return this.newNumPartitions;
        }

        public void setNewNumPartitions(int newNumPartitions) {
            this.newNumPartitions = newNumPartitions;
        }
    }

    public static class SetOperatorPropertyEvent
    extends OperatorEvent {
        private String propertyName;
        private String propertyValue;

        public SetOperatorPropertyEvent(String operatorName, String propertyName, String propertyValue) {
            super(operatorName);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Override
        public String getType() {
            return "SetOperatorProperty";
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }

    public static abstract class OperatorEvent
    extends StramEvent {
        private String operatorName;

        public OperatorEvent(String operatorName) {
            this.operatorName = operatorName;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }
    }
}

