/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.Stats;
import com.datatorrent.api.StatsListener;
import com.datatorrent.stram.api.BaseContext;
import com.datatorrent.stram.api.ContainerContext;
import com.datatorrent.stram.api.OperatorDeployInfo;
import com.datatorrent.stram.util.AbstractWritableAdapter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.VersionedProtocol;

@InterfaceAudience.Private
@InterfaceStability.Stable
public interface StreamingContainerUmbilicalProtocol
extends VersionedProtocol {
    public static final long versionID = 201208081755L;

    public StreamingContainerContext getInitContext(String var1) throws IOException;

    public void log(String var1, String var2) throws IOException;

    public void reportError(String var1, int[] var2, String var3);

    public ContainerHeartbeatResponse processHeartbeat(ContainerHeartbeat var1);

    public static class ContainerHeartbeatResponse
    extends AbstractWritableAdapter {
        private static final long serialVersionUID = 1L;
        public boolean shutdown;
        public List<StramToNodeRequest> nodeRequests;
        public boolean hasPendingRequests = false;
        public List<Integer> undeployRequest;
        public List<OperatorDeployInfo> deployRequest;
        public long committedWindowId = -1L;
    }

    public static class StramToNodeRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int operatorId;
        public RequestType requestType;
        public long recoveryCheckpoint;
        public String portName;
        public boolean deleted;
        public StatsListener.OperatorRequest cmd;
        public long requestId;

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        public void setOperatorId(int id) {
            this.operatorId = id;
        }

        public RequestType getRequestType() {
            return this.requestType;
        }

        public void setRequestType(RequestType requestType) {
            this.requestType = requestType;
        }

        public long getRecoveryCheckpoint() {
            return this.recoveryCheckpoint;
        }

        public void setRecoveryCheckpoint(long recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("operatorId", this.operatorId).append("requestType", (Object)this.requestType).append("portName", (Object)this.portName).toString();
        }

        public static enum RequestType {
            START_RECORDING,
            STOP_RECORDING,
            SYNC_RECORDING,
            SET_LOG_LEVEL,
            CUSTOM;

        }
    }

    public static class ContainerHeartbeat
    extends AbstractWritableAdapter {
        private static final long serialVersionUID = 1L;
        public String bufferServerHost;
        public int bufferServerPort;
        public String jvmName;
        public int memoryMBFree;
        public boolean restartRequested;
        public long gcCollectionTime;
        public long gcCollectionCount;
        public ContainerStats stats;
        public long sentTms = System.currentTimeMillis();

        public ContainerStats getContainerStats() {
            return this.stats;
        }

        public void setContainerStats(ContainerStats stats) {
            this.stats = stats;
        }

        public String getContainerId() {
            return this.stats.id;
        }
    }

    public static class ContainerStats
    implements Stats {
        private static final long serialVersionUID = 201309131904L;
        public final String id;
        public ArrayList<OperatorHeartbeat> operators;

        public ContainerStats(String id) {
            this.id = id;
            this.operators = new ArrayList();
        }

        public String toString() {
            return "ContainerStats{id=" + this.id + ", operators=" + this.operators + '}';
        }

        public void addNodeStats(OperatorHeartbeat sn) {
            this.operators.add(sn);
        }
    }

    public static class OperatorHeartbeat
    implements Serializable {
        private static final long serialVersionUID = 201208171625L;
        public ArrayList<Stats.OperatorStats> windowStats = new ArrayList();
        public int nodeId;
        public long generatedTms;
        public long intervalMs;
        public DeployState state;
        public ArrayList<StatsListener.OperatorResponse> requestResponse;

        public ArrayList<Stats.OperatorStats> getOperatorStatsContainer() {
            return this.windowStats;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(int nodeId) {
            this.nodeId = nodeId;
        }

        public long getGeneratedTms() {
            return this.generatedTms;
        }

        public void setGeneratedTms(long generatedTms) {
            this.generatedTms = generatedTms;
        }

        public long getIntervalMs() {
            return this.intervalMs;
        }

        public void setIntervalMs(long intervalMs) {
            this.intervalMs = intervalMs;
        }

        public DeployState getState() {
            return this.state;
        }

        public void setState(DeployState state) {
            this.state = state;
        }

        public static enum DeployState {
            ACTIVE,
            SHUTDOWN,
            FAILED;

        }
    }

    public static class StreamingContainerContext
    extends BaseContext
    implements ContainerContext {
        public long startWindowMillis;
        public boolean deployBufferServer = true;
        private static final long serialVersionUID = 201209071402L;

        private StreamingContainerContext() {
            super(null, null);
        }

        public StreamingContainerContext(Attribute.AttributeMap map, Context parentContext) {
            super(map, parentContext);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("applicationAttributes", (Object)this.getAttributes()).toString();
        }
    }
}

