/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.util.FSUtil;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSAgent {
    private static final Logger LOG = LoggerFactory.getLogger(FSAgent.class);
    protected FileSystem fileSystem;

    public FSAgent(FileSystem fs) {
        this.fileSystem = fs;
    }

    public void createFile(String path, byte[] content) throws IOException {
        this.createFile(new Path(path), content);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void createDirectory(Path path) throws IOException {
        FSUtil.mkdirs(this.fileSystem, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(Path path, byte[] content) throws IOException {
        try (FSDataOutputStream os = this.fileSystem.create(path);){
            os.write(content);
        }
    }

    public void deleteFile(String path) throws IOException {
        this.deleteFile(new Path(path));
    }

    public void deleteFileRecursive(String path) throws IOException {
        this.deleteFileRecursive(new Path(path));
    }

    public void deleteFile(Path path) throws IOException {
        this.fileSystem.delete(path, false);
    }

    public void deleteFileRecursive(Path path) throws IOException {
        this.fileSystem.delete(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFullFileContent(Path path) throws IOException {
        DataInputStream is = new DataInputStream((InputStream)this.fileSystem.open(path));
        byte[] bytes = new byte[is.available()];
        try {
            is.readFully(bytes);
        }
        finally {
            is.close();
        }
        return bytes;
    }

    public InputStreamReader openInputStreamReader(Path path) throws IOException {
        return new InputStreamReader((InputStream)this.fileSystem.open(path));
    }

    public List<String> listFiles(String dir) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        Path path = new Path(dir);
        FileStatus fileStatus = this.fileSystem.getFileStatus(path);
        if (!fileStatus.isDirectory()) {
            throw new FileNotFoundException("Cannot read directory " + dir);
        }
        RemoteIterator it = this.fileSystem.listFiles(path, false);
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            files.add(lfs.getPath().getName());
        }
        return files;
    }

    public List<LocatedFileStatus> listFilesInfo(String dir) throws IOException {
        ArrayList<LocatedFileStatus> files = new ArrayList<LocatedFileStatus>();
        Path path = new Path(dir);
        FileStatus fileStatus = this.fileSystem.getFileStatus(path);
        if (!fileStatus.isDirectory()) {
            throw new FileNotFoundException("Cannot read directory " + dir);
        }
        RemoteIterator it = this.fileSystem.listFiles(path, false);
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            files.add(lfs);
        }
        return files;
    }
}

