/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.client.StramAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FSPartFileAgent {
    private static final Logger LOG = LoggerFactory.getLogger(FSPartFileAgent.class);
    private final Map<String, String> lastIndexLines = new HashMap<String, String>();
    protected final StramAgent stramAgent;

    protected abstract IndexLine parseIndexLine(String var1) throws JSONException;

    public FSPartFileAgent(StramAgent stramAgent) {
        this.stramAgent = stramAgent;
    }

    public void setLastIndexLine(String basePath, String line) {
        this.lastIndexLines.put(basePath, line);
    }

    public static String getNextPartFile(String partFile) {
        if (partFile == null) {
            return "part0.txt";
        }
        if (partFile.startsWith("part") && partFile.endsWith(".txt")) {
            return "part" + (Integer.valueOf(partFile.substring(4, partFile.length() - 4)) + 1) + ".txt";
        }
        return null;
    }

    protected class IndexFileBufferedReader
    extends BufferedReader {
        private final String basePath;
        private boolean lastLineReturned;
        private String lastPartFile;

        IndexFileBufferedReader(InputStreamReader reader, String basePath) {
            super(reader);
            this.lastLineReturned = false;
            this.basePath = basePath;
        }

        public IndexLine readIndexLine() throws IOException, JSONException {
            String line = super.readLine();
            if (line == null && !this.lastLineReturned) {
                line = (String)FSPartFileAgent.this.lastIndexLines.get(this.basePath);
                if (line == null) {
                    return null;
                }
                this.lastLineReturned = true;
                IndexLine il = FSPartFileAgent.this.parseIndexLine(line);
                if (il.partFile != null && !il.partFile.equals(this.lastPartFile)) {
                    return il;
                }
                FSPartFileAgent.this.lastIndexLines.remove(this.basePath);
                return null;
            }
            if (line != null) {
                IndexLine il = FSPartFileAgent.this.parseIndexLine(line);
                this.lastPartFile = il.partFile;
                return il;
            }
            return null;
        }
    }

    protected static class IndexLine {
        public boolean isEndLine = false;
        public String partFile;

        protected IndexLine() {
        }
    }
}

