/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.api.StreamingApplication;
import com.datatorrent.api.annotation.ApplicationAnnotation;
import com.datatorrent.stram.StramClient;
import com.datatorrent.stram.StramLocalCluster;
import com.datatorrent.stram.StramUtils;
import com.datatorrent.stram.StringCodecs;
import com.datatorrent.stram.client.ClassPathResolvers;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramAppLauncher {
    public static final String CLASSPATH_RESOLVERS_KEY_NAME = "dt.classpath.resolvers";
    public static final String LIBJARS_CONF_KEY_NAME = "tmplibjars";
    public static final String FILES_CONF_KEY_NAME = "tmpfiles";
    public static final String ARCHIVES_CONF_KEY_NAME = "tmparchives";
    public static final String ORIGINAL_APP_ID = "tmpOriginalAppId";
    public static final String QUEUE_NAME = "queueName";
    private static final Logger LOG = LoggerFactory.getLogger(StramAppLauncher.class);
    private File jarFile;
    private FileSystem fs;
    private final LogicalPlanConfiguration propertiesBuilder;
    private final List<AppFactory> appResourceList = new ArrayList<AppFactory>();
    private LinkedHashSet<URL> launchDependencies;
    private LinkedHashSet<File> deployJars;
    private final StringWriter mvnBuildClasspathOutput = new StringWriter();

    public StramAppLauncher(File appJarFile, Configuration conf) throws Exception {
        this.jarFile = appJarFile;
        this.propertiesBuilder = new LogicalPlanConfiguration(conf);
        this.init(this.jarFile.getName());
    }

    public StramAppLauncher(FileSystem fs, Path path, Configuration conf) throws Exception {
        File jarsDir = new File(StramClientUtils.getUserDTDirectory(), "jars");
        jarsDir.mkdirs();
        File localJarFile = new File(jarsDir, path.getName());
        this.fs = fs;
        fs.copyToLocalFile(path, new Path(localJarFile.getAbsolutePath()));
        this.jarFile = localJarFile;
        this.propertiesBuilder = new LogicalPlanConfiguration(conf);
        this.init(this.jarFile.getName());
    }

    public StramAppLauncher(String name, Configuration conf) throws Exception {
        this.propertiesBuilder = new LogicalPlanConfiguration(conf);
        this.init(name);
    }

    public String getMvnBuildClasspathOutput() {
        return this.mvnBuildClasspathOutput.toString();
    }

    private void init(String tmpName) throws Exception {
        LinkedHashSet<URL> clUrls;
        File baseDir = StramClientUtils.getUserDTDirectory();
        baseDir = new File(new File(baseDir, "appcache"), tmpName);
        baseDir.mkdirs();
        ArrayList<String> classFileNames = new ArrayList<String>();
        if (this.jarFile != null) {
            ClassPathResolvers.JarFileContext jfc = new ClassPathResolvers.JarFileContext(new JarFile(this.jarFile), this.mvnBuildClasspathOutput);
            jfc.cacheDir = baseDir;
            Enumeration<JarEntry> entriesEnum = jfc.jarFile.entries();
            while (entriesEnum.hasMoreElements()) {
                JarEntry jarEntry = entriesEnum.nextElement();
                if (jarEntry.isDirectory()) continue;
                if (jarEntry.getName().endsWith("pom.xml")) {
                    jfc.pomEntry = jarEntry;
                    continue;
                }
                if (jarEntry.getName().endsWith(".app.properties")) {
                    File targetFile = new File(baseDir, jarEntry.getName());
                    FileUtils.copyInputStreamToFile((InputStream)jfc.jarFile.getInputStream(jarEntry), (File)targetFile);
                    this.appResourceList.add(new PropertyFileAppFactory(targetFile));
                    continue;
                }
                if (!jarEntry.getName().endsWith(".class")) continue;
                classFileNames.add(jarEntry.getName());
            }
            URL mainJarUrl = new URL("jar", "", "file:" + this.jarFile.getAbsolutePath() + "!/");
            jfc.urls.add(mainJarUrl);
            this.deployJars = Sets.newLinkedHashSet();
            Collection jarFiles = FileUtils.listFiles((File)this.jarFile.getParentFile(), (String[])new String[]{"jar"}, (boolean)false);
            for (File lJarFile : jarFiles) {
                jfc.urls.add(lJarFile.toURI().toURL());
                this.deployJars.add(lJarFile);
            }
            List<Object> resolvers = Lists.newArrayList();
            String resolverConfig = this.propertiesBuilder.conf.get(CLASSPATH_RESOLVERS_KEY_NAME, null);
            if (!StringUtils.isEmpty((CharSequence)resolverConfig)) {
                resolvers = new ClassPathResolvers().createResolvers(resolverConfig);
            } else {
                String manifestCp = jfc.jarFile.getManifest().getMainAttributes().getValue(ClassPathResolvers.ManifestResolver.ATTR_NAME);
                if (manifestCp != null) {
                    File file = new File(System.getProperty("user.home") + "/.m2/repository");
                    if (file.exists()) {
                        LOG.debug("Resolving manifest attribute {} based on {}", (Object)ClassPathResolvers.ManifestResolver.ATTR_NAME, (Object)file);
                        resolvers.add(new ClassPathResolvers.ManifestResolver(file));
                    } else {
                        LOG.warn("Ignoring manifest attribute {} because {} does not exist.", (Object)ClassPathResolvers.ManifestResolver.ATTR_NAME, (Object)file);
                    }
                }
            }
            for (ClassPathResolvers.Resolver resolver : resolvers) {
                resolver.resolve(jfc);
            }
            jfc.jarFile.close();
            URLConnection urlConnection = mainJarUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                ((JarURLConnection)urlConnection).getJarFile().close();
            }
            clUrls = jfc.urls;
        } else {
            clUrls = new LinkedHashSet<URL>();
        }
        String libjars = this.propertiesBuilder.conf.get(LIBJARS_CONF_KEY_NAME);
        if (libjars != null) {
            this.processLibJars(libjars, clUrls);
        }
        for (URL baseURL : clUrls) {
            LOG.debug("Dependency: {}", (Object)baseURL);
        }
        this.launchDependencies = clUrls;
        this.findAppConfigClasses(classFileNames);
    }

    private void processLibJars(String libjars, Set<URL> clUrls) throws Exception {
        for (String libjar : libjars.split(",")) {
            URI uri = new URI(libjar);
            String scheme = uri.getScheme();
            if (scheme == null) {
                String[] files;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setIncludes(new String[]{libjar});
                scanner.scan();
                for (String file : files = scanner.getIncludedFiles()) {
                    clUrls.add(new URL("file:" + file));
                }
                continue;
            }
            if (scheme.equals("file")) {
                clUrls.add(new URL(libjar));
                continue;
            }
            if (this.fs != null) {
                Path path = new Path(libjar);
                File dependencyJarsDir = new File(StramClientUtils.getUserDTDirectory(), "dependencyJars");
                dependencyJarsDir.mkdirs();
                File localJarFile = new File(dependencyJarsDir, path.getName());
                this.fs.copyToLocalFile(path, new Path(localJarFile.getAbsolutePath()));
                clUrls.add(new URL("file:" + localJarFile.getAbsolutePath()));
                continue;
            }
            throw new NotImplementedException("Jar file needs to be from Hadoop File System also in order for the dependency jars to be in Hadoop File System");
        }
    }

    private void findAppConfigClasses(List<String> classFileNames) {
        URLClassLoader cl = URLClassLoader.newInstance(this.launchDependencies.toArray(new URL[this.launchDependencies.size()]));
        for (final String classFileName : classFileNames) {
            final String className = classFileName.replace('/', '.').substring(0, classFileName.length() - 6);
            try {
                final Class<?> clazz = cl.loadClass(className);
                if (Modifier.isAbstract(clazz.getModifiers()) || !StreamingApplication.class.isAssignableFrom(clazz)) continue;
                AppFactory appConfig = new AppFactory(){

                    @Override
                    public String getName() {
                        return classFileName;
                    }

                    @Override
                    public String getDisplayName() {
                        ApplicationAnnotation an = clazz.getAnnotation(ApplicationAnnotation.class);
                        if (an != null) {
                            return an.name();
                        }
                        return classFileName;
                    }

                    @Override
                    public LogicalPlan createApp(LogicalPlanConfiguration conf) {
                        Class<StreamingApplication> c = StramUtils.classForName(className, StreamingApplication.class);
                        StreamingApplication app = StramUtils.newInstance(c);
                        LogicalPlan dag = new LogicalPlan();
                        conf.prepareDAG(dag, app, this.getName());
                        return dag;
                    }
                };
                this.appResourceList.add(appConfig);
            }
            catch (Throwable e) {
                LOG.error("Unable to load class: " + className + " " + e);
            }
        }
    }

    public static Configuration getOverriddenConfig(Configuration conf, String overrideConfFileName, Map<String, String> overrideProperties) throws IOException {
        if (overrideConfFileName != null) {
            File overrideConfFile = new File(overrideConfFileName);
            if (overrideConfFile.exists()) {
                LOG.info("Loading settings: " + overrideConfFile.toURI());
                conf.addResource(new Path(overrideConfFile.toURI()));
            } else {
                throw new IOException("Problem opening file " + overrideConfFile);
            }
        }
        if (overrideProperties != null) {
            for (Map.Entry<String, String> entry : overrideProperties.entrySet()) {
                conf.set(entry.getKey(), entry.getValue());
            }
        }
        StramClientUtils.evalConfiguration(conf);
        return conf;
    }

    public LogicalPlanConfiguration getLogicalPlanConfiguration() {
        return this.propertiesBuilder;
    }

    public void runLocal(AppFactory appConfig) throws Exception {
        this.loadDependencies();
        this.propertiesBuilder.conf.setEnum("dt.environment", (Enum)StreamingApplication.Environment.LOCAL);
        StramLocalCluster lc = new StramLocalCluster(appConfig.createApp(this.propertiesBuilder));
        lc.run();
    }

    public URLClassLoader loadDependencies() {
        URLClassLoader cl = URLClassLoader.newInstance(this.launchDependencies.toArray(new URL[this.launchDependencies.size()]));
        Thread.currentThread().setContextClassLoader(cl);
        StringCodecs.check();
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationId launchApp(AppFactory appConfig) throws Exception {
        this.loadDependencies();
        Configuration conf = this.propertiesBuilder.conf;
        conf.setEnum("dt.environment", (Enum)StreamingApplication.Environment.CLUSTER);
        LogicalPlan dag = appConfig.createApp(this.propertiesBuilder);
        long hdfsTokenMaxLifeTime = conf.getLong("dt.namenode.delegation.token.max-lifetime", conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L));
        dag.setAttribute(LogicalPlan.HDFS_TOKEN_LIFE_TIME, hdfsTokenMaxLifeTime);
        long rmTokenMaxLifeTime = conf.getLong("dt.resourcemanager.delegation.token.max-lifetime", conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L));
        dag.setAttribute(LogicalPlan.RM_TOKEN_LIFE_TIME, rmTokenMaxLifeTime);
        if (conf.get("dt.authentication.store.keytab") != null) {
            dag.setAttribute(LogicalPlan.KEY_TAB_FILE, conf.get("dt.authentication.store.keytab"));
        } else if (conf.get("dt.authentication.keytab") != null) {
            Path localKeyTabPath = new Path(conf.get("dt.authentication.keytab"));
            try (FileSystem fs = StramClientUtils.newFileSystemInstance(conf);){
                Path destPath = new Path(StramClientUtils.getDTDFSRootDir(fs, conf), localKeyTabPath.getName());
                if (!fs.exists(destPath)) {
                    fs.copyFromLocalFile(false, false, localKeyTabPath, destPath);
                }
                dag.setAttribute(LogicalPlan.KEY_TAB_FILE, destPath.toString());
            }
        }
        String tokenRefreshFactor = conf.get("dt.authentication.token.refresh.factor");
        if (tokenRefreshFactor != null && tokenRefreshFactor.trim().length() > 0) {
            dag.setAttribute(LogicalPlan.TOKEN_REFRESH_ANTICIPATORY_FACTOR, Double.parseDouble(tokenRefreshFactor));
        }
        StramClient client = new StramClient(conf, dag);
        try {
            client.start();
            LinkedHashSet libjars = Sets.newLinkedHashSet();
            String libjarsCsv = conf.get(LIBJARS_CONF_KEY_NAME);
            if (libjarsCsv != null) {
                String[] jars = StringUtils.splitByWholeSeparator((String)libjarsCsv, (String)",");
                libjars.addAll(Arrays.asList(jars));
            }
            if (this.deployJars != null) {
                for (File deployJar : this.deployJars) {
                    libjars.add(deployJar.getAbsolutePath());
                }
            }
            client.setResources(libjars);
            client.setFiles(conf.get(FILES_CONF_KEY_NAME));
            client.setArchives(conf.get(ARCHIVES_CONF_KEY_NAME));
            client.setOriginalAppId(conf.get(ORIGINAL_APP_ID));
            client.setQueueName(conf.get(QUEUE_NAME));
            client.startApplication();
            ApplicationId applicationId = client.getApplicationReport().getApplicationId();
            return applicationId;
        }
        finally {
            client.stop();
        }
    }

    public List<AppFactory> getBundledTopologies() {
        return Collections.unmodifiableList(this.appResourceList);
    }

    public static class JsonFileAppFactory
    implements AppFactory {
        final File jsonFile;
        JSONObject json;

        public JsonFileAppFactory(File file) {
            this.jsonFile = file;
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.jsonFile);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)is, (Writer)writer);
                this.json = new JSONObject(writer.toString());
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException("Failed to load: " + this + "\n" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }

        @Override
        public LogicalPlan createApp(LogicalPlanConfiguration conf) {
            try {
                return conf.createFromJson(this.json, this.getName());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to load: " + this + "\n" + e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            String filename = this.jsonFile.getName();
            if (filename.endsWith(".json")) {
                return filename.substring(0, filename.length() - 5);
            }
            return filename;
        }

        @Override
        public String getDisplayName() {
            String displayName = this.json.optString("displayName", null);
            return displayName == null ? this.getName() : displayName;
        }
    }

    public static class PropertyFileAppFactory
    implements AppFactory {
        final File propertyFile;

        public PropertyFileAppFactory(File file) {
            this.propertyFile = file;
        }

        @Override
        public LogicalPlan createApp(LogicalPlanConfiguration conf) {
            try {
                return conf.createFromProperties(LogicalPlanConfiguration.readProperties(this.propertyFile.getAbsolutePath()), this.getName());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to load: " + this + "\n" + e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            String filename = this.propertyFile.getName();
            if (filename.endsWith(".properties")) {
                return filename.substring(0, filename.length() - 5);
            }
            return filename;
        }

        @Override
        public String getDisplayName() {
            return this.getName();
        }
    }

    public static interface AppFactory {
        public LogicalPlan createApp(LogicalPlanConfiguration var1);

        public String getName();

        public String getDisplayName();
    }
}

