/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.util.ConfigUtils;
import com.datatorrent.stram.util.ConfigValidator;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramClientUtils {
    public static final String DT_VERSION = "dt.version";
    public static final String DT_DFS_ROOT_DIR = "dt.dfsRootDirectory";
    public static final String DT_DFS_USER_NAME = "%USER_NAME%";
    public static final String DT_CONFIG_STATUS = "dt.configStatus";
    public static final String SUBDIR_APPS = "apps";
    public static final String SUBDIR_PROFILES = "profiles";
    public static final String SUBDIR_CONF = "conf";
    public static final int RESOURCEMANAGER_CONNECT_MAX_WAIT_MS_OVERRIDE = 10000;
    public static final String DT_HDFS_TOKEN_MAX_LIFE_TIME = "dt.namenode.delegation.token.max-lifetime";
    public static final String HDFS_TOKEN_MAX_LIFE_TIME = "dfs.namenode.delegation.token.max-lifetime";
    public static final String DT_RM_TOKEN_MAX_LIFE_TIME = "dt.resourcemanager.delegation.token.max-lifetime";
    public static final String KEY_TAB_FILE = "dt.authentication.store.keytab";
    public static final String TOKEN_ANTICIPATORY_REFRESH_FACTOR = "dt.authentication.token.refresh.factor";
    public static final long DELEGATION_TOKEN_MAX_LIFETIME_DEFAULT = 604800000L;
    private static final Logger LOG = LoggerFactory.getLogger(StramClientUtils.class);
    public static final String DT_DEFAULT_XML_FILE = "dt-default.xml";
    public static final String DT_SITE_XML_FILE = "dt-site.xml";
    public static final String DT_SITE_GLOBAL_XML_FILE = "dt-site-global.xml";
    public static final String DT_ENV_SH_FILE = "dt-env.sh";
    public static final String CUSTOM_ENV_SH_FILE = "custom-env.sh";
    public static final String BACKUPS_DIRECTORY = "backups";

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static File getUserDTDirectory() {
        String envHome = System.getenv("HOME");
        if (StringUtils.isEmpty((CharSequence)envHome)) {
            return new File(FileUtils.getUserDirectory(), ".dt");
        }
        return new File(envHome, ".dt");
    }

    public static File getConfigDir() {
        URL resource = StramClientUtils.class.getClassLoader().getResource(DT_ENV_SH_FILE);
        try {
            if (resource == null) {
                return StramClientUtils.getUserDTDirectory();
            }
            return new File(resource.toURI()).getParentFile();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File getInstallationDir() {
        URL resource = StramClientUtils.class.getClassLoader().getResource(DT_ENV_SH_FILE);
        try {
            if (resource == null) {
                return null;
            }
            return new File(resource.toURI()).getParentFile().getParentFile();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isDevelopmentMode() {
        return StramClientUtils.getUserDTDirectory().equals(StramClientUtils.getConfigDir());
    }

    public static File getBackupsDirectory() {
        return new File(StramClientUtils.getConfigDir(), BACKUPS_DIRECTORY);
    }

    public static Configuration addDTDefaultResources(Configuration conf) {
        conf.addResource(DT_DEFAULT_XML_FILE);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration addDTSiteResources(Configuration conf) {
        StramClientUtils.addDTLocalResources(conf);
        FileSystem fs = null;
        try {
            fs = StramClientUtils.newFileSystemInstance(conf);
            File targetGlobalFile = new File(String.format("/tmp/dt-site-global-%s.xml", UserGroupInformation.getLoginUser().getShortUserName()));
            Path hdfsGlobalPath = new Path(StramClientUtils.getDTDFSConfigDir(fs, conf), DT_SITE_GLOBAL_XML_FILE);
            LOG.debug("Copying global dt-site.xml from {} to {}", (Object)hdfsGlobalPath, (Object)targetGlobalFile.getAbsolutePath());
            fs.copyToLocalFile(hdfsGlobalPath, new Path(targetGlobalFile.toURI()));
            StramClientUtils.addDTSiteResources(conf, targetGlobalFile);
            if (!StramClientUtils.isDevelopmentMode()) {
                StramClientUtils.addDTSiteResources(conf, new File(StramClientUtils.getConfigDir(), DT_SITE_XML_FILE));
            }
            StramClientUtils.addDTSiteResources(conf, new File(StramClientUtils.getUserDTDirectory(), DT_SITE_XML_FILE));
        }
        catch (IOException ex) {
            LOG.debug("Caught exception when loading configuration: {}: moving on...", (Object)ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)fs);
        }
        String loggersLevel = conf.get("dt.loggers.level");
        if (loggersLevel != null) {
            String[] targets = loggersLevel.split(",");
            Preconditions.checkArgument((targets.length > 0 ? 1 : 0) != 0, (Object)"zero loggers level");
            for (String target : targets) {
                String[] parts = target.split(":");
                Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)("incorrect " + target));
                Preconditions.checkArgument((boolean)ConfigValidator.validateLoggersLevel(parts[0], parts[1]), (Object)("incorrect " + target));
            }
        }
        StramClientUtils.convertDeprecatedProperties(conf);
        int rmConnectMaxWait = conf.getInt("yarn.resourcemanager.connect.max-wait.ms", 900000);
        if (rmConnectMaxWait > 10000) {
            LOG.info("Overriding {} assigned value of {} to {} because the assigned value is too big.", new Object[]{"yarn.resourcemanager.connect.max-wait.ms", rmConnectMaxWait, 10000});
            conf.setInt("yarn.resourcemanager.connect.max-wait.ms", 10000);
            int rmConnectRetryInterval = conf.getInt("yarn.resourcemanager.connect.retry-interval.ms", 900000);
            int defaultRetryInterval = Math.max(500, 2000);
            if (rmConnectRetryInterval > defaultRetryInterval) {
                LOG.info("Overriding {} assigned value of {} to {} because the assigned value is too big.", new Object[]{"yarn.resourcemanager.connect.retry-interval.ms", rmConnectRetryInterval, defaultRetryInterval});
                conf.setInt("yarn.resourcemanager.connect.retry-interval.ms", defaultRetryInterval);
            }
        }
        LOG.info(" conf object in stramclient {}", (Object)conf);
        return conf;
    }

    public static void addDTLocalResources(Configuration conf) {
        conf.addResource(DT_DEFAULT_XML_FILE);
        if (!StramClientUtils.isDevelopmentMode()) {
            StramClientUtils.addDTSiteResources(conf, new File(StramClientUtils.getConfigDir(), DT_SITE_XML_FILE));
        }
        StramClientUtils.addDTSiteResources(conf, new File(StramClientUtils.getUserDTDirectory(), DT_SITE_XML_FILE));
    }

    private static Configuration addDTSiteResources(Configuration conf, File confFile) {
        if (confFile.exists()) {
            LOG.info("Loading settings: " + confFile.toURI());
            conf.addResource(new Path(confFile.toURI()));
        } else {
            LOG.info("Configuration file {} is not found. Skipping...", (Object)confFile.toURI());
        }
        return conf;
    }

    private static void convertDeprecatedProperties(Configuration conf) {
        Iterator iterator = conf.iterator();
        HashMap newEntries = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((String)entry.getKey()).startsWith("stram.")) continue;
            String newKey = "dt." + ((String)entry.getKey()).substring(6);
            LOG.warn("Configuration property {} is deprecated. Please use {} instead.", entry.getKey(), (Object)newKey);
            newEntries.put(newKey, entry.getValue());
            iterator.remove();
        }
        for (Map.Entry entry : newEntries.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static URL getDTSiteXmlFile() {
        File cfgResource = new File(StramClientUtils.getConfigDir(), DT_SITE_XML_FILE);
        try {
            return cfgResource.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FileSystem newFileSystemInstance(Configuration conf) throws IOException {
        String dfsRootDir = conf.get(DT_DFS_ROOT_DIR);
        if (StringUtils.isBlank((CharSequence)dfsRootDir)) {
            return FileSystem.newInstance((Configuration)conf);
        }
        if (dfsRootDir.contains(DT_DFS_USER_NAME)) {
            dfsRootDir = dfsRootDir.replace(DT_DFS_USER_NAME, UserGroupInformation.getLoginUser().getShortUserName());
            conf.set(DT_DFS_ROOT_DIR, dfsRootDir);
        }
        try {
            return FileSystem.newInstance((URI)new URI(dfsRootDir), (Configuration)conf);
        }
        catch (URISyntaxException ex) {
            LOG.warn("{} is not a valid URI. Returning the default filesystem", (Object)dfsRootDir, (Object)ex);
            return FileSystem.newInstance((Configuration)conf);
        }
    }

    public static Path getDTDFSRootDir(FileSystem fs, Configuration conf) {
        String dfsRootDir = conf.get(DT_DFS_ROOT_DIR);
        if (StringUtils.isBlank((CharSequence)dfsRootDir)) {
            return new Path(fs.getHomeDirectory(), "datatorrent");
        }
        try {
            URI uri;
            if (dfsRootDir.contains(DT_DFS_USER_NAME)) {
                dfsRootDir = dfsRootDir.replace(DT_DFS_USER_NAME, UserGroupInformation.getLoginUser().getShortUserName());
                conf.set(DT_DFS_ROOT_DIR, dfsRootDir);
            }
            if ((uri = new URI(dfsRootDir)).isAbsolute()) {
                return new Path(uri);
            }
        }
        catch (IOException ex) {
            LOG.warn("Error getting user login name {}", (Object)dfsRootDir, (Object)ex);
        }
        catch (URISyntaxException ex) {
            LOG.warn("{} is not a valid URI. Using the default filesystem to construct the path", (Object)dfsRootDir, (Object)ex);
        }
        return new Path(fs.getUri().getScheme(), fs.getUri().getAuthority(), dfsRootDir);
    }

    public static Path getDTDFSConfigDir(FileSystem fs, Configuration conf) {
        return new Path(StramClientUtils.getDTDFSRootDir(fs, conf), SUBDIR_CONF);
    }

    public static Path getDTDFSProfilesDir(FileSystem fs, Configuration conf) {
        return new Path(StramClientUtils.getDTDFSRootDir(fs, conf), SUBDIR_PROFILES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeDTEnvironment(String key, String value) throws IOException {
        if (StramClientUtils.isDevelopmentMode()) {
            throw new IllegalStateException("Cannot change DT environment in development mode.");
        }
        URL resource = StramClientUtils.class.getClassLoader().getResource(CUSTOM_ENV_SH_FILE);
        if (resource == null) {
            File envFile = new File(StramClientUtils.getUserDTDirectory(), CUSTOM_ENV_SH_FILE);
            try (FileOutputStream out = new FileOutputStream(envFile);){
                out.write(("export " + key + "=\"" + value + "\"\n").getBytes());
            }
        }
        try {
            File cfgResource = new File(resource.toURI());
            Class<StramClientUtils> clazz = StramClientUtils.class;
            synchronized (StramClientUtils.class) {
                StringBuilder sb = new StringBuilder(1024);
                try (BufferedReader br = new BufferedReader(new FileReader(cfgResource));){
                    String line;
                    boolean changed = false;
                    while ((line = br.readLine()) != null) {
                        try {
                            if ((line = line.trim()).startsWith("#") || !line.matches("export\\s+" + key + "=.*")) continue;
                            line = "export " + key + "=\"" + value + "\"";
                            changed = true;
                        }
                        finally {
                            sb.append(line).append("\n");
                        }
                    }
                    if (!changed) {
                        sb.append("export ").append(key).append("=\"").append(value).append("\"\n");
                    }
                }
                if (sb.length() > 0) {
                    try (FileOutputStream out = new FileOutputStream(cfgResource);){
                        out.write(sb.toString().getBytes());
                    }
                }
                // ** MonitorExit[var4_7] (shouldn't be in output)
            }
        }
        catch (URISyntaxException ex) {
            LOG.error("Caught exception when getting env resource:", (Throwable)ex);
        }
        {
            return;
        }
    }

    public static void copyFromLocalFileNoChecksum(FileSystem fs, File fromLocal, Path toDFS) throws IOException {
        try {
            new File(fromLocal.getParentFile(), "." + fromLocal.getName() + ".crc").delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        fs.copyFromLocalFile(new Path(fromLocal.toURI()), toDFS);
    }

    public static boolean configComplete(Configuration conf) {
        String configStatus = conf.get(DT_CONFIG_STATUS);
        return "complete".equals(configStatus);
    }

    public static void evalProperties(Properties target, Configuration vars) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        Pattern substitutionPattern = Pattern.compile("\\$\\{(.+?)\\}");
        Pattern evalPattern = Pattern.compile("\\{% (.+?) %\\}");
        try {
            engine.eval("var _prop = {}");
            for (Map.Entry<Object, Object> entry : vars) {
                String evalString = String.format("_prop[\"%s\"] = \"%s\"", StringEscapeUtils.escapeJava((String)((String)entry.getKey())), StringEscapeUtils.escapeJava((String)((String)entry.getValue())));
                engine.eval(evalString);
            }
        }
        catch (ScriptException ex) {
            LOG.warn("Javascript error: {}", (Object)ex.getMessage());
        }
        for (Map.Entry<Object, Object> entry : target.entrySet()) {
            int cursor;
            StringBuilder newValue;
            String value = entry.getValue().toString();
            Matcher matcher = substitutionPattern.matcher(value);
            if (matcher.find()) {
                newValue = new StringBuilder();
                cursor = 0;
                do {
                    newValue.append(value.substring(cursor, matcher.start()));
                    String subst = vars.get(matcher.group(1));
                    if (subst != null) {
                        newValue.append(subst);
                    }
                    cursor = matcher.end();
                } while (matcher.find());
                newValue.append(value.substring(cursor));
                target.put(entry.getKey(), newValue.toString());
            }
            if (!(matcher = evalPattern.matcher(value)).find()) continue;
            newValue = new StringBuilder();
            cursor = 0;
            do {
                newValue.append(value.substring(cursor, matcher.start()));
                try {
                    Object result = engine.eval(matcher.group(1));
                    String eval = result.toString();
                    if (eval != null) {
                        newValue.append(eval);
                    }
                }
                catch (ScriptException ex) {
                    LOG.warn("JavaScript exception {}", (Object)ex.getMessage());
                }
                cursor = matcher.end();
            } while (matcher.find());
            newValue.append(value.substring(cursor));
            target.put(entry.getKey(), newValue.toString());
        }
    }

    public static void evalConfiguration(Configuration conf) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : conf) {
            props.put(entry.getKey(), entry.getValue());
        }
        StramClientUtils.evalProperties(props, conf);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static <T> T doAs(String userName, PrivilegedExceptionAction<T> action) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)userName) && !userName.equals(UserGroupInformation.getLoginUser().getShortUserName())) {
            LOG.info("Executing command as {}", (Object)userName);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getLoginUser());
            return (T)ugi.doAs(action);
        }
        LOG.info("Executing command as if there is no login info: {}", (Object)userName);
        return action.run();
    }

    public static ApplicationReport getStartedAppInstanceByName(YarnClient clientRMService, String appName, String user, String excludeAppId) throws YarnException, IOException {
        List applications = clientRMService.getApplications((Set)Sets.newHashSet((Object[])new String[]{"DataTorrent"}), EnumSet.of(YarnApplicationState.RUNNING, YarnApplicationState.ACCEPTED, YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED));
        for (ApplicationReport app : applications) {
            if (app.getApplicationId().toString().equals(excludeAppId) || !app.getName().equals(appName) || !app.getUser().equals(user)) continue;
            return app;
        }
        return null;
    }

    public static InetSocketAddress getRMWebAddress(Configuration conf, String rmId) {
        boolean sslEnabled = conf.getBoolean("hadoop.ssl.enabled", false);
        return StramClientUtils.getRMWebAddress(conf, sslEnabled, rmId);
    }

    public static InetSocketAddress getRMWebAddress(Configuration conf, boolean sslEnabled, String rmId) {
        rmId = rmId == null ? "" : "." + rmId;
        InetSocketAddress address = sslEnabled ? conf.getSocketAddr("yarn.resourcemanager.webapp.https.address" + rmId, "0.0.0.0:8090", 8090) : conf.getSocketAddr("yarn.resourcemanager.webapp.address" + rmId, "0.0.0.0:8088", 8088);
        LOG.info("rm webapp address setting {}", (Object)address);
        LOG.debug("rm setting sources {}", (Object[])conf.getPropertySources("yarn.resourcemanager.webapp.address"));
        InetSocketAddress resolvedSocketAddress = NetUtils.getConnectAddress((InetSocketAddress)address);
        InetAddress resolved = resolvedSocketAddress.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            try {
                resolvedSocketAddress = InetSocketAddress.createUnresolved(InetAddress.getLocalHost().getCanonicalHostName(), address.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return resolvedSocketAddress;
    }

    public static String getSocketConnectString(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        String host = address == null ? socketAddress.getHostString() : (address.isAnyLocalAddress() || address.isLoopbackAddress() ? address.getCanonicalHostName() : address.getHostName());
        return host + ":" + socketAddress.getPort();
    }

    public static List<InetSocketAddress> getRMAddresses(Configuration conf) {
        ArrayList<InetSocketAddress> rmAddresses = new ArrayList<InetSocketAddress>();
        if (ConfigUtils.isRMHAEnabled(conf)) {
            for (String rmId : ConfigUtils.getRMHAIds(conf)) {
                InetSocketAddress socketAddress = StramClientUtils.getRMWebAddress(conf, rmId);
                rmAddresses.add(socketAddress);
            }
        } else {
            InetSocketAddress socketAddress = StramClientUtils.getRMWebAddress(conf, null);
            rmAddresses.add(socketAddress);
        }
        return rmAddresses;
    }

    public static class ClientRMHelper {
        private static final Logger LOG = LoggerFactory.getLogger(ClientRMHelper.class);
        private static final String RM_HOSTNAME_PREFIX = "yarn.resourcemanager.hostname.";
        private final YarnClient clientRM;
        private final Configuration conf;

        public ClientRMHelper(YarnClient yarnClient, Configuration conf) throws IOException {
            this.clientRM = yarnClient;
            this.conf = conf;
        }

        public boolean waitForCompletion(ApplicationId appId, AppStatusCallback callback, long timeoutMillis) throws YarnException, IOException {
            long startMillis = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.debug("Thread sleep in monitoring loop interrupted");
                }
                ApplicationReport report = this.clientRM.getApplicationReport(appId);
                if (callback.exitLoop(report)) {
                    return true;
                }
                YarnApplicationState state = report.getYarnApplicationState();
                FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
                if (YarnApplicationState.FINISHED == state) {
                    if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                        LOG.info("Application has completed successfully. Breaking monitoring loop");
                        return true;
                    }
                    LOG.info("Application finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop");
                    return false;
                }
                if (YarnApplicationState.KILLED != state && YarnApplicationState.FAILED != state) continue;
                LOG.info("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop");
                return false;
            } while (System.currentTimeMillis() - startMillis <= timeoutMillis);
            LOG.info("Reached specified timeout. Killing application");
            this.clientRM.killApplication(appId);
            return false;
        }

        private Token<RMDelegationTokenIdentifier> getRMHAToken(org.apache.hadoop.yarn.api.records.Token rmDelegationToken) {
            ArrayList<String> services = new ArrayList<String>();
            for (String rmId : ConfigUtils.getRMHAIds(this.conf)) {
                LOG.info("Yarn Resource Manager id: {}", (Object)rmId);
                services.add(SecurityUtil.buildTokenService((InetSocketAddress)this.getRMHAAddress(rmId)).toString());
            }
            Text rmTokenService = new Text(Joiner.on((char)',').join(services));
            return new Token(rmDelegationToken.getIdentifier().array(), rmDelegationToken.getPassword().array(), new Text(rmDelegationToken.getKind()), rmTokenService);
        }

        public void addRMDelegationToken(String renewer, Credentials credentials) throws IOException, YarnException {
            Token token;
            org.apache.hadoop.yarn.api.records.Token rmDelegationToken = this.clientRM.getRMDelegationToken(new Text(renewer));
            if (ConfigUtils.isRMHAEnabled(this.conf)) {
                LOG.info("Yarn Resource Manager HA is enabled");
                token = this.getRMHAToken(rmDelegationToken);
            } else {
                LOG.info("Yarn Resource Manager HA is not enabled");
                InetSocketAddress rmAddress = this.conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
                token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)rmDelegationToken, (InetSocketAddress)rmAddress);
            }
            LOG.info("RM dt {}", token);
            credentials.addToken(token.getService(), token);
        }

        public InetSocketAddress getRMHAAddress(String rmId) {
            YarnConfiguration yarnConf = this.conf instanceof YarnConfiguration ? (YarnConfiguration)this.conf : new YarnConfiguration(this.conf);
            yarnConf.set("yarn.resourcemanager.ha.id", rmId);
            InetSocketAddress socketAddr = yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
            yarnConf.unset("yarn.resourcemanager.ha.id");
            return socketAddr;
        }

        public static interface AppStatusCallback {
            public boolean exitLoop(ApplicationReport var1);
        }
    }

    public static class YarnClientHelper {
        private static final Logger LOG = LoggerFactory.getLogger(YarnClientHelper.class);
        private final Configuration conf;
        private final YarnRPC rpc;

        public YarnClientHelper(Configuration conf) {
            this.conf = conf;
            this.rpc = YarnRPC.create((Configuration)conf);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public YarnRPC getYarnRPC() {
            return this.rpc;
        }

        public ApplicationClientProtocol connectToASM() throws IOException {
            YarnConfiguration yarnConf = new YarnConfiguration(this.conf);
            InetSocketAddress rmAddress = yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
            LOG.debug("Connecting to ResourceManager at " + rmAddress);
            return (ApplicationClientProtocol)this.rpc.getProxy(ApplicationClientProtocol.class, rmAddress, this.conf);
        }

        public ApplicationMasterProtocol connectToRM() {
            InetSocketAddress rmAddress = this.conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
            LOG.debug("Connecting to ResourceManager at " + rmAddress);
            return (ApplicationMasterProtocol)this.rpc.getProxy(ApplicationMasterProtocol.class, rmAddress, this.conf);
        }
    }
}

