/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.codec;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.common.util.ObjectMapperString;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import com.datatorrent.stram.plan.logical.Operators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
public class LogicalPlanSerializer
extends JsonSerializer<LogicalPlan> {
    private static final Logger LOG = LoggerFactory.getLogger(LogicalPlanSerializer.class);

    public static Map<String, Object> convertToMap(LogicalPlan dag, boolean includeModules) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList operatorArray = new ArrayList();
        ArrayList streamMap = new ArrayList();
        result.put("operators", operatorArray);
        result.put("streams", streamMap);
        HashMap dagAttrs = new HashMap();
        for (Map.Entry e : Attribute.AttributeMap.AttributeInitializer.getAllAttributes((Context)dag, Context.DAGContext.class).entrySet()) {
            dagAttrs.put(((Attribute)e.getKey()).getSimpleName(), e.getValue());
        }
        result.put("attributes", dagAttrs);
        Collection<LogicalPlan.OperatorMeta> allOperators = dag.getAllOperators();
        ObjectMapper propertyObjectMapper = new ObjectMapper();
        propertyObjectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        propertyObjectMapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        PropertyTypeResolverBuilder typer = new PropertyTypeResolverBuilder();
        typer.init(JsonTypeInfo.Id.CLASS, null);
        typer = typer.inclusion(JsonTypeInfo.As.PROPERTY);
        propertyObjectMapper.setDefaultTyping((TypeResolverBuilder)typer);
        for (LogicalPlan.OperatorMeta operatorMeta : allOperators) {
            String portName;
            DAG.InputPortMeta portMeta;
            HashMap portAttributeMap;
            HashMap<String, Object> portDetailMap;
            ObjectMapperString str;
            HashMap<String, Object> operatorDetailMap = new HashMap<String, Object>();
            ArrayList portList = new ArrayList();
            HashMap attributeMap = new HashMap();
            String operatorName = operatorMeta.getName();
            operatorArray.add(operatorDetailMap);
            operatorDetailMap.put("name", operatorName);
            operatorDetailMap.put("ports", portList);
            operatorDetailMap.put("class", operatorMeta.getOperator().getClass().getName());
            operatorDetailMap.put("attributes", attributeMap);
            Map rawAttributes = Attribute.AttributeMap.AttributeInitializer.getAllAttributes((Context)operatorMeta, Context.OperatorContext.class);
            for (Map.Entry entry : rawAttributes.entrySet()) {
                attributeMap.put(((Attribute)entry.getKey()).getSimpleName(), entry.getValue());
            }
            try {
                str = new ObjectMapperString(propertyObjectMapper.writeValueAsString((Object)operatorMeta.getOperator()));
            }
            catch (Throwable ex) {
                LOG.error("Got exception when trying to get properties for operator {}", (Object)operatorMeta.getName(), (Object)ex);
                str = null;
            }
            operatorDetailMap.put("properties", str);
            Operators.PortMappingDescriptor pmd = new Operators.PortMappingDescriptor();
            Operators.describe(operatorMeta.getOperator(), pmd);
            for (Map.Entry<String, Operators.PortContextPair<Operator.InputPort<?>>> entry : pmd.inputPorts.entrySet()) {
                portDetailMap = new HashMap<String, Object>();
                portAttributeMap = new HashMap();
                portMeta = operatorMeta.getMeta((Operator.InputPort)entry.getValue().component);
                portName = portMeta.getPortName();
                portDetailMap.put("name", portName);
                portDetailMap.put("type", "input");
                portDetailMap.put("attributes", portAttributeMap);
                rawAttributes = Attribute.AttributeMap.AttributeInitializer.getAllAttributes((Context)portMeta, Context.PortContext.class);
                for (Map.Entry attEntry : rawAttributes.entrySet()) {
                    portAttributeMap.put(((Attribute)attEntry.getKey()).getSimpleName(), attEntry.getValue());
                }
                portList.add(portDetailMap);
            }
            for (Map.Entry<String, Operators.PortContextPair<Operator.InputPort<?>>> entry : pmd.outputPorts.entrySet()) {
                portDetailMap = new HashMap();
                portAttributeMap = new HashMap();
                portMeta = operatorMeta.getMeta((Operator.OutputPort)entry.getValue().component);
                portName = portMeta.getPortName();
                portDetailMap.put("name", portName);
                portDetailMap.put("type", "output");
                portDetailMap.put("attributes", portAttributeMap);
                rawAttributes = Attribute.AttributeMap.AttributeInitializer.getAllAttributes((Context)portMeta, Context.PortContext.class);
                for (Map.Entry attEntry : rawAttributes.entrySet()) {
                    portAttributeMap.put(((Attribute)attEntry.getKey()).getSimpleName(), attEntry.getValue());
                }
                portList.add(portDetailMap);
            }
        }
        Collection<LogicalPlan.StreamMeta> allStreams = dag.getAllStreams();
        for (LogicalPlan.StreamMeta streamMeta : allStreams) {
            HashMap<String, Object> streamDetailMap = new HashMap<String, Object>();
            String streamName = streamMeta.getName();
            streamMap.add(streamDetailMap);
            String sourcePortName = streamMeta.getSource().getPortName();
            LogicalPlan.OperatorMeta operatorMeta = streamMeta.getSource().getOperatorMeta();
            HashMap<String, String> sourcePortDetailMap = new HashMap<String, String>();
            sourcePortDetailMap.put("operatorName", operatorMeta.getName());
            sourcePortDetailMap.put("portName", sourcePortName);
            streamDetailMap.put("name", streamName);
            streamDetailMap.put("source", sourcePortDetailMap);
            List<LogicalPlan.InputPortMeta> sinks = streamMeta.getSinks();
            ArrayList sinkPortList = new ArrayList();
            for (LogicalPlan.InputPortMeta sinkPort : sinks) {
                HashMap<String, String> sinkPortDetailMap = new HashMap<String, String>();
                sinkPortDetailMap.put("operatorName", sinkPort.getOperatorWrapper().getName());
                sinkPortDetailMap.put("portName", sinkPort.getPortName());
                sinkPortList.add(sinkPortDetailMap);
            }
            streamDetailMap.put("sinks", sinkPortList);
            if (streamMeta.getLocality() == null) continue;
            streamDetailMap.put("locality", streamMeta.getLocality().name());
        }
        if (includeModules) {
            ArrayList<Map<String, Object>> modulesArray = new ArrayList<Map<String, Object>>();
            result.put("modules", modulesArray);
            for (LogicalPlan.ModuleMeta meta : dag.getAllModules()) {
                modulesArray.add(LogicalPlanSerializer.getLogicalModuleDetails(dag, meta));
            }
        }
        return result;
    }

    public static PropertiesConfiguration convertToProperties(LogicalPlan dag) {
        PropertiesConfiguration props = new PropertiesConfiguration();
        Collection<LogicalPlan.OperatorMeta> allOperators = dag.getAllOperators();
        for (LogicalPlan.OperatorMeta operatorMeta : allOperators) {
            String operatorKey = "dt.operator." + operatorMeta.getName();
            Operator operator = operatorMeta.getOperator();
            props.setProperty(operatorKey + "." + "classname", (Object)operator.getClass().getName());
            BeanMap operatorProperties = LogicalPlanConfiguration.getObjectProperties(operator);
            Iterator entryIterator = operatorProperties.entryIterator();
            while (entryIterator.hasNext()) {
                try {
                    Map.Entry entry = (Map.Entry)entryIterator.next();
                    if (((String)entry.getKey()).equals("class") || ((String)entry.getKey()).equals("name") || entry.getValue() == null) continue;
                    props.setProperty(operatorKey + "." + (String)entry.getKey(), entry.getValue());
                }
                catch (Exception ex) {
                    LOG.warn("Error trying to get a property of operator {}", (Object)operatorMeta.getName(), (Object)ex);
                }
            }
        }
        Collection<LogicalPlan.StreamMeta> allStreams = dag.getAllStreams();
        for (LogicalPlan.StreamMeta streamMeta : allStreams) {
            String streamKey = "dt.stream." + streamMeta.getName();
            LogicalPlan.OutputPortMeta source = streamMeta.getSource();
            List<LogicalPlan.InputPortMeta> sinks = streamMeta.getSinks();
            props.setProperty(streamKey + "." + "source", (Object)(source.getOperatorMeta().getName() + "." + source.getPortName()));
            String sinksValue = "";
            for (LogicalPlan.InputPortMeta sink : sinks) {
                if (!sinksValue.isEmpty()) {
                    sinksValue = sinksValue + ",";
                }
                sinksValue = sinksValue + sink.getOperatorWrapper().getName() + "." + sink.getPortName();
            }
            props.setProperty(streamKey + "." + "sinks", (Object)sinksValue);
            if (streamMeta.getLocality() == null) continue;
            props.setProperty(streamKey + "." + "locality", (Object)streamMeta.getLocality().name());
        }
        return props;
    }

    public static PropertiesConfiguration convertToProperties(JSONObject json) throws JSONException {
        PropertiesConfiguration props = new PropertiesConfiguration();
        JSONObject allOperators = json.getJSONObject("operators");
        JSONObject allStreams = json.getJSONObject("streams");
        Iterator operatorIter = allOperators.keys();
        while (operatorIter.hasNext()) {
            String operatorName = (String)operatorIter.next();
            JSONObject operatorDetail = allOperators.getJSONObject(operatorName);
            String operatorKey = "dt.operator." + operatorName;
            props.setProperty(operatorKey + ".classname", (Object)operatorDetail.getString("class"));
            JSONObject properties = operatorDetail.optJSONObject("properties");
            if (properties == null) continue;
            Iterator iter2 = properties.keys();
            while (iter2.hasNext()) {
                String propertyName = (String)iter2.next();
                if (propertyName.equals("name") || propertyName.equals("class") || properties.opt(propertyName) == null) continue;
                JSONArray list = properties.optJSONArray(propertyName);
                String value = "";
                if (list != null) {
                    for (int i = 0; i < list.length(); ++i) {
                        if (i != 0) {
                            value = value + ",";
                        }
                        value = value + list.get(i).toString();
                    }
                    props.setProperty(operatorKey + "." + propertyName, (Object)value);
                    continue;
                }
                props.setProperty(operatorKey + "." + propertyName, properties.get(propertyName));
            }
        }
        Iterator streamIter = allStreams.keys();
        while (streamIter.hasNext()) {
            String streamName = (String)streamIter.next();
            JSONObject streamDetail = allStreams.getJSONObject(streamName);
            String streamKey = "dt.stream." + streamName;
            JSONObject sourceDetail = streamDetail.getJSONObject("source");
            JSONArray sinksList = streamDetail.getJSONArray("sinks");
            props.setProperty(streamKey + "." + "source", (Object)(sourceDetail.getString("operatorName") + "." + sourceDetail.getString("portName")));
            String sinksValue = "";
            for (int i = 0; i < sinksList.length(); ++i) {
                if (!sinksValue.isEmpty()) {
                    sinksValue = sinksValue + ",";
                }
                sinksValue = sinksValue + sinksList.getJSONObject(i).getString("operatorName") + "." + sinksList.getJSONObject(i).getString("portName");
            }
            props.setProperty(streamKey + "." + "sinks", (Object)sinksValue);
            String locality = streamDetail.optString("locality");
            if (locality == null) continue;
            props.setProperty(streamKey + "." + "locality", (Object)DAG.Locality.valueOf((String)locality));
        }
        return props;
    }

    public static JSONObject convertToJsonObject(LogicalPlan dag) {
        return new JSONObject(LogicalPlanSerializer.convertToMap(dag, false));
    }

    public void serialize(LogicalPlan dag, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
        jg.writeObject(LogicalPlanSerializer.convertToMap(dag, false));
    }

    private static Map<String, Object> getLogicalModuleDetails(LogicalPlan dag, LogicalPlan.ModuleMeta moduleMeta) {
        HashMap<String, Object> moduleDetailMap = new HashMap<String, Object>();
        ArrayList<String> operatorArray = new ArrayList<String>();
        moduleDetailMap.put("name", moduleMeta.getName());
        moduleDetailMap.put("className", moduleMeta.getModule().getClass().getName());
        moduleDetailMap.put("operators", operatorArray);
        for (LogicalPlan.OperatorMeta operatorMeta : moduleMeta.getDag().getAllOperators()) {
            if (operatorMeta.getModuleName() != null) continue;
            String fullName = moduleMeta.getFullName() + "$" + operatorMeta.getName();
            operatorArray.add(fullName);
        }
        ArrayList<Map<String, Object>> modulesArray = new ArrayList<Map<String, Object>>();
        moduleDetailMap.put("modules", modulesArray);
        for (LogicalPlan.ModuleMeta meta : moduleMeta.getDag().getAllModules()) {
            modulesArray.add(LogicalPlanSerializer.getLogicalModuleDetails(dag, meta));
        }
        return moduleDetailMap;
    }

    private static class PropertyTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        PropertyTypeResolverBuilder() {
            super(ObjectMapper.DefaultTyping.NON_FINAL);
        }

        public boolean useForType(JavaType t) {
            if (t.getRawClass() == Object.class) {
                return true;
            }
            if (t.getRawClass().getName().startsWith("java.")) {
                return false;
            }
            if (t.isArrayType()) {
                return false;
            }
            return super.useForType(t);
        }
    }
}

