/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.debug;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Appender;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdOutErrLog {
    public static final String DT_LOG_APPENDER = "DT";
    public static final String DT_LOGDIR = "dt.logdir";
    private static final Logger logger = LoggerFactory.getLogger(StdOutErrLog.class);

    public static void tieSystemOutAndErrToLog() {
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        Appender appender = rootLogger.getAppender(DT_LOG_APPENDER);
        if (appender instanceof RollingFileAppender) {
            RollingFileAppender rfa = (RollingFileAppender)appender;
            if (rfa.getFile() == null || rfa.getFile().isEmpty()) {
                rfa.setFile(System.getProperty(DT_LOGDIR));
                rfa.activateOptions();
            }
        } else if (appender != null) {
            logger.warn("found appender {} instead of RollingFileAppender", (Object)appender);
        }
        System.setOut(StdOutErrLog.createLoggingProxy(System.out));
        System.setErr(StdOutErrLog.createLoggingProxy(System.err));
    }

    public static PrintStream createLoggingProxy(final PrintStream realPrintStream) {
        return new PrintStream((OutputStream)realPrintStream){

            @Override
            public void print(String string) {
                realPrintStream.print(string);
            }
        };
    }
}

