/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.engine;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Sink;
import com.datatorrent.api.StatsListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class Slider
implements Operator.Unifier<Object>,
Operator.IdleTimeHandler,
Operator.ActivationListener<Context.OperatorContext>,
StatsListener,
Serializable,
Operator.CheckpointListener {
    private List<List<Object>> cache;
    private transient List<Object> currentList;
    private final Operator.Unifier<Object> unifier;
    private final int numberOfBuckets;
    private final int numberOfSlideBuckets;
    private transient int spinMillis;
    public final transient DefaultOutputPort<Object> outputPort = new DefaultOutputPort();
    private transient int cacheSize;
    private static final long serialVersionUID = 201505251917L;

    public Operator.Unifier<Object> getUnifier() {
        return this.unifier;
    }

    private Slider() {
        this.unifier = null;
        this.numberOfBuckets = -1;
        this.numberOfSlideBuckets = -1;
    }

    public Slider(Operator.Unifier<Object> uniOperator, int buckets, int numberOfSlideBuckets) {
        this.unifier = uniOperator;
        this.cache = new LinkedList<List<Object>>();
        this.numberOfBuckets = buckets;
        this.numberOfSlideBuckets = numberOfSlideBuckets;
    }

    private Operator.OutputPort<?> getOutputPort() {
        for (Class<?> c = this.unifier.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object portObject = field.get(this.unifier);
                    if (!(portObject instanceof Operator.OutputPort)) continue;
                    return (Operator.OutputPort)portObject;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new RuntimeException("Unifier should have exactly one output port");
    }

    public void process(Object tuple) {
        if (this.cacheSize == this.numberOfBuckets - 1) {
            this.unifier.process(tuple);
        }
        this.currentList.add(tuple);
    }

    public void beginWindow(long windowId) {
        this.cacheSize = this.cache.size();
        this.unifier.beginWindow(windowId);
        if (this.cacheSize == this.numberOfBuckets - 1) {
            for (List<Object> windowCache : this.cache) {
                for (Object obj : windowCache) {
                    this.unifier.process(obj);
                }
            }
        }
        this.currentList = new LinkedList<Object>();
    }

    public void endWindow() {
        this.cache.add(this.currentList);
        if (this.cacheSize == this.numberOfBuckets - 1) {
            for (int i = 0; i < this.numberOfSlideBuckets; ++i) {
                this.cache.remove(0);
            }
        }
        this.unifier.endWindow();
    }

    public void setup(Context.OperatorContext context) {
        Operator.OutputPort<?> unifierOutputPort = this.getOutputPort();
        unifierOutputPort.setSink((Sink)new Sink<Object>(){

            public void put(Object tuple) {
                Slider.this.outputPort.emit(tuple);
            }

            public int getCount(boolean reset) {
                return 0;
            }
        });
        this.unifier.setup((Context)context);
        this.spinMillis = (Integer)context.getValue(Context.OperatorContext.SPIN_MILLIS);
    }

    public void teardown() {
        this.unifier.teardown();
    }

    public void activate(Context.OperatorContext context) {
        if (this.unifier instanceof Operator.ActivationListener) {
            ((Operator.ActivationListener)this.unifier).activate((Context)context);
        }
    }

    public void deactivate() {
        if (this.unifier instanceof Operator.ActivationListener) {
            ((Operator.ActivationListener)this.unifier).deactivate();
        }
    }

    public void handleIdleTime() {
        if (this.unifier instanceof Operator.IdleTimeHandler) {
            ((Operator.IdleTimeHandler)this.unifier).handleIdleTime();
        } else {
            try {
                Thread.sleep(this.spinMillis);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public StatsListener.Response processStats(StatsListener.BatchedOperatorStats stats) {
        if (this.unifier instanceof StatsListener) {
            return ((StatsListener)this.unifier).processStats(stats);
        }
        return null;
    }

    public void checkpointed(long windowId) {
        if (this.unifier instanceof Operator.CheckpointListener) {
            ((Operator.CheckpointListener)this.unifier).checkpointed(windowId);
        }
    }

    public void committed(long windowId) {
        if (this.unifier instanceof Operator.CheckpointListener) {
            ((Operator.CheckpointListener)this.unifier).committed(windowId);
        }
    }
}

