/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.logical;

import com.datatorrent.api.StreamCodec;
import com.datatorrent.common.util.SerializableObject;
import com.datatorrent.netlet.util.DTThrowable;
import com.datatorrent.netlet.util.Slice;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKryoStreamCodec<T>
extends SerializableObject
implements StreamCodec<T> {
    static final Logger logger = LoggerFactory.getLogger(DefaultKryoStreamCodec.class);
    private static final long serialVersionUID = 1L;
    protected final transient Kryo kryo = new Kryo();

    public DefaultKryoStreamCodec() {
        this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public Object fromByteArray(Slice fragment) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(fragment.buffer, fragment.offset, fragment.length);
            Input input = new Input((InputStream)is);
            Object returnObject = this.kryo.readClassAndObject(input);
            is.close();
            return returnObject;
        }
        catch (IOException e) {
            DTThrowable.wrapIfChecked((Exception)e);
            return null;
        }
    }

    public Slice toByteArray(T info) {
        Slice slice = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)os);
            this.kryo.writeClassAndObject(output, info);
            output.flush();
            slice = new Slice(os.toByteArray(), 0, os.toByteArray().length);
            os.close();
        }
        catch (IOException e) {
            DTThrowable.wrapIfChecked((Exception)e);
        }
        return slice;
    }

    public int getPartition(T t) {
        return t.hashCode();
    }
}

