/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.logical;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.api.StreamingApplication;
import com.datatorrent.api.StringCodec;
import com.datatorrent.api.annotation.ApplicationAnnotation;
import com.datatorrent.stram.StramUtils;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.Operators;
import com.datatorrent.stram.util.ObjectMapperFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.ValidationException;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalPlanConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(LogicalPlanConfiguration.class);
    public static final String GATEWAY_PREFIX = "dt.gateway.";
    public static final String GATEWAY_LISTEN_ADDRESS = "dt.gateway.listenAddress";
    public static final String STREAM_PREFIX = "dt.stream.";
    public static final String STREAM_SOURCE = "source";
    public static final String STREAM_SINKS = "sinks";
    public static final String STREAM_TEMPLATE = "template";
    public static final String STREAM_LOCALITY = "locality";
    public static final String STREAM_SCHEMA = "schema";
    public static final String OPERATOR_PREFIX = "dt.operator.";
    public static final String OPERATOR_CLASSNAME = "classname";
    public static final String OPERATOR_TEMPLATE = "template";
    public static final String TEMPLATE_idRegExp = "matchIdRegExp";
    public static final String TEMPLATE_appNameRegExp = "matchAppNameRegExp";
    public static final String TEMPLATE_classNameRegExp = "matchClassNameRegExp";
    public static final String CLASS = "class";
    public static final String KEY_SEPARATOR = ".";
    public static final String KEY_SEPARATOR_SPLIT_REGEX = "\\.";
    private static final String CLASS_SUFFIX = ".class";
    private static final String WILDCARD = "*";
    private static final String WILDCARD_PATTERN = ".*";
    private static final Map<StramElement, Class<? extends Conf>> elementMaps;
    private final Properties properties = new Properties();
    public final Configuration conf;
    private final StramConf stramConf = new StramConf();

    private static Conf getConf(StramElement element, Conf ancestorConf) {
        if (element == ancestorConf.getConfElement().getStramElement()) {
            return ancestorConf;
        }
        if (element == null) {
            return null;
        }
        StramElement parentElement = ConfElement.getAllowedParentConf(element);
        Conf parentConf = LogicalPlanConfiguration.getConf(parentElement, ancestorConf);
        if (parentConf == null) {
            throw new IllegalArgumentException("The given StramElement is not the same type as the given ancestorConf, and it is not a valid type for a parent conf.");
        }
        return parentConf.getOrAddChild(WILDCARD, element, elementMaps.get((Object)element));
    }

    private static Conf addConf(StramElement element, String name, Conf ancestorConf) {
        StramElement parentElement = ConfElement.getAllowedParentConf(element);
        Conf conf1 = null;
        Conf parentConf = LogicalPlanConfiguration.getConf(parentElement, ancestorConf);
        if (parentConf != null) {
            conf1 = parentConf.getOrAddChild(name, element, elementMaps.get((Object)element));
        }
        return conf1;
    }

    private <T extends Conf> List<T> getMatchingChildConf(List<? extends Conf> confs, String name, StramElement childType) {
        ArrayList childConfs = Lists.newArrayList();
        for (Conf conf : confs) {
            List matchingConfs = conf.getMatchingChildConf(name, childType);
            childConfs.addAll(matchingConfs);
        }
        return childConfs;
    }

    public LogicalPlanConfiguration(Configuration conf) {
        this.conf = conf;
        this.addFromConfiguration(conf);
    }

    public final void addFromConfiguration(Configuration conf) {
        this.addFromProperties(LogicalPlanConfiguration.toProperties(conf, "dt."), null);
    }

    public static Properties toProperties(Configuration conf, String prefix) {
        Iterator it = conf.iterator();
        Properties props = new Properties();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (!((String)e.getKey()).startsWith(prefix)) continue;
            props.put(e.getKey(), e.getValue());
        }
        return props;
    }

    public String getAppAlias(String appPath) {
        String appAlias;
        if (appPath.endsWith(CLASS_SUFFIX)) {
            appPath = appPath.replace("/", KEY_SEPARATOR).substring(0, appPath.length() - CLASS_SUFFIX.length());
        }
        if ((appAlias = (String)this.stramConf.appAliases.get(appPath)) == null) {
            try {
                ApplicationAnnotation an = Thread.currentThread().getContextClassLoader().loadClass(appPath).getAnnotation(ApplicationAnnotation.class);
                if (an != null && StringUtils.isNotBlank((CharSequence)an.name())) {
                    appAlias = an.name();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return appAlias;
    }

    public LogicalPlanConfiguration addFromJson(JSONObject json, Configuration conf) throws JSONException {
        Properties prop = new Properties();
        JSONArray operatorArray = json.getJSONArray("operators");
        for (int i = 0; i < operatorArray.length(); ++i) {
            JSONArray portArray;
            JSONObject operatorAttributes;
            JSONObject operator = operatorArray.getJSONObject(i);
            String operatorPrefix = "dt." + StramElement.OPERATOR.getValue() + KEY_SEPARATOR + operator.getString("name") + KEY_SEPARATOR;
            prop.setProperty(operatorPrefix + OPERATOR_CLASSNAME, operator.getString(CLASS));
            JSONObject operatorProperties = operator.optJSONObject("properties");
            if (operatorProperties != null) {
                String propertiesPrefix = operatorPrefix + StramElement.PROP.getValue() + KEY_SEPARATOR;
                Iterator iter = operatorProperties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    prop.setProperty(propertiesPrefix + key, operatorProperties.get(key).toString());
                }
            }
            if ((operatorAttributes = operator.optJSONObject("attributes")) != null) {
                String attributesPrefix = operatorPrefix + StramElement.ATTR.getValue() + KEY_SEPARATOR;
                Iterator iter = operatorAttributes.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    prop.setProperty(attributesPrefix + key, operatorAttributes.getString(key));
                }
            }
            if ((portArray = operator.optJSONArray("ports")) == null) continue;
            String portsPrefix = operatorPrefix + StramElement.PORT.getValue() + KEY_SEPARATOR;
            for (int j = 0; j < portArray.length(); ++j) {
                JSONObject port = portArray.getJSONObject(j);
                JSONObject portAttributes = port.optJSONObject("attributes");
                if (portAttributes == null) continue;
                String portAttributePrefix = portsPrefix + port.getString("name") + KEY_SEPARATOR + StramElement.ATTR.getValue() + KEY_SEPARATOR;
                Iterator iter = portAttributes.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    prop.setProperty(portAttributePrefix + key, portAttributes.getString(key));
                }
            }
        }
        JSONObject appAttributes = json.optJSONObject("attributes");
        if (appAttributes != null) {
            String attributesPrefix = "dt." + StramElement.ATTR.getValue() + KEY_SEPARATOR;
            Iterator iter = appAttributes.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                prop.setProperty(attributesPrefix + key, appAttributes.getString(key));
            }
        }
        JSONArray streamArray = json.getJSONArray("streams");
        for (int i = 0; i < streamArray.length(); ++i) {
            JSONObject schema;
            JSONObject stream = streamArray.getJSONObject(i);
            String name = stream.optString("name", "stream-" + i);
            String streamPrefix = "dt." + StramElement.STREAM.getValue() + KEY_SEPARATOR + name + KEY_SEPARATOR;
            JSONObject source = stream.getJSONObject(STREAM_SOURCE);
            prop.setProperty(streamPrefix + STREAM_SOURCE, source.getString("operatorName") + KEY_SEPARATOR + source.getString("portName"));
            JSONArray sinks = stream.getJSONArray(STREAM_SINKS);
            StringBuilder sinkPropertyValue = new StringBuilder();
            for (int j = 0; j < sinks.length(); ++j) {
                if (sinkPropertyValue.length() > 0) {
                    sinkPropertyValue.append(",");
                }
                JSONObject sink = sinks.getJSONObject(j);
                sinkPropertyValue.append(sink.getString("operatorName")).append(KEY_SEPARATOR).append(sink.getString("portName"));
            }
            prop.setProperty(streamPrefix + STREAM_SINKS, sinkPropertyValue.toString());
            String locality = stream.optString(STREAM_LOCALITY, null);
            if (locality != null) {
                prop.setProperty(streamPrefix + STREAM_LOCALITY, locality);
            }
            if ((schema = stream.optJSONObject(STREAM_SCHEMA)) == null) continue;
            String schemaClass = schema.getString(CLASS);
            prop.setProperty(streamPrefix + STREAM_SCHEMA, schemaClass);
        }
        return this.addFromProperties(prop, conf);
    }

    public LogicalPlanConfiguration addFromProperties(Properties props, Configuration conf) {
        if (conf != null) {
            StramClientUtils.evalProperties(props, conf);
        }
        for (String propertyName : props.stringPropertyNames()) {
            String propertyValue = props.getProperty(propertyName);
            this.properties.setProperty(propertyName, propertyValue);
            if (!propertyName.startsWith("dt.")) continue;
            String[] keyComps = propertyName.split(KEY_SEPARATOR_SPLIT_REGEX);
            this.parseStramPropertyTokens(keyComps, 1, propertyName, propertyValue, this.stramConf);
        }
        return this;
    }

    private void parseStramPropertyTokens(String[] keys, int index, String propertyName, String propertyValue, Conf conf) {
        if (index < keys.length) {
            String key = keys[index];
            StramElement element = this.getElement(key, conf);
            if (element == null && conf.ignoreUnknownChildren()) {
                return;
            }
            if (element == StramElement.APPLICATION || element == StramElement.OPERATOR || element == StramElement.STREAM || element == StramElement.PORT || element == StramElement.INPUT_PORT || element == StramElement.OUTPUT_PORT || element == StramElement.TEMPLATE) {
                this.parseAppElement(index, keys, element, conf, propertyName, propertyValue);
            } else if (element == StramElement.GATEWAY) {
                this.parseGatewayElement(element, conf, keys, index, propertyName, propertyValue);
            } else if (element == StramElement.UNIFIER) {
                this.parseUnifierElement(element, conf, keys, index, propertyName, propertyValue);
            } else if (element == StramElement.ATTR || element == null && conf.getDefaultChildElement() == StramElement.ATTR) {
                this.parseAttributeElement(element, keys, index, conf, propertyValue, propertyName);
            } else if (element == StramElement.PROP || element == null && conf.getDefaultChildElement() == StramElement.PROP) {
                this.parsePropertyElement(element, keys, index, conf, propertyValue, propertyName);
            } else if (element != null) {
                conf.parseElement(element, keys, index, propertyValue);
            }
        }
    }

    private void parseAppElement(int index, String[] keys, StramElement element, Conf conf1, String propertyName, String propertyValue) {
        if (index + 1 < keys.length) {
            String name = keys[index + 1];
            Conf elConf = LogicalPlanConfiguration.addConf(element, name, conf1);
            if (elConf != null) {
                this.parseStramPropertyTokens(keys, index + 2, propertyName, propertyValue, elConf);
            } else {
                LOG.error("Invalid configuration key: {}", (Object)propertyName);
            }
        } else {
            LOG.warn("Invalid configuration key: {}", (Object)propertyName);
        }
    }

    private void parseGatewayElement(StramElement element, Conf conf1, String[] keys, int index, String propertyName, String propertyValue) {
        Conf elConf = LogicalPlanConfiguration.addConf(element, null, conf1);
        if (elConf != null) {
            this.parseStramPropertyTokens(keys, index + 1, propertyName, propertyValue, elConf);
        } else {
            LOG.error("Invalid configuration key: {}", (Object)propertyName);
        }
    }

    private void parseUnifierElement(StramElement element, Conf conf1, String[] keys, int index, String propertyName, String propertyValue) {
        Conf elConf = LogicalPlanConfiguration.addConf(element, null, conf1);
        if (elConf != null) {
            this.parseStramPropertyTokens(keys, index + 1, propertyName, propertyValue, elConf);
        } else {
            LOG.error("Invalid configuration key: {}", (Object)propertyName);
        }
    }

    private void parseAttributeElement(StramElement element, String[] keys, int index, Conf conf, String propertyValue, String propertyName) {
        String attributeName = AttributeParseUtils.getAttributeName(element, keys, index);
        if (element != StramElement.ATTR) {
            String expName = LogicalPlanConfiguration.getCompleteKey(keys, 0, index) + KEY_SEPARATOR + StramElement.ATTR.getValue() + KEY_SEPARATOR + attributeName;
            LOG.warn("Referencing the attribute as {} instead of {} is deprecated!", (Object)LogicalPlanConfiguration.getCompleteKey(keys, 0), (Object)expName);
        }
        if (conf.getConfElement().getStramElement() == null) {
            conf = LogicalPlanConfiguration.addConf(StramElement.APPLICATION, WILDCARD, conf);
        }
        if (conf != null) {
            if (AttributeParseUtils.isSimpleAttributeName(attributeName)) {
                if (!AttributeParseUtils.ALL_SIMPLE_ATTRIBUTE_NAMES.contains(attributeName)) {
                    throw new ValidationException("Invalid attribute reference: " + LogicalPlanConfiguration.getCompleteKey(keys, 0));
                }
                if (!conf.getConfElement().getAllChildAttributes().contains(attributeName)) {
                    throw new ValidationException(attributeName + " is not defined for the " + (Object)((Object)conf.getConfElement().getStramElement()) + " or any of its child configurations.");
                }
                if (conf.getConfElement().getAmbiguousAttributes().contains(attributeName)) {
                    LOG.warn("The attribute " + attributeName + " is ambiguous when specified on an " + (Object)((Object)conf.getConfElement().getStramElement()));
                }
                if (conf.getConfElement().getContextAttributes().contains(attributeName)) {
                    Attribute<?> attr = ContextUtils.CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.get(conf.getConfElement().getContextClass()).get(attributeName);
                    conf.setAttribute(attr, propertyValue);
                } else {
                    AttributeParseUtils.processAllConfsForAttribute(conf, attributeName, propertyValue);
                }
            } else {
                Class<? extends Context> contextClass = AttributeParseUtils.getContainingContextClass(attributeName);
                attributeName = AttributeParseUtils.getSimpleAttributeName(attributeName);
                if (!ContextUtils.CONTEXT_CLASS_TO_ATTRIBUTES.get(contextClass).contains(attributeName)) {
                    throw new ValidationException(attributeName + " is not a valid attribute in " + contextClass.getCanonicalName());
                }
                ConfElement confWithAttr = ConfElement.CONTEXT_TO_CONF_ELEMENT.get(contextClass);
                conf = ConfElement.addConfs(conf, confWithAttr);
                Attribute<?> attr = ContextUtils.CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.get(confWithAttr.getContextClass()).get(attributeName);
                conf.setAttribute(attr, propertyValue);
            }
        } else {
            LOG.error("Invalid configuration key: {}", (Object)propertyName);
        }
    }

    private void parsePropertyElement(StramElement element, String[] keys, int index, Conf conf, String propertyValue, String propertyName) {
        String prop = element == StramElement.PROP ? LogicalPlanConfiguration.getCompleteKey(keys, index + 1) : LogicalPlanConfiguration.getCompleteKey(keys, index);
        if (prop != null) {
            conf.setProperty(prop, propertyValue);
        } else {
            LOG.warn("Invalid property specification, no property name specified for {}", (Object)propertyName);
        }
    }

    private StramElement getElement(String value, Conf conf) {
        StramElement element = null;
        try {
            element = StramElement.fromValue(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (element != null && !conf.isAllowedChild(element)) {
            element = null;
        }
        return element;
    }

    private static String getCompleteKey(String[] keys, int start) {
        return LogicalPlanConfiguration.getCompleteKey(keys, start, keys.length);
    }

    private static String getCompleteKey(String[] keys, int start, int end) {
        int length = 0;
        for (int keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            length += keys[keyIndex].length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = start; i < end; ++i) {
            if (i > start) {
                sb.append(KEY_SEPARATOR);
            }
            sb.append(keys[i]);
        }
        return sb.toString();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, String> getAppAliases() {
        return Collections.unmodifiableMap(this.stramConf.appAliases);
    }

    public LogicalPlan createFromProperties(Properties props, String appName) throws IOException {
        LogicalPlanConfiguration tb = new LogicalPlanConfiguration(new Configuration(false));
        tb.addFromProperties(props, this.conf);
        LogicalPlan dag = new LogicalPlan();
        tb.populateDAG(dag);
        tb.prepareDAG(dag, null, appName);
        this.prepareDAG(dag, null, appName);
        return dag;
    }

    public LogicalPlan createFromJson(JSONObject json, String appName) throws Exception {
        LogicalPlanConfiguration tb = new LogicalPlanConfiguration(new Configuration(false));
        tb.addFromJson(json, this.conf);
        LogicalPlan dag = new LogicalPlan();
        tb.populateDAG(dag);
        tb.prepareDAG(dag, null, appName);
        this.prepareDAG(dag, null, appName);
        return dag;
    }

    public void populateDAG(LogicalPlan dag) {
        Configuration pconf = new Configuration(this.conf);
        for (String propertyName : this.properties.stringPropertyNames()) {
            String propertyValue = this.properties.getProperty(propertyName);
            pconf.setIfUnset(propertyName, propertyValue);
        }
        AppConf appConf = (AppConf)this.stramConf.getChild(WILDCARD, StramElement.APPLICATION);
        if (appConf == null) {
            LOG.warn("Application configuration not found. Probably an empty app.");
            return;
        }
        Map operators = appConf.getChildren(StramElement.OPERATOR);
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)operators.size());
        for (Map.Entry nodeConfEntry : operators.entrySet()) {
            OperatorConf nodeConf = (OperatorConf)nodeConfEntry.getValue();
            if (WILDCARD.equals(nodeConf.id)) continue;
            Class<Operator> nodeClass = StramUtils.classForName(nodeConf.getClassNameReqd(), Operator.class);
            String optJson = (String)nodeConf.getProperties().get(nodeClass.getName());
            Operator nd = null;
            try {
                if (optJson != null) {
                    ObjectMapper mapper = ObjectMapperFactory.getOperatorValueDeserializer();
                    nd = (Operator)mapper.readValue("{\"" + nodeClass.getName() + "\":" + optJson + "}", nodeClass);
                    dag.addOperator(nodeConfEntry.getKey(), nd);
                } else {
                    nd = dag.addOperator(nodeConfEntry.getKey(), nodeClass);
                }
                LogicalPlanConfiguration.setOperatorProperties(nd, nodeConf.getProperties());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error setting operator properties " + e.getMessage(), e);
            }
            nodeMap.put(nodeConf, nd);
        }
        Map streams = appConf.getChildren(StramElement.STREAM);
        for (Map.Entry streamConfEntry : streams.entrySet()) {
            StreamConf streamConf = (StreamConf)streamConfEntry.getValue();
            LogicalPlan.StreamMeta sd = dag.addStream(streamConfEntry.getKey());
            sd.setLocality(streamConf.getLocality());
            String schemaClassName = streamConf.properties.getProperty(STREAM_SCHEMA);
            Class<Object> schemaClass = null;
            if (schemaClassName != null) {
                schemaClass = StramUtils.classForName(schemaClassName, Object.class);
            }
            if (streamConf.sourceNode != null) {
                String portName = null;
                for (Map.Entry e : streamConf.sourceNode.outputs.entrySet()) {
                    if (e.getValue() != streamConf) continue;
                    portName = (String)e.getKey();
                }
                Operator sourceDecl = (Operator)nodeMap.get(streamConf.sourceNode);
                Operators.PortMappingDescriptor sourcePortMap = new Operators.PortMappingDescriptor();
                Operators.describe(sourceDecl, sourcePortMap);
                sd.setSource((Operator.OutputPort)sourcePortMap.outputPorts.get((Object)portName).component);
                if (schemaClass != null) {
                    dag.setOutputPortAttribute((Operator.OutputPort)sourcePortMap.outputPorts.get((Object)portName).component, Context.PortContext.TUPLE_CLASS, schemaClass);
                }
            }
            for (OperatorConf targetNode : streamConf.targetNodes) {
                String portName = null;
                for (Map.Entry e : targetNode.inputs.entrySet()) {
                    if (e.getValue() != streamConf) continue;
                    portName = (String)e.getKey();
                }
                Operator targetDecl = (Operator)nodeMap.get(targetNode);
                Operators.PortMappingDescriptor targetPortMap = new Operators.PortMappingDescriptor();
                Operators.describe(targetDecl, targetPortMap);
                sd.addSink((Operator.InputPort)targetPortMap.inputPorts.get((Object)portName).component);
                if (schemaClass == null) continue;
                dag.setInputPortAttribute((Operator.InputPort)targetPortMap.inputPorts.get((Object)portName).component, Context.PortContext.TUPLE_CLASS, schemaClass);
            }
        }
    }

    public void prepareDAG(LogicalPlan dag, StreamingApplication app, String name) {
        String appAlias;
        String connectAddress = this.conf.get("dt." + Context.DAGContext.GATEWAY_CONNECT_ADDRESS.getName());
        dag.setAttribute(Context.DAGContext.GATEWAY_CONNECT_ADDRESS, connectAddress == null ? this.conf.get(GATEWAY_LISTEN_ADDRESS) : connectAddress);
        if (app != null) {
            app.populateDAG((DAG)dag, this.conf);
        }
        String appName = (appAlias = this.getAppAlias(name)) == null ? name : appAlias;
        List<AppConf> appConfs = this.stramConf.getMatchingChildConf(appName, StramElement.APPLICATION);
        this.setApplicationConfiguration(dag, appConfs, app);
        if (dag.getAttributes().get(Context.DAGContext.APPLICATION_NAME) == null) {
            dag.setAttribute(Context.DAGContext.APPLICATION_NAME, appName);
        }
        this.setModuleProperties(dag, appName);
        this.flattenDAG(dag, this.conf);
        this.setOperatorConfiguration(dag, appConfs, appName);
        this.setStreamConfiguration(dag, appConfs, appName);
    }

    private void flattenDAG(LogicalPlan dag, Configuration conf) {
        for (LogicalPlan.ModuleMeta moduleMeta : dag.getAllModules()) {
            moduleMeta.flattenModule(dag, conf);
        }
        dag.applyStreamLinks();
    }

    public static Properties readProperties(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        Properties props = new Properties(System.getProperties());
        props.load(is);
        ((InputStream)is).close();
        return props;
    }

    public Map<String, String> getProperties(LogicalPlan.OperatorMeta ow, String appName) {
        List appConfs = this.stramConf.getMatchingChildConf(appName, StramElement.APPLICATION);
        List<OperatorConf> opConfs = this.getMatchingChildConf(appConfs, ow.getName(), StramElement.OPERATOR);
        return this.getProperties(this.getPropertyArgs(ow), opConfs, appName);
    }

    private Map<String, String> getApplicationProperties(List<AppConf> appConfs) {
        HashMap appProps = Maps.newHashMap();
        for (int i = appConfs.size() - 1; i >= 0; --i) {
            AppConf conf1 = appConfs.get(i);
            appProps.putAll(Maps.fromProperties((Properties)conf1.properties));
        }
        return appProps;
    }

    private Map<String, String> getProperties(PropertyArgs pa, List<OperatorConf> opConfs, String appName) {
        HashMap opProps = Maps.newHashMap();
        Map<String, TemplateConf> templates = this.stramConf.getChildren(StramElement.TEMPLATE);
        if (!templates.isEmpty()) {
            TreeMap<Integer, TemplateConf> matchingTemplates = this.getMatchingTemplates(pa, appName, templates);
            if (matchingTemplates != null && !matchingTemplates.isEmpty()) {
                for (TemplateConf t : matchingTemplates.descendingMap().values()) {
                    opProps.putAll(Maps.fromProperties((Properties)t.properties));
                }
            }
            List<TemplateConf> refTemplates = this.getDirectTemplates(opConfs, templates);
            for (TemplateConf t : refTemplates) {
                opProps.putAll(Maps.fromProperties((Properties)t.properties));
            }
        }
        for (int i = opConfs.size() - 1; i >= 0; --i) {
            Conf conf1 = opConfs.get(i);
            opProps.putAll(Maps.fromProperties((Properties)conf1.properties));
        }
        return opProps;
    }

    private List<TemplateConf> getDirectTemplates(List<OperatorConf> opConfs, Map<String, TemplateConf> templates) {
        ArrayList refTemplates = Lists.newArrayList();
        for (TemplateConf t : templates.values()) {
            for (OperatorConf opConf : opConfs) {
                if (!t.id.equals(opConf.templateRef)) continue;
                refTemplates.add(t);
            }
        }
        return refTemplates;
    }

    private PropertyArgs getPropertyArgs(LogicalPlan.OperatorMeta om) {
        return new PropertyArgs(om.getName(), om.getOperator().getClass().getName());
    }

    private PropertyArgs getPropertyArgs(LogicalPlan.ModuleMeta mm) {
        return new PropertyArgs(mm.getName(), mm.getModule().getClass().getName());
    }

    private TreeMap<Integer, TemplateConf> getMatchingTemplates(PropertyArgs pa, String appName, Map<String, TemplateConf> templates) {
        TreeMap tm = Maps.newTreeMap();
        for (TemplateConf t : templates.values()) {
            if (t.idRegExp != null && pa.name.matches(t.idRegExp)) {
                tm.put(1, t);
                continue;
            }
            if (appName != null && t.appNameRegExp != null && appName.matches(t.appNameRegExp)) {
                tm.put(2, t);
                continue;
            }
            if (t.classNameRegExp == null || !pa.className.matches(t.classNameRegExp)) continue;
            tm.put(3, t);
        }
        return tm;
    }

    public static Operator setOperatorProperties(Operator operator, Map<String, String> properties) {
        try {
            BeanUtils.populate((Object)operator, properties);
            return operator;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Error setting operator properties", e);
        }
    }

    public static <T> T setObjectProperties(T obj, Map<String, String> properties) {
        try {
            BeanUtils.populate(obj, properties);
            return obj;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error setting operator properties", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error setting operator properties", e);
        }
    }

    public static StreamingApplication setApplicationProperties(StreamingApplication application, Map<String, String> properties) {
        try {
            BeanUtils.populate((Object)application, properties);
            return application;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Error setting application properties", e);
        }
    }

    public static BeanMap getObjectProperties(Object obj) {
        return new BeanMap(obj);
    }

    public void setOperatorProperties(LogicalPlan dag, String applicationName) {
        List appConfs = this.stramConf.getMatchingChildConf(applicationName, StramElement.APPLICATION);
        for (LogicalPlan.OperatorMeta ow : dag.getAllOperators()) {
            List<OperatorConf> opConfs = this.getMatchingChildConf(appConfs, ow.getName(), StramElement.OPERATOR);
            Map<String, String> opProps = this.getProperties(this.getPropertyArgs(ow), opConfs, applicationName);
            LogicalPlanConfiguration.setOperatorProperties(ow.getOperator(), opProps);
        }
    }

    public void setModuleProperties(LogicalPlan dag, String applicationName) {
        List<AppConf> appConfs = this.stramConf.getMatchingChildConf(applicationName, StramElement.APPLICATION);
        this.setModuleConfiguration(dag, appConfs, applicationName);
    }

    public void setApplicationConfiguration(LogicalPlan dag, String appName, StreamingApplication app) {
        List<AppConf> appConfs = this.stramConf.getMatchingChildConf(appName, StramElement.APPLICATION);
        this.setApplicationConfiguration(dag, appConfs, app);
    }

    private void setApplicationConfiguration(LogicalPlan dag, List<AppConf> appConfs, StreamingApplication app) {
        this.setAttributes(appConfs, dag.getAttributes());
        if (app != null) {
            Map<String, String> appProps = this.getApplicationProperties(appConfs);
            LogicalPlanConfiguration.setApplicationProperties(app, appProps);
        }
    }

    private void setOperatorConfiguration(LogicalPlan dag, List<AppConf> appConfs, String appName) {
        for (LogicalPlan.OperatorMeta ow : dag.getAllOperators()) {
            List portConfs;
            List<OperatorConf> opConfs = this.getMatchingChildConf(appConfs, ow.getName(), StramElement.OPERATOR);
            this.setAttributes(opConfs, ow.getAttributes());
            Map<String, String> opProps = this.getProperties(this.getPropertyArgs(ow), opConfs, appName);
            LogicalPlanConfiguration.setOperatorProperties(ow.getOperator(), opProps);
            for (Map.Entry<LogicalPlan.InputPortMeta, LogicalPlan.StreamMeta> entry : ow.getInputStreams().entrySet()) {
                LogicalPlan.InputPortMeta im = entry.getKey();
                List inPortConfs = this.getMatchingChildConf(opConfs, im.getPortName(), StramElement.INPUT_PORT);
                portConfs = this.getMatchingChildConf(opConfs, im.getPortName(), StramElement.PORT);
                inPortConfs.addAll(portConfs);
                this.setAttributes(inPortConfs, im.getAttributes());
            }
            for (Map.Entry<Serializable, LogicalPlan.StreamMeta> entry : ow.getOutputStreams().entrySet()) {
                LogicalPlan.OutputPortMeta om = (LogicalPlan.OutputPortMeta)entry.getKey();
                List outPortConfs = this.getMatchingChildConf(opConfs, om.getPortName(), StramElement.OUTPUT_PORT);
                portConfs = this.getMatchingChildConf(opConfs, om.getPortName(), StramElement.PORT);
                outPortConfs.addAll(portConfs);
                this.setAttributes(outPortConfs, om.getAttributes());
                List unifConfs = this.getMatchingChildConf(outPortConfs, null, StramElement.UNIFIER);
                if (unifConfs.size() == 0) continue;
                this.setAttributes(unifConfs, om.getUnifierMeta().getAttributes());
            }
            ow.populateAggregatorMeta();
        }
    }

    private void setModuleConfiguration(LogicalPlan dag, List<AppConf> appConfs, String appName) {
        for (LogicalPlan.ModuleMeta mw : dag.getAllModules()) {
            List<OperatorConf> opConfs = this.getMatchingChildConf(appConfs, mw.getName(), StramElement.OPERATOR);
            Map<String, String> opProps = this.getProperties(this.getPropertyArgs(mw), opConfs, appName);
            LogicalPlanConfiguration.setObjectProperties(mw.getModule(), opProps);
        }
    }

    private void setStreamConfiguration(LogicalPlan dag, List<AppConf> appConfs, String appAlias) {
        block0: for (LogicalPlan.StreamMeta sm : dag.getAllStreams()) {
            List smConfs = this.getMatchingChildConf(appConfs, sm.getName(), StramElement.STREAM);
            for (StreamConf smConf : smConfs) {
                DAG.Locality locality = smConf.getLocality();
                if (locality == null) continue;
                sm.setLocality(locality);
                continue block0;
            }
        }
    }

    private void setAttributes(List<? extends Conf> confs, Attribute.AttributeMap attributeMap) {
        HashSet processedAttributes = Sets.newHashSet();
        JSONObject2String jsonCodec = new JSONObject2String();
        if (confs.size() > 0) {
            for (Conf conf : confs) {
                for (Map.Entry<Attribute<Object>, String> e : conf.attributes.entrySet()) {
                    Attribute<Object> attribute = e.getKey();
                    if (attribute.codec == null) {
                        String msg = String.format("Attribute does not support property configuration: %s %s", attribute.name, e.getValue());
                        throw new UnsupportedOperationException(msg);
                    }
                    if (!processedAttributes.add(attribute)) continue;
                    String val = e.getValue();
                    if (val.trim().charAt(0) == '{') {
                        attributeMap.put(attribute, jsonCodec.fromString(val));
                        continue;
                    }
                    attributeMap.put(attribute, attribute.codec.fromString(val));
                }
            }
        }
    }

    static {
        Object[] serial = new Object[]{Context.DAGContext.serialVersionUID, Context.OperatorContext.serialVersionUID, Context.PortContext.serialVersionUID};
        LOG.debug("Initialized attributes {}", serial);
        elementMaps = Maps.newHashMap();
        elementMaps.put(null, StramConf.class);
        elementMaps.put(StramElement.APPLICATION, AppConf.class);
        elementMaps.put(StramElement.GATEWAY, GatewayConf.class);
        elementMaps.put(StramElement.TEMPLATE, TemplateConf.class);
        elementMaps.put(StramElement.OPERATOR, OperatorConf.class);
        elementMaps.put(StramElement.STREAM, StreamConf.class);
        elementMaps.put(StramElement.PORT, PortConf.class);
        elementMaps.put(StramElement.INPUT_PORT, PortConf.class);
        elementMaps.put(StramElement.OUTPUT_PORT, PortConf.class);
        elementMaps.put(StramElement.UNIFIER, OperatorConf.class);
    }

    private static class PropertyArgs {
        String name;
        String className;

        public PropertyArgs(String name, String className) {
            this.name = name;
            this.className = className;
        }
    }

    private static class PortConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.ATTR, StramElement.UNIFIER};

        PortConf() {
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.PORT;
        }
    }

    private static class OperatorConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.PORT, StramElement.INPUT_PORT, StramElement.OUTPUT_PORT, StramElement.ATTR, StramElement.PROP};
        private final Map<String, StreamConf> inputs = Maps.newHashMap();
        private final Map<String, StreamConf> outputs = Maps.newHashMap();
        private String templateRef;

        OperatorConf() {
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.OPERATOR;
        }

        @Override
        public void setProperty(String name, String value) {
            if ("template".equals(name)) {
                this.templateRef = value;
                StramConf stramConf = (StramConf)this.getAncestorConf(null);
                TemplateConf templateConf = (TemplateConf)stramConf.getOrAddChild(value, StramElement.TEMPLATE, (Class)elementMaps.get((Object)StramElement.TEMPLATE));
                this.setDefaultProperties(templateConf.properties);
            } else {
                super.setProperty(name, value);
            }
        }

        private String getClassNameReqd() {
            String className = this.properties.getProperty(LogicalPlanConfiguration.OPERATOR_CLASSNAME);
            if (className == null) {
                throw new IllegalArgumentException(String.format("Operator '%s' is missing property '%s'", this.getId(), LogicalPlanConfiguration.OPERATOR_CLASSNAME));
            }
            return className;
        }

        private Map<String, String> getProperties() {
            return Maps.fromProperties((Properties)this.properties);
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public StramElement getDefaultChildElement() {
            return StramElement.PROP;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).toString();
        }
    }

    private static class PropertiesWithModifiableDefaults
    extends Properties {
        private static final long serialVersionUID = -4675421720308249982L;

        private PropertiesWithModifiableDefaults() {
        }

        void setDefaultProperties(Properties defaults) {
            this.defaults = defaults;
        }
    }

    private static class StreamConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.TEMPLATE, StramElement.PROP};
        private OperatorConf sourceNode;
        private final Set<OperatorConf> targetNodes = new HashSet<OperatorConf>();

        StreamConf() {
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.STREAM;
        }

        public DAG.Locality getLocality() {
            String v = this.properties.getProperty(LogicalPlanConfiguration.STREAM_LOCALITY, null);
            return v != null ? DAG.Locality.valueOf((String)v) : null;
        }

        public StreamConf setSource(String portName, OperatorConf node) {
            if (this.sourceNode != null) {
                throw new IllegalArgumentException(String.format("Stream already receives input from %s", this.sourceNode));
            }
            node.outputs.put(portName, this);
            this.sourceNode = node;
            return this;
        }

        public StreamConf addSink(String portName, OperatorConf targetNode) {
            if (targetNode.inputs.containsKey(portName)) {
                throw new IllegalArgumentException(String.format("Port %s already connected to stream %s", portName, targetNode.inputs.get(portName)));
            }
            targetNode.inputs.put(portName, this);
            this.targetNodes.add(targetNode);
            return this;
        }

        @Override
        public void setProperty(String name, String value) {
            AppConf appConf = (AppConf)this.getParentConf();
            if (LogicalPlanConfiguration.STREAM_SOURCE.equals(name)) {
                if (this.sourceNode != null) {
                    throw new IllegalArgumentException("Duplicate " + name);
                }
                String[] parts = this.getNodeAndPortId(value);
                this.setSource(parts[1], appConf.getOrAddChild(parts[0], StramElement.OPERATOR, OperatorConf.class));
            } else if (LogicalPlanConfiguration.STREAM_SINKS.equals(name)) {
                String[] targetPorts;
                for (String nodeAndPort : targetPorts = value.split(",")) {
                    String[] parts = this.getNodeAndPortId(nodeAndPort.trim());
                    this.addSink(parts[1], appConf.getOrAddChild(parts[0], StramElement.OPERATOR, OperatorConf.class));
                }
            } else if ("template".equals(name)) {
                StramConf stramConf = (StramConf)this.getAncestorConf(null);
                TemplateConf templateConf = (TemplateConf)stramConf.getOrAddChild(value, StramElement.TEMPLATE, (Class)elementMaps.get((Object)StramElement.TEMPLATE));
                this.setDefaultProperties(templateConf.properties);
            } else {
                super.setProperty(name, value);
            }
        }

        private String[] getNodeAndPortId(String s) {
            String[] parts = s.split(LogicalPlanConfiguration.KEY_SEPARATOR_SPLIT_REGEX);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid node.port reference: " + s);
            }
            return parts;
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).toString();
        }
    }

    private static class TemplateConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.PROP};
        private String idRegExp;
        private String appNameRegExp;
        private String classNameRegExp;

        TemplateConf() {
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.TEMPLATE;
        }

        @Override
        public void setProperty(String name, String value) {
            if (name.equals(LogicalPlanConfiguration.TEMPLATE_appNameRegExp)) {
                this.appNameRegExp = value;
            } else if (name.equals(LogicalPlanConfiguration.TEMPLATE_idRegExp)) {
                this.idRegExp = value;
            } else if (name.equals(LogicalPlanConfiguration.TEMPLATE_classNameRegExp)) {
                this.classNameRegExp = value;
            } else {
                super.setProperty(name, value);
            }
        }
    }

    private static class GatewayConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.PROP};

        GatewayConf() {
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.GATEWAY;
        }
    }

    private static class AppConf
    extends Conf {
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.GATEWAY, StramElement.OPERATOR, StramElement.PORT, StramElement.INPUT_PORT, StramElement.OUTPUT_PORT, StramElement.STREAM, StramElement.ATTR, StramElement.CLASS, StramElement.PATH, StramElement.PROP, StramElement.UNIFIER};

        AppConf() {
        }

        @Override
        public void parseElement(StramElement element, String[] keys, int index, String propertyValue) {
            if (element == StramElement.CLASS || element == StramElement.PATH) {
                StramConf stramConf = (StramConf)this.getParentConf();
                stramConf.appAliases.put(propertyValue, this.getId());
            }
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public StramElement getDefaultChildElement() {
            return StramElement.PROP;
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.APPLICATION;
        }
    }

    private static class StramConf
    extends Conf {
        private final Map<String, String> appAliases = Maps.newHashMap();
        private static final StramElement[] CHILD_ELEMENTS = new StramElement[]{StramElement.APPLICATION, StramElement.GATEWAY, StramElement.TEMPLATE, StramElement.OPERATOR, StramElement.PORT, StramElement.INPUT_PORT, StramElement.OUTPUT_PORT, StramElement.STREAM, StramElement.TEMPLATE, StramElement.ATTR, StramElement.UNIFIER};

        StramConf() {
        }

        @Override
        public StramElement[] getChildElements() {
            return CHILD_ELEMENTS;
        }

        @Override
        public ConfElement getConfElement() {
            return ConfElement.STRAM;
        }
    }

    private static abstract class Conf {
        protected Conf parentConf = null;
        protected final Map<Attribute<Object>, String> attributes = Maps.newHashMap();
        protected final PropertiesWithModifiableDefaults properties = new PropertiesWithModifiableDefaults();
        protected Map<StramElement, Map<String, ? extends Conf>> children = Maps.newHashMap();
        protected String id;

        private Conf() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setParentConf(Conf parentConf) {
            this.parentConf = parentConf;
        }

        public <T extends Conf> T getParentConf() {
            return (T)this.parentConf;
        }

        public <T extends Conf> T getAncestorConf(StramElement ancestorElement) {
            if (this.getConfElement().getStramElement() == ancestorElement) {
                return (T)this;
            }
            if (this.parentConf == null) {
                return null;
            }
            return this.parentConf.getAncestorConf(ancestorElement);
        }

        public <T extends Conf> T getOrAddChild(String id, StramElement childType, Class<T> clazz) {
            T conf;
            HashMap elChildren = this.children.get((Object)childType);
            if (elChildren == null) {
                elChildren = Maps.newHashMap();
                this.children.put(childType, elChildren);
            }
            if ((conf = this.getOrAddConf(elChildren, id, clazz)) != null) {
                ((Conf)conf).setParentConf(this);
            }
            return conf;
        }

        public void setAttribute(Attribute<Object> attr, String value) {
            this.attributes.put(attr, value);
        }

        public void setProperty(String name, String value) {
            this.properties.setProperty(name, value);
        }

        public void setDefaultProperties(Properties defaults) {
            this.properties.setDefaultProperties(defaults);
        }

        public <T extends Conf> List<T> getMatchingChildConf(String name, StramElement childType) {
            ArrayList<T> childConfs = new ArrayList<T>();
            Map<String, T> elChildren = this.getChildren(childType);
            for (Map.Entry<String, T> entry : elChildren.entrySet()) {
                String key = entry.getKey();
                boolean match = false;
                boolean exact = false;
                if (name == null) {
                    if (key == null) {
                        match = true;
                        exact = true;
                    } else if (key.equals(LogicalPlanConfiguration.WILDCARD)) {
                        match = true;
                    }
                } else {
                    if (key.equals(LogicalPlanConfiguration.WILDCARD)) {
                        key = LogicalPlanConfiguration.WILDCARD_PATTERN;
                    }
                    if (name.matches(key)) {
                        match = true;
                    }
                    if (name.equals(key)) {
                        exact = true;
                    }
                }
                if (!match) continue;
                if (!exact) {
                    childConfs.add(entry.getValue());
                    continue;
                }
                childConfs.add(0, entry.getValue());
            }
            return childConfs;
        }

        protected <T extends Conf> T getOrAddConf(Map<String, T> map, String id, Class<T> clazz) {
            Conf conf = (Conf)map.get(id);
            if (conf == null) {
                try {
                    Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
                    conf = (Conf)declaredConstructor.newInstance(new Object[0]);
                    conf.setId(id);
                    map.put(id, conf);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.error("Error instantiating configuration", (Throwable)e);
                }
            }
            return (T)conf;
        }

        public <T extends Conf> T getChild(String id, StramElement childType) {
            Conf conf = null;
            Map<String, ? extends Conf> elChildren = this.children.get((Object)childType);
            if (elChildren != null) {
                conf = elChildren.get(id);
            }
            return (T)conf;
        }

        public <T extends Conf> Map<String, T> getChildren(StramElement childType) {
            HashMap elChildren = this.children.get((Object)childType);
            if (elChildren == null) {
                elChildren = Maps.newHashMap();
                this.children.put(childType, elChildren);
            }
            return elChildren;
        }

        public void parseElement(StramElement element, String[] keys, int index, String propertyValue) {
        }

        public boolean isAllowedChild(StramElement childType) {
            StramElement[] childElements = this.getChildElements();
            if (childElements != null) {
                for (StramElement childElement : childElements) {
                    if (childType != childElement) continue;
                    return true;
                }
            }
            return false;
        }

        public StramElement getDefaultChildElement() {
            if (this.getConfElement().getContextClass() == null && this.isAllowedChild(StramElement.PROP)) {
                return StramElement.PROP;
            }
            return null;
        }

        public boolean ignoreUnknownChildren() {
            return this.getDefaultChildElement() == null;
        }

        public abstract StramElement[] getChildElements();

        public abstract ConfElement getConfElement();
    }

    public class JSONObject2String
    implements StringCodec<Object>,
    Serializable {
        private static final long serialVersionUID = -664977453308585878L;

        public Object fromString(String jsonObj) {
            LOG.debug("JONString {}", (Object)jsonObj);
            ObjectMapper mapper = ObjectMapperFactory.getOperatorValueDeserializer();
            try {
                return mapper.readValue(jsonObj, Object.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Error parsing json content", e);
            }
        }

        public String toString(Object pojo) {
            ObjectMapper mapper = ObjectMapperFactory.getOperatorValueDeserializer();
            try {
                return mapper.writeValueAsString(pojo);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing object as json", e);
            }
        }
    }

    protected static class AttributeParseUtils {
        public static final Set<String> ALL_SIMPLE_ATTRIBUTE_NAMES = Sets.newHashSet();

        public static void initialize() {
            ALL_SIMPLE_ATTRIBUTE_NAMES.clear();
            for (Map.Entry<Class<? extends Context>, Set<String>> entry : ContextUtils.CONTEXT_CLASS_TO_ATTRIBUTES.entrySet()) {
                ALL_SIMPLE_ATTRIBUTE_NAMES.addAll((Collection<String>)entry.getValue());
            }
        }

        private AttributeParseUtils() {
        }

        protected static void processAllConfsForAttribute(Conf conf, String attributeName, String attrValue) {
            ConfElement confElement = conf.getConfElement();
            LOG.debug("Current confElement {} and name {}", (Object)confElement.getStramElement(), (Object)conf.getId());
            if (confElement.getContextAttributes().contains(attributeName)) {
                LOG.debug("Adding attribute");
                Attribute<?> attr = ContextUtils.CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.get(confElement.getContextClass()).get(attributeName);
                conf.setAttribute(attr, attrValue);
            }
            for (ConfElement childConfElement : confElement.getChildren()) {
                if (!childConfElement.getAllChildAttributes().contains(attributeName)) continue;
                Conf childConf = LogicalPlanConfiguration.addConf(childConfElement.getStramElement(), LogicalPlanConfiguration.WILDCARD, conf);
                AttributeParseUtils.processAllConfsForAttribute(childConf, attributeName, attrValue);
            }
        }

        public static String getAttributeName(StramElement element, String[] keys, int index) {
            if (element != null && element != StramElement.ATTR) {
                throw new IllegalArgumentException("The given " + StramElement.class + " must either have a value of null or " + (Object)((Object)StramElement.ATTR) + " but it had a value of " + (Object)((Object)element));
            }
            String attributeName = element == StramElement.ATTR ? LogicalPlanConfiguration.getCompleteKey(keys, index + 1) : LogicalPlanConfiguration.getCompleteKey(keys, index);
            return attributeName;
        }

        public static boolean isSimpleAttributeName(String attributeName) {
            return !attributeName.contains(LogicalPlanConfiguration.KEY_SEPARATOR);
        }

        public static Class<? extends Context> getContainingContextClass(String attributeName) {
            Class<?> contextClass;
            if (AttributeParseUtils.isSimpleAttributeName(attributeName)) {
                throw new IllegalArgumentException("The given attribute name " + attributeName + " is simple.");
            }
            LOG.debug("Attribute Name {}", (Object)attributeName);
            int lastSeparator = attributeName.lastIndexOf(LogicalPlanConfiguration.KEY_SEPARATOR);
            String contextClassName = attributeName.substring(0, lastSeparator);
            int lastPeriod = contextClassName.lastIndexOf(LogicalPlanConfiguration.KEY_SEPARATOR);
            StringBuilder sb = new StringBuilder(contextClassName);
            sb.setCharAt(lastPeriod, '$');
            contextClassName = sb.toString();
            try {
                Class<?> clazz = Class.forName(contextClassName);
                if (!Context.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The provided context class name " + contextClassName + " is not valid.");
                }
                contextClass = clazz;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
            String simpleAttributeName = AttributeParseUtils.getSimpleAttributeName(attributeName);
            if (!ContextUtils.CONTEXT_CLASS_TO_ATTRIBUTES.get(contextClass).contains(simpleAttributeName)) {
                throw new ValidationException(simpleAttributeName + " is not a valid attribute of " + contextClass);
            }
            return contextClass;
        }

        public static String getSimpleAttributeName(String attributeName) {
            if (AttributeParseUtils.isSimpleAttributeName(attributeName)) {
                return attributeName;
            }
            if (attributeName.endsWith(LogicalPlanConfiguration.KEY_SEPARATOR)) {
                throw new IllegalArgumentException("The given attribute name ends with \".\" so a simple name cannot be extracted.");
            }
            return attributeName.substring(attributeName.lastIndexOf(LogicalPlanConfiguration.KEY_SEPARATOR) + 1, attributeName.length());
        }

        public static String getSimpleName(Attribute<?> attribute) {
            return AttributeParseUtils.getSimpleAttributeName(attribute.name);
        }

        static {
            AttributeParseUtils.initialize();
        }
    }

    protected static class ContextUtils {
        private static final Map<String, Type> ATTRIBUTES_TO_TYPE = Maps.newHashMap();
        public static final Map<Class<? extends Context>, Set<String>> CONTEXT_CLASS_TO_ATTRIBUTES = Maps.newHashMap();
        public static final Set<Class<? extends Context>> CONTEXT_CLASSES = Sets.newHashSet();
        public static final Map<Class<? extends Context>, Map<String, Attribute<?>>> CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE = Maps.newHashMap();

        @VisibleForTesting
        protected static void initialize() {
            CONTEXT_CLASSES.clear();
            for (Class<?> clazz : Context.class.getDeclaredClasses()) {
                if (!Context.class.isAssignableFrom(clazz)) continue;
                CONTEXT_CLASSES.add(clazz);
            }
            ContextUtils.buildAttributeMaps(CONTEXT_CLASSES);
        }

        @VisibleForTesting
        protected static void buildAttributeMaps(Set<Class<? extends Context>> contextClasses) {
            CONTEXT_CLASS_TO_ATTRIBUTES.clear();
            CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.clear();
            ATTRIBUTES_TO_TYPE.clear();
            for (Class<? extends Context> contextClass : contextClasses) {
                Field[] fields;
                HashSet contextAttributes = Sets.newHashSet();
                for (Field field : fields = contextClass.getDeclaredFields()) {
                    if (!Attribute.class.isAssignableFrom(field.getType())) continue;
                    Type fieldType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    contextAttributes.add(field.getName());
                    Type existingType = ATTRIBUTES_TO_TYPE.get(field.getName());
                    if (existingType != null && !existingType.equals(fieldType)) {
                        throw new ValidationException("The attribute " + field.getName() + " is defined with two different types in two different context classes: " + fieldType + " and " + existingType + "\n" + "Attributes with the same name are required to have the same type accross all Context classes.");
                    }
                    ATTRIBUTES_TO_TYPE.put(field.getName(), fieldType);
                }
                CONTEXT_CLASS_TO_ATTRIBUTES.put(contextClass, contextAttributes);
            }
            for (Class<? extends Context> contextClass : contextClasses) {
                HashMap simpleAttributeNameToAttribute = Maps.newHashMap();
                CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.put(contextClass, simpleAttributeNameToAttribute);
                Set attributes = Attribute.AttributeMap.AttributeInitializer.getAttributes(contextClass);
                LOG.debug("context class {} and attributes {}", contextClass, (Object)attributes);
                for (Attribute attribute : attributes) {
                    simpleAttributeNameToAttribute.put(AttributeParseUtils.getSimpleName(attribute), attribute);
                }
            }
        }

        private ContextUtils() {
        }

        @VisibleForTesting
        protected static void addAttribute(Class<? extends Context> contextClass, Attribute<?> attribute) {
            HashSet attributeNames = CONTEXT_CLASS_TO_ATTRIBUTES.get(contextClass);
            if (attributeNames == null) {
                attributeNames = Sets.newHashSet();
                CONTEXT_CLASS_TO_ATTRIBUTES.put(contextClass, attributeNames);
            }
            attributeNames.add(attribute.getSimpleName());
            CONTEXT_CLASSES.add(contextClass);
            HashMap attributeMap = CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.get(contextClass);
            if (attributeMap == null) {
                attributeMap = Maps.newHashMap();
                CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.put(contextClass, attributeMap);
            }
            attributeMap.put(attribute.getSimpleName(), attribute);
        }

        @VisibleForTesting
        protected static void removeAttribute(Class<? extends Context> contextClass, Attribute<?> attribute) {
            Map<String, Attribute<?>> attributeMap;
            Set<String> attributeNames = CONTEXT_CLASS_TO_ATTRIBUTES.get(contextClass);
            if (attributeNames != null) {
                attributeNames.remove(attribute.getSimpleName());
                if (attributeNames.isEmpty()) {
                    CONTEXT_CLASS_TO_ATTRIBUTES.remove(contextClass);
                }
            }
            if (!CONTEXT_CLASS_TO_ATTRIBUTES.keySet().contains(contextClass)) {
                CONTEXT_CLASSES.remove(contextClass);
            }
            if ((attributeMap = CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.get(contextClass)) != null) {
                attributeMap.remove(attribute.getSimpleName());
                if (attributeMap.isEmpty()) {
                    CONTEXT_TO_ATTRIBUTE_NAME_TO_ATTRIBUTE.remove(contextClass);
                }
            }
        }

        static {
            ContextUtils.initialize();
        }
    }

    protected static enum ConfElement {
        STRAM(null, null, null, null),
        APPLICATION(StramElement.APPLICATION, STRAM, null, Context.DAGContext.class),
        TEMPLATE(StramElement.TEMPLATE, STRAM, null, null),
        GATEWAY(StramElement.GATEWAY, APPLICATION, null, null),
        OPERATOR(StramElement.OPERATOR, APPLICATION, null, Context.OperatorContext.class),
        STREAM(StramElement.STREAM, APPLICATION, null, null),
        PORT(StramElement.PORT, OPERATOR, EnumSet.of(StramElement.INPUT_PORT, StramElement.OUTPUT_PORT), Context.PortContext.class),
        UNIFIER(StramElement.UNIFIER, PORT, null, null);

        protected static final Map<StramElement, ConfElement> STRAM_ELEMENT_TO_CONF_ELEMENT;
        protected static final Map<Class<? extends Context>, ConfElement> CONTEXT_TO_CONF_ELEMENT;
        private final StramElement element;
        private final ConfElement parent;
        private Set<ConfElement> children = Sets.newHashSet();
        private final Set<StramElement> allRelatedElements = Sets.newHashSet();
        private final Class<? extends Context> contextClass;
        private Set<String> ambiguousAttributes = Sets.newHashSet();
        private Set<String> contextAttributes = Sets.newHashSet();
        private Set<String> allChildAttributes = Sets.newHashSet();

        protected static void initialize() {
            STRAM.setChildren(Sets.newHashSet((Object[])new ConfElement[]{APPLICATION, TEMPLATE}));
            APPLICATION.setChildren(Sets.newHashSet((Object[])new ConfElement[]{GATEWAY, OPERATOR, STREAM}));
            OPERATOR.setChildren(Sets.newHashSet((Object[])new ConfElement[]{PORT}));
            PORT.setChildren(Sets.newHashSet((Object[])new ConfElement[]{UNIFIER}));
            STRAM_ELEMENT_TO_CONF_ELEMENT.clear();
            for (ConfElement confElement : ConfElement.values()) {
                STRAM_ELEMENT_TO_CONF_ELEMENT.put(confElement.getStramElement(), confElement);
                for (StramElement sElement : confElement.getAllRelatedElements()) {
                    STRAM_ELEMENT_TO_CONF_ELEMENT.put(sElement, confElement);
                }
            }
            for (ConfElement confElement : ConfElement.values()) {
                if (confElement.getParent() == null) continue;
                ConfElement.setAmbiguousAttributes(confElement);
            }
            CONTEXT_TO_CONF_ELEMENT.clear();
            for (ConfElement confElement : ConfElement.values()) {
                CONTEXT_TO_CONF_ELEMENT.put(confElement.getContextClass(), confElement);
            }
            HashSet confElementContextClasses = Sets.newHashSet();
            for (ConfElement confElement : ConfElement.values()) {
                if (confElement.getContextClass() == null) continue;
                confElementContextClasses.add(confElement.getContextClass());
            }
            if (!ContextUtils.CONTEXT_CLASSES.equals(confElementContextClasses)) {
                throw new IllegalStateException("All the context classes " + ContextUtils.CONTEXT_CLASSES + " found in " + Context.class + " are not used by ConfElements " + confElementContextClasses);
            }
        }

        public static Set<String> setAmbiguousAttributes(ConfElement element) {
            HashSet ambiguousAttributes = Sets.newHashSet();
            HashSet allChildAttributes = Sets.newHashSet(element.getContextAttributes());
            for (ConfElement childElement : element.getChildren()) {
                Set<String> allAttributes = ConfElement.setAmbiguousAttributes(childElement);
                ambiguousAttributes.addAll(childElement.getAmbiguousAttributes());
                HashSet intersection = Sets.newHashSet((Iterable)CollectionUtils.intersection((Collection)allChildAttributes, allAttributes));
                ambiguousAttributes.addAll(intersection);
                allChildAttributes.addAll(allAttributes);
            }
            element.setAmbiguousAttributes(ambiguousAttributes);
            element.setAllChildAttributes(allChildAttributes);
            return allChildAttributes;
        }

        private ConfElement(StramElement element, ConfElement parent, Set<StramElement> additionalRelatedElements, Class<? extends Context> contextClass) {
            this.element = element;
            this.parent = parent;
            if (additionalRelatedElements != null) {
                this.allRelatedElements.addAll(additionalRelatedElements);
            }
            this.allRelatedElements.add(element);
            this.contextClass = contextClass;
            this.contextAttributes = contextClass != null ? ContextUtils.CONTEXT_CLASS_TO_ATTRIBUTES.get(contextClass) : new HashSet();
        }

        private void setAllChildAttributes(Set<String> allChildAttributes) {
            this.allChildAttributes = (Set)Preconditions.checkNotNull(allChildAttributes);
        }

        public Set<String> getAllChildAttributes() {
            return this.allChildAttributes;
        }

        private void setAmbiguousAttributes(Set<String> ambiguousAttributes) {
            this.ambiguousAttributes = (Set)Preconditions.checkNotNull(ambiguousAttributes);
        }

        public Set<String> getAmbiguousAttributes() {
            return this.ambiguousAttributes;
        }

        public Class<? extends Context> getContextClass() {
            return this.contextClass;
        }

        public StramElement getStramElement() {
            return this.element;
        }

        public Set<String> getContextAttributes() {
            return this.contextAttributes;
        }

        public ConfElement getParent() {
            return this.parent;
        }

        private void setChildren(Set<ConfElement> children) {
            this.children = (Set)Preconditions.checkNotNull(children);
        }

        public Set<ConfElement> getChildren() {
            return this.children;
        }

        public Set<StramElement> getAllRelatedElements() {
            return this.allRelatedElements;
        }

        public static StramElement getAllowedParentConf(StramElement conf) {
            ConfElement confElement = STRAM_ELEMENT_TO_CONF_ELEMENT.get((Object)conf);
            if (confElement == null) {
                throw new IllegalArgumentException((Object)((Object)conf) + " is not a valid conf element.");
            }
            return confElement.getParent().getStramElement();
        }

        public static List<StramElement> getPathFromChildToRootInclusive(StramElement conf) {
            ConfElement confElement = STRAM_ELEMENT_TO_CONF_ELEMENT.get((Object)conf);
            if (confElement == null) {
                throw new IllegalArgumentException((Object)((Object)conf) + " does not represent a valid configuration type.");
            }
            ArrayList path = Lists.newArrayList();
            while (confElement != null) {
                path.add(confElement.getStramElement());
                confElement = confElement.getParent();
            }
            return path;
        }

        public static List<StramElement> getPathFromRootToChildInclusive(StramElement conf) {
            List<StramElement> path = ConfElement.getPathFromChildToRootInclusive(conf);
            return Lists.reverse(path);
        }

        public static List<StramElement> getPathFromChildToParentInclusive(StramElement child, StramElement parent) {
            ConfElement confElement = STRAM_ELEMENT_TO_CONF_ELEMENT.get((Object)child);
            if (confElement == null) {
                throw new IllegalArgumentException((Object)((Object)child) + " does not represent a valid configuration type.");
            }
            ArrayList path = Lists.newArrayList();
            if (child == parent) {
                path.add(child);
                return path;
            }
            while (confElement != null) {
                path.add(confElement.getStramElement());
                if (confElement.getStramElement() == parent) break;
                confElement = confElement.getParent();
            }
            if (path.get(path.size() - 1) != parent) {
                throw new IllegalArgumentException((Object)((Object)parent) + " is not a valid parent of " + (Object)((Object)child));
            }
            return path;
        }

        public static List<StramElement> getPathFromParentToChildInclusive(StramElement child, StramElement parent) {
            List<StramElement> path = ConfElement.getPathFromChildToParentInclusive(child, parent);
            return Lists.reverse(path);
        }

        public static ConfElement findConfElementWithAttribute(ConfElement current, String simpleAttributeName) {
            if (current.getContextAttributes().contains(simpleAttributeName)) {
                return current;
            }
            for (ConfElement childConfElement : current.getChildren()) {
                ConfElement result = ConfElement.findConfElementWithAttribute(childConfElement, simpleAttributeName);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        protected static Conf addConfs(Conf parentConf, ConfElement childConfElement) {
            List<StramElement> path = ConfElement.getPathFromParentToChildInclusive(childConfElement.getStramElement(), parentConf.getConfElement().getStramElement());
            for (int pathIndex = 1; pathIndex < path.size(); ++pathIndex) {
                LOG.debug("Adding conf");
                StramElement pathElement = path.get(pathIndex);
                parentConf = LogicalPlanConfiguration.addConf(pathElement, LogicalPlanConfiguration.WILDCARD, parentConf);
            }
            return parentConf;
        }

        static {
            STRAM_ELEMENT_TO_CONF_ELEMENT = Maps.newHashMap();
            CONTEXT_TO_CONF_ELEMENT = Maps.newHashMap();
            ConfElement.initialize();
        }
    }

    protected static enum StramElement {
        APPLICATION("application"),
        GATEWAY("gateway"),
        TEMPLATE("template"),
        OPERATOR("operator"),
        STREAM("stream"),
        PORT("port"),
        INPUT_PORT("inputport"),
        OUTPUT_PORT("outputport"),
        ATTR("attr"),
        PROP("prop"),
        CLASS("class"),
        PATH("path"),
        UNIFIER("unifier");

        private final String value;

        private StramElement(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static StramElement fromValue(String value) {
            StramElement velement = null;
            for (StramElement element : StramElement.values()) {
                if (!element.getValue().equals(value)) continue;
                velement = element;
                break;
            }
            return velement;
        }
    }
}

