/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.physical;

import com.datatorrent.api.Stats;
import com.datatorrent.api.StatsListener;
import com.datatorrent.stram.api.StreamingContainerUmbilicalProtocol;
import com.datatorrent.stram.engine.OperatorContext;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.physical.StatsRevisions;
import com.datatorrent.stram.util.MovingAverage;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OperatorStatus
implements StatsListener.BatchedOperatorStats,
Serializable {
    private static final long serialVersionUID = 201312231552L;
    private final int operatorId;
    public final StatsRevisions statsRevs = new StatsRevisions();
    public StreamingContainerUmbilicalProtocol.OperatorHeartbeat lastHeartbeat;
    public final StatsRevisions.VersionedLong totalTuplesProcessed = this.statsRevs.newVersionedLong();
    public final StatsRevisions.VersionedLong totalTuplesEmitted = this.statsRevs.newVersionedLong();
    public final StatsRevisions.VersionedLong currentWindowId = this.statsRevs.newVersionedLong();
    public final StatsRevisions.VersionedLong tuplesProcessedPSMA = this.statsRevs.newVersionedLong();
    public final StatsRevisions.VersionedLong tuplesEmittedPSMA = this.statsRevs.newVersionedLong();
    public String recordingId;
    public Stats.CheckpointStats checkpointStats;
    public final MovingAverage.MovingAverageLong checkpointTimeMA;
    public final MovingAverage.TimedMovingAverageLong cpuNanosPMSMA;
    public final MovingAverage.MovingAverageLong latencyMA;
    public final Map<String, PortStatus> inputPortStatusList = new ConcurrentHashMap<String, PortStatus>();
    public final Map<String, PortStatus> outputPortStatusList = new ConcurrentHashMap<String, PortStatus>();
    public List<Stats.OperatorStats> lastWindowedStats = Collections.emptyList();
    public final ConcurrentLinkedQueue<List<Stats.OperatorStats>> listenerStats = new ConcurrentLinkedQueue();
    public volatile long lastWindowIdChangeTms = 0L;
    public final int windowProcessingTimeoutMillis;
    public final ConcurrentLinkedQueue<StatsListener.OperatorResponse> responses = new ConcurrentLinkedQueue();
    public List<StatsListener.OperatorResponse> operatorResponses;
    private final LogicalPlan.OperatorMeta operatorMeta;
    private final int throughputCalculationInterval;
    private final int throughputCalculationMaxSamples;

    public OperatorStatus(int operatorId, LogicalPlan.OperatorMeta om) {
        this.operatorId = operatorId;
        this.operatorMeta = om;
        LogicalPlan dag = om.getDAG();
        this.throughputCalculationInterval = (Integer)dag.getValue(LogicalPlan.THROUGHPUT_CALCULATION_INTERVAL);
        this.throughputCalculationMaxSamples = (Integer)dag.getValue(LogicalPlan.THROUGHPUT_CALCULATION_MAX_SAMPLES);
        int heartbeatInterval = (Integer)dag.getValue(LogicalPlan.HEARTBEAT_INTERVAL_MILLIS);
        this.cpuNanosPMSMA = new MovingAverage.TimedMovingAverageLong(this.throughputCalculationMaxSamples, this.throughputCalculationInterval);
        this.latencyMA = new MovingAverage.MovingAverageLong(this.throughputCalculationInterval / heartbeatInterval);
        this.checkpointTimeMA = new MovingAverage.MovingAverageLong(this.throughputCalculationInterval / heartbeatInterval);
        this.windowProcessingTimeoutMillis = (Integer)dag.getValue(LogicalPlan.STREAMING_WINDOW_SIZE_MILLIS) * (Integer)om.getValue(OperatorContext.TIMEOUT_WINDOW_COUNT);
    }

    public boolean isIdle() {
        return this.lastHeartbeat != null && StreamingContainerUmbilicalProtocol.OperatorHeartbeat.DeployState.SHUTDOWN == this.lastHeartbeat.getState();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public List<Stats.OperatorStats> getLastWindowedStats() {
        return this.lastWindowedStats;
    }

    public long getCurrentWindowId() {
        return this.currentWindowId.get();
    }

    public long getTuplesProcessedPSMA() {
        return this.tuplesProcessedPSMA.get();
    }

    public long getTuplesEmittedPSMA() {
        return this.tuplesEmittedPSMA.get();
    }

    public double getCpuPercentageMA() {
        return this.cpuNanosPMSMA.getAvg();
    }

    public long getLatencyMA() {
        return this.latencyMA.getAvg();
    }

    public List<StatsListener.OperatorResponse> getOperatorResponse() {
        return this.operatorResponses;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 201312231635L;
        final int operatorId;
        final LogicalPlan.OperatorMeta operatorMeta;

        private SerializationProxy(OperatorStatus s) {
            this.operatorId = s.operatorId;
            this.operatorMeta = s.operatorMeta;
        }

        private Object readResolve() throws ObjectStreamException {
            OperatorStatus s = new OperatorStatus(this.operatorId, this.operatorMeta);
            return s;
        }
    }

    public class PortStatus {
        public String portName;
        public long totalTuples;
        public String recordingId;
        public final MovingAverage.TimedMovingAverageLong tuplesPMSMA;
        public final MovingAverage.TimedMovingAverageLong bufferServerBytesPMSMA;
        public final MovingAverage.MovingAverageLong queueSizeMA;

        public PortStatus() {
            this.tuplesPMSMA = new MovingAverage.TimedMovingAverageLong(OperatorStatus.this.throughputCalculationMaxSamples, OperatorStatus.this.throughputCalculationInterval);
            this.bufferServerBytesPMSMA = new MovingAverage.TimedMovingAverageLong(OperatorStatus.this.throughputCalculationMaxSamples, OperatorStatus.this.throughputCalculationInterval);
            this.queueSizeMA = new MovingAverage.MovingAverageLong(10);
        }
    }
}

