/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.physical;

import com.datatorrent.stram.Journal;
import com.datatorrent.stram.plan.physical.PTOperator;
import com.datatorrent.stram.plan.physical.PhysicalPlan;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PTContainer
implements Serializable {
    private static final long serialVersionUID = 201312112033L;
    public static final Journal.Recoverable SET_CONTAINER_STATE = new SetContainerState();
    private volatile State state = State.NEW;
    private int requiredMemoryMB;
    private int allocatedMemoryMB;
    private int resourceRequestPriority;
    private int requiredVCores;
    private int allocatedVCores;
    private final PhysicalPlan plan;
    private final int seq;
    List<PTOperator> operators = new ArrayList<PTOperator>();
    private String containerId;
    public String host;
    public InetSocketAddress bufferServerAddress;
    public String nodeHttpAddress;
    int restartAttempts;
    private long startedTime = -1L;
    private long finishedTime = -1L;
    private byte[] bufferServerToken;

    PTContainer(PhysicalPlan plan) {
        this.plan = plan;
        this.seq = plan.containerSeq.incrementAndGet();
    }

    public Journal.Recoverable getSetContainerState() {
        return new SetContainerState(this);
    }

    public PhysicalPlan getPlan() {
        return this.plan;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int getRequiredMemoryMB() {
        return this.requiredMemoryMB;
    }

    public void setRequiredMemoryMB(int requiredMemoryMB) {
        this.requiredMemoryMB = requiredMemoryMB;
    }

    public int getAllocatedMemoryMB() {
        return this.allocatedMemoryMB;
    }

    public int getRequiredVCores() {
        return this.requiredVCores;
    }

    public void setRequiredVCores(int requiredVCores) {
        this.requiredVCores = requiredVCores;
    }

    public int getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public void setAllocatedVCores(int allocatedVCores) {
        this.allocatedVCores = allocatedVCores;
    }

    public void setAllocatedMemoryMB(int allocatedMemoryMB) {
        this.allocatedMemoryMB = allocatedMemoryMB;
    }

    public int getResourceRequestPriority() {
        return this.resourceRequestPriority;
    }

    public void setResourceRequestPriority(int resourceRequestPriority) {
        this.resourceRequestPriority = resourceRequestPriority;
    }

    public List<PTOperator> getOperators() {
        return this.operators;
    }

    public int getId() {
        return this.seq;
    }

    public String getExternalId() {
        return this.containerId;
    }

    public void setExternalId(String id) {
        this.containerId = id;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public void setStartedTime(long startedTime) {
        this.startedTime = startedTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public byte[] getBufferServerToken() {
        return this.bufferServerToken;
    }

    public void setBufferServerToken(byte[] bufferServerToken) {
        this.bufferServerToken = bufferServerToken;
    }

    public String toIdStateString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)("" + this.seq + "(" + this.containerId + ")")).append("state", (Object)this.getState()).toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)("" + this.seq + "(" + this.containerId + ")")).append("state", (Object)this.getState()).append("operators", this.operators).toString();
    }

    static /* synthetic */ byte[] access$802(PTContainer x0, byte[] x1) {
        x0.bufferServerToken = x1;
        return x1;
    }

    private static class SetContainerState
    implements Journal.Recoverable {
        private final PTContainer container;

        private SetContainerState() {
            this.container = null;
        }

        private SetContainerState(PTContainer container) {
            this.container = container;
        }

        @Override
        public void read(Object object, Input in) throws KryoException {
            PhysicalPlan plan = (PhysicalPlan)object;
            int containerId = in.readInt();
            for (PTContainer c : plan.getContainers()) {
                if (c.getId() != containerId) continue;
                int stateOrd = in.readInt();
                c.state = State.values()[stateOrd];
                c.containerId = in.readString();
                c.resourceRequestPriority = in.readInt();
                c.requiredMemoryMB = in.readInt();
                c.allocatedMemoryMB = in.readInt();
                c.requiredVCores = in.readInt();
                c.allocatedVCores = in.readInt();
                String bufferServerHost = in.readString();
                if (bufferServerHost != null) {
                    c.bufferServerAddress = InetSocketAddress.createUnresolved(bufferServerHost, in.readInt());
                }
                c.host = in.readString();
                c.nodeHttpAddress = in.readString();
                int tokenLength = in.readInt();
                if (tokenLength != -1) {
                    PTContainer.access$802(c, in.readBytes(tokenLength));
                    break;
                }
                PTContainer.access$802(c, null);
                break;
            }
        }

        @Override
        public void write(Output out) throws KryoException {
            out.writeInt(this.container.getId());
            out.writeInt(this.container.getState().ordinal());
            out.writeString(this.container.getExternalId());
            out.writeInt(this.container.getResourceRequestPriority());
            out.writeInt(this.container.getRequiredMemoryMB());
            out.writeInt(this.container.getAllocatedMemoryMB());
            out.writeInt(this.container.getRequiredVCores());
            out.writeInt(this.container.getAllocatedVCores());
            InetSocketAddress addr = this.container.bufferServerAddress;
            if (addr != null) {
                out.writeString(addr.getHostName());
                out.writeInt(addr.getPort());
            } else {
                out.writeString(null);
            }
            out.writeString(this.container.host);
            out.writeString(this.container.nodeHttpAddress);
            out.writeInt(this.container.bufferServerToken == null ? -1 : this.container.bufferServerToken.length);
            if (this.container.bufferServerToken != null) {
                out.write(this.container.bufferServerToken);
            }
        }
    }

    public static enum State {
        NEW,
        ALLOCATED,
        ACTIVE,
        KILLED;

    }
}

