/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.physical;

import java.io.Serializable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsRevisions
implements Serializable {
    private final IdentityHashMap<Object, Integer> longsIndex = new IdentityHashMap();
    private transient ThreadLocal<Revision> VERSION = new ThreadLocal();
    private Revision current = new Revision();
    private static final Logger LOG = LoggerFactory.getLogger(StatsRevisions.class);
    private static final long serialVersionUID = 201401131642L;

    public VersionedLong newVersionedLong() {
        VersionedLong vl = new VersionedLong(this.longsIndex.size());
        this.longsIndex.put(vl, vl.index);
        return vl;
    }

    public void checkout() {
        Revision v = new Revision(this.current);
        this.VERSION.set(v);
    }

    public void commit() {
        Revision v;
        this.current = v = this.VERSION.get();
        this.VERSION.remove();
    }

    public class VersionedLong
    implements Serializable {
        private static final long serialVersionUID = 201401131642L;
        private final int index;

        private VersionedLong(int index) {
            this.index = index;
        }

        public long get() {
            Revision v = (Revision)StatsRevisions.this.VERSION.get();
            if (v == null) {
                v = StatsRevisions.this.current;
            }
            if (this.index < v.longs.length) {
                return v.longs[this.index];
            }
            return 0L;
        }

        public void set(long val) {
            Revision v = (Revision)StatsRevisions.this.VERSION.get();
            if (v == null || v == StatsRevisions.this.current) {
                throw new AssertionError((Object)"Cannot modify readonly state.");
            }
            if (this.index >= v.longs.length) {
                long[] newArray = new long[this.index + 10];
                System.arraycopy(v.longs, 0, newArray, 0, v.longs.length);
                v.longs = newArray;
            }
            v.longs[this.index] = val;
        }

        public void add(long val) {
            this.set(this.get() + val);
        }

        public String toString() {
            return Long.toString(this.get());
        }
    }

    private class Revision
    implements Serializable {
        private static final long serialVersionUID = 201401131642L;
        Object[] refs;
        long[] longs;
        double[] doubles;

        private Revision() {
            this.refs = new Object[0];
            this.longs = new long[0];
            this.doubles = new double[0];
        }

        private Revision(Revision other) {
            this.refs = Arrays.copyOf(other.refs, other.refs.length);
            this.longs = Arrays.copyOf(other.longs, other.longs.length);
            this.doubles = Arrays.copyOf(other.doubles, other.doubles.length);
        }
    }
}

