/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.security;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosAuth {
    public static Subject loginUser(String principal, char[] password) throws LoginException, IOException {
        Subject subject = new Subject();
        LoginContext lc = new LoginContext(KerberosAuth.class.getName(), subject, new AuthenticationHandler(principal, password), new KerberosConfiguration(principal));
        lc.login();
        return subject;
    }

    private static class KerberosConfiguration
    extends Configuration {
        private final String principal;

        KerberosConfiguration(String principal) {
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            if (name.equals(KerberosAuth.class.getName())) {
                AppConfigurationEntry[] configEntries = new AppConfigurationEntry[1];
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("useTicketCache", "true");
                params.put("principal", this.principal);
                configEntries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, params);
                return configEntries;
            }
            return null;
        }
    }

    private static class AuthenticationHandler
    implements CallbackHandler {
        private final String principal;
        private final char[] password;

        AuthenticationHandler(String principal, char[] password) {
            this.principal = principal;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.principal);
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password);
            }
        }
    }
}

