/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.stream;

import com.datatorrent.api.Sink;
import com.datatorrent.stram.engine.Stream;
import com.datatorrent.stram.engine.StreamContext;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuxStream
implements Stream.MultiSinkCapableStream {
    public static final String MULTI_SINK_ID_CONCAT_SEPARATOR = ", ";
    private HashMap<String, Sink<Object>> outputs = new HashMap();
    private volatile Sink<Object>[] sinks = NO_SINKS;
    private int count;
    private static final Logger logger = LoggerFactory.getLogger(MuxStream.class);

    public void setup(StreamContext context) {
    }

    public void teardown() {
        this.outputs.clear();
    }

    public void activate(StreamContext context) {
        Sink[] newSinks = (Sink[])Array.newInstance(Sink.class, this.outputs.size());
        int i = 0;
        for (Sink<Object> s : this.outputs.values()) {
            newSinks[i++] = s;
        }
        this.sinks = newSinks;
    }

    public void deactivate() {
        this.sinks = NO_SINKS;
    }

    @Override
    public void setSink(String id, Sink<Object> sink) {
        if (sink == null) {
            this.outputs.remove(id);
            if (this.outputs.isEmpty()) {
                this.sinks = NO_SINKS;
            }
        } else {
            this.outputs.put(id, sink);
            if (this.sinks != NO_SINKS) {
                this.activate((StreamContext)null);
            }
        }
    }

    public void put(Object payload) {
        ++this.count;
        int i = this.sinks.length;
        while (i-- > 0) {
            this.sinks[i].put(payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(boolean reset) {
        try {
            int n = this.count;
            return n;
        }
        finally {
            if (reset) {
                this.count = 0;
            }
        }
    }
}

