/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.Serializable;

public class MovingAverage {

    public static class TimedMovingAverageLong
    implements Serializable {
        private static final long serialVersionUID = 201404291550L;
        private final int periods;
        private final long[] values;
        private final long[] timeIntervals;
        private int index = 0;
        private final long baseTimeInterval;

        public TimedMovingAverageLong(int samples, long baseTimeInterval) {
            this.periods = samples;
            this.values = new long[samples];
            this.timeIntervals = new long[samples];
            this.baseTimeInterval = baseTimeInterval;
        }

        public synchronized void add(long val, long time) {
            this.values[this.index] = val;
            this.timeIntervals[this.index] = time;
            ++this.index;
            this.index %= this.periods;
        }

        public synchronized double getAvg() {
            long sumValues = 0L;
            long sumTimeIntervals = 0L;
            int i = this.index;
            do {
                if (--i < 0) {
                    i = this.periods - 1;
                }
                if (i == this.index) break;
                sumValues += this.values[i];
            } while ((sumTimeIntervals += this.timeIntervals[i]) < this.baseTimeInterval);
            if (sumTimeIntervals == 0L) {
                return 0.0;
            }
            return (double)sumValues / (double)sumTimeIntervals;
        }
    }

    public static class MovingAverageDouble
    implements Serializable {
        private static final long serialVersionUID = 201404291550L;
        private final int periods;
        private final double[] values;
        private int index = 0;
        private boolean filled = false;

        public MovingAverageDouble(int periods) {
            this.periods = periods;
            this.values = new double[periods];
        }

        public synchronized void add(double val) {
            this.values[this.index++] = val;
            if (this.index == this.periods) {
                this.filled = true;
            }
            this.index %= this.periods;
        }

        public synchronized double getAvg() {
            double sum = 0.0;
            for (int i = 0; i < this.periods; ++i) {
                sum += this.values[i];
            }
            if (!this.filled) {
                return this.index == 0 ? 0.0 : sum / (double)this.index;
            }
            return sum / (double)this.periods;
        }
    }

    public static class MovingAverageLong
    implements Serializable {
        private static final long serialVersionUID = 201404291550L;
        private final int periods;
        private final long[] values;
        private int index = 0;
        private boolean filled = false;

        public MovingAverageLong(int periods) {
            this.periods = periods;
            this.values = new long[periods];
        }

        public synchronized void add(long val) {
            this.values[this.index++] = val;
            if (this.index == this.periods) {
                this.filled = true;
            }
            this.index %= this.periods;
        }

        public synchronized long getAvg() {
            long sum = 0L;
            for (int i = 0; i < this.periods; ++i) {
                sum += this.values[i];
            }
            if (!this.filled) {
                return this.index == 0 ? 0L : sum / (long)this.index;
            }
            return sum / (long)this.periods;
        }
    }
}

