/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

public class ObjectMapperFactory {
    public static ObjectMapper getOperatorValueSerializer() {
        ObjectMapper returnVal = new ObjectMapper();
        returnVal.setVisibilityChecker((VisibilityChecker)new VC());
        returnVal.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        returnVal.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
        returnVal.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        return returnVal;
    }

    public static ObjectMapper getOperatorValueDeserializer() {
        ObjectMapper returnVal = new ObjectMapper();
        returnVal.setVisibilityChecker((VisibilityChecker)new VC());
        returnVal.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        returnVal.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
        return returnVal;
    }

    public static class VC
    implements VisibilityChecker<VC> {
        public VC with(JsonAutoDetect ann) {
            return this;
        }

        public VC with(JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withVisibility(JsonMethod method, JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withGetterVisibility(JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withIsGetterVisibility(JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withSetterVisibility(JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withCreatorVisibility(JsonAutoDetect.Visibility v) {
            return this;
        }

        public VC withFieldVisibility(JsonAutoDetect.Visibility v) {
            return this;
        }

        public boolean isGetterVisible(Method m) {
            if (m == null || !Modifier.isPublic(m.getModifiers())) {
                return false;
            }
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(m.getDeclaringClass()).getPropertyDescriptors()) {
                    if (pd.getReadMethod() == null || !pd.getReadMethod().equals(m)) continue;
                    Method setter = pd.getWriteMethod();
                    return setter != null && Modifier.isPublic(setter.getModifiers());
                }
            }
            catch (IntrospectionException e) {
                return false;
            }
            return false;
        }

        public boolean isGetterVisible(AnnotatedMethod m) {
            return this.isGetterVisible(m.getAnnotated());
        }

        public boolean isIsGetterVisible(Method m) {
            return this.isGetterVisible(m);
        }

        public boolean isIsGetterVisible(AnnotatedMethod m) {
            return this.isIsGetterVisible(m.getAnnotated());
        }

        public boolean isSetterVisible(Method m) {
            if (m == null || !Modifier.isPublic(m.getModifiers())) {
                return false;
            }
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(m.getDeclaringClass()).getPropertyDescriptors()) {
                    if (pd.getWriteMethod() == null || !pd.getWriteMethod().equals(m)) continue;
                    Method getter = pd.getReadMethod();
                    return getter != null && Modifier.isPublic(getter.getModifiers());
                }
            }
            catch (IntrospectionException e) {
                return false;
            }
            return false;
        }

        public boolean isSetterVisible(AnnotatedMethod m) {
            return this.isSetterVisible(m.getAnnotated());
        }

        public boolean isCreatorVisible(Member m) {
            return false;
        }

        public boolean isCreatorVisible(AnnotatedMember m) {
            return false;
        }

        public boolean isFieldVisible(Field f) {
            return false;
        }

        public boolean isFieldVisible(AnnotatedField f) {
            return false;
        }
    }
}

