/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.datatorrent.stram.util.StableWrapper;
import com.datatorrent.stram.util.StableWrapperNaturalComparator;
import com.datatorrent.stram.util.StableWrapperProvidedComparator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.SortedSet;

public class StablePriorityQueue<E>
implements Queue<E> {
    private final PriorityQueue<StableWrapper<E>> queue;
    private int counter = 0;

    public StablePriorityQueue(int initialCapacity) {
        this.queue = new PriorityQueue(initialCapacity, new StableWrapperNaturalComparator());
    }

    public StablePriorityQueue(Collection<? extends E> c) {
        this.queue = new PriorityQueue(c.size(), new StableWrapperNaturalComparator());
        for (E e : c) {
            this.queue.add(new StableWrapper<E>(e, this.counter++));
        }
    }

    public StablePriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        this.queue = new PriorityQueue<StableWrapper<E>>(initialCapacity, new StableWrapperProvidedComparator<E>(comparator));
    }

    public StablePriorityQueue(StablePriorityQueue<? extends E> c) {
        this.queue = new PriorityQueue<StableWrapper<E>>(c.size(), c.comparator());
    }

    public StablePriorityQueue(SortedSet<? extends E> c) {
        this((Collection<? extends E>)c);
    }

    @Override
    public E element() throws NoSuchElementException {
        try {
            return ((StableWrapper)this.queue.element()).object;
        }
        catch (NoSuchElementException nsee) {
            this.counter = 0;
            throw nsee;
        }
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offer(new StableWrapper<E>(e, this.counter++));
    }

    @Override
    public E peek() {
        StableWrapper<E> sw = this.queue.peek();
        if (sw == null) {
            return null;
        }
        return sw.object;
    }

    @Override
    public E remove() throws NoSuchElementException {
        try {
            return ((StableWrapper)this.queue.remove()).object;
        }
        catch (NoSuchElementException nsee) {
            this.counter = 0;
            throw nsee;
        }
    }

    @Override
    public E poll() {
        StableWrapper<E> sw = this.queue.poll();
        if (sw == null) {
            return null;
        }
        return sw.object;
    }

    public Comparator<? super E> comparator() {
        Comparator<StableWrapper<E>> comparator = this.queue.comparator();
        if (comparator instanceof StableWrapperProvidedComparator) {
            return ((StableWrapperProvidedComparator)comparator).comparator;
        }
        return null;
    }

    @Override
    public boolean add(E e) {
        return this.queue.add(new StableWrapper<E>(e, this.counter++));
    }

    @Override
    public int size() {
        int size = this.queue.size();
        if (size == 0) {
            this.counter = 0;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = this.queue.isEmpty();
        if (isEmpty) {
            this.counter = 0;
        }
        return isEmpty;
    }

    @Override
    public boolean contains(Object o) {
        for (StableWrapper<E> e : this.queue) {
            if (e.object != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorWrapper();
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.queue.toArray();
        int i = array.length;
        while (i-- > 0) {
            array[i] = ((StableWrapper)array[i]).object;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.queue.toArray(a);
        int length = this.queue.size();
        Object[] finalArray = a.length < length ? (Object[])Array.newInstance(a.getClass().getComponentType(), length) : a;
        Iterator<StableWrapper<E>> iterator = this.queue.iterator();
        for (int i = 0; i < length; ++i) {
            if (iterator.hasNext()) {
                finalArray[i] = iterator.next().object;
                continue;
            }
            if (finalArray != a) {
                finalArray = Arrays.copyOf(finalArray, i);
                continue;
            }
            finalArray[i] = null;
        }
        return finalArray;
    }

    @Override
    public boolean remove(Object o) {
        for (StableWrapper<E> e : this.queue) {
            if (e.object != o) continue;
            if (this.size() == 1) {
                this.counter = 0;
            }
            return this.queue.remove(e);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return this.queue.addAll(null);
        }
        if (c == this) {
            return this.queue.addAll(this.queue);
        }
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        if (c == this) {
            if (this.size() > 0) {
                this.clear();
                modified = true;
            } else {
                modified = false;
            }
            this.counter = 0;
        } else if (c != null) {
            for (Object o : c) {
                if (!this.remove(o)) continue;
                modified = true;
            }
            if (modified && this.isEmpty()) {
                this.counter = 0;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<StableWrapper<E>> removeThese = new ArrayList<StableWrapper<E>>();
        for (StableWrapper<E> swe : this.queue) {
            if (c.contains(swe.object)) continue;
            removeThese.add(swe);
        }
        if (removeThese.isEmpty()) {
            return false;
        }
        if (this.queue.size() == removeThese.size()) {
            this.counter = 0;
        }
        return this.queue.removeAll(removeThese);
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.counter = 0;
    }

    private final class IteratorWrapper
    implements Iterator<E> {
        final Iterator<StableWrapper<E>> iterator;

        public IteratorWrapper() {
            this.iterator = StablePriorityQueue.this.queue.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next().object;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

