/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.datatorrent.stram.util.SecureExecutor;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.Future;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServicesClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebServicesClient.class);
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static final CredentialsProvider credentialsProvider;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private final Client client;

    public WebServicesClient() {
        this((ClientConfig)new DefaultClientConfig());
        this.client.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        this.client.getProperties().put("com.sun.jersey.client.property.connectTimeout", 10000);
        this.client.getProperties().put("com.sun.jersey.client.property.readTimeout", 10000);
    }

    public WebServicesClient(ClientConfig config) {
        if (UserGroupInformation.isSecurityEnabled()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            Registry authProviders = RegistryBuilder.create().register("negotiate", (Object)new SPNegoSchemeFactory(true)).build();
            httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)authProviders);
            ApacheHttpClient4Handler httpClientHandler = new ApacheHttpClient4Handler((HttpClient)httpClientBuilder.build(), (CookieStore)new BasicCookieStore(), false);
            this.client = new Client((ClientHandler)httpClientHandler, config);
        } else {
            this.client = Client.create((ClientConfig)config);
        }
    }

    public WebServicesClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public <T> T process(String url, Class<T> clazz, WebServicesHandler<T> handler) throws IOException {
        WebResource wr = this.client.resource(url);
        return this.process(wr.getRequestBuilder(), clazz, handler);
    }

    public <T> Future<T> process(String url, ITypeListener<T> listener, WebServicesAsyncHandler<T> handler) throws IOException {
        AsyncWebResource wr = this.client.asyncResource(url);
        return this.process(wr, listener, handler);
    }

    public <T> T process(final WebResource.Builder wr, final Class<T> clazz, final WebServicesHandler<T> handler) throws IOException {
        return SecureExecutor.execute(new SecureExecutor.WorkLoad<T>(){

            @Override
            public T run() {
                return handler.process(wr, clazz);
            }
        });
    }

    public <T> Future<T> process(final AsyncWebResource wr, final ITypeListener<T> listener, final WebServicesAsyncHandler<T> handler) throws IOException {
        return (Future)SecureExecutor.execute(new SecureExecutor.WorkLoad<Future<T>>(){

            @Override
            public Future<T> run() {
                return handler.process(wr, listener);
            }
        });
    }

    static {
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(5);
        credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
    }

    public static class DeleteWebServicesAsyncHandler<T>
    extends WebServicesAsyncHandler<T> {
        @Override
        public Future<T> process(AsyncWebResource webResource, ITypeListener<T> listener) {
            return webResource.delete(listener);
        }
    }

    public static class DeleteWebServicesHandler<T>
    extends WebServicesHandler<T> {
        @Override
        public T process(WebResource.Builder webResource, Class<T> clazz) {
            return (T)webResource.delete(clazz);
        }
    }

    public static class GetWebServicesAsyncHandler<T>
    extends WebServicesAsyncHandler<T> {
        @Override
        public Future<T> process(AsyncWebResource webResource, ITypeListener<T> listener) {
            return webResource.get(listener);
        }
    }

    public static class GetWebServicesHandler<T>
    extends WebServicesHandler<T> {
        @Override
        public T process(WebResource.Builder webResource, Class<T> clazz) {
            return (T)webResource.get(clazz);
        }
    }

    public static abstract class WebServicesAsyncHandler<T> {
        public abstract Future<T> process(AsyncWebResource var1, ITypeListener<T> var2);

        public String toString() {
            return "WebServicesAsyncHandler{Abstract class Useful in Future}";
        }
    }

    public static abstract class WebServicesHandler<T> {
        public abstract T process(WebResource.Builder var1, Class<T> var2);

        public String toString() {
            return "WebServicesHandler{Abstract class Useful in Future}";
        }
    }
}

