/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.netlet.util.DTThrowable;
import com.datatorrent.stram.util.ObjectMapperFactory;
import com.datatorrent.stram.webapp.TypeDiscoverer;
import com.datatorrent.stram.webapp.TypeGraph;
import com.datatorrent.stram.webapp.TypeGraphFactory;
import com.datatorrent.stram.webapp.asm.CompactAnnotationNode;
import com.datatorrent.stram.webapp.asm.CompactFieldNode;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OperatorDiscoverer {
    public static final String GENERATED_CLASSES_JAR = "_generated-classes.jar";
    private Set<String> operatorClassNames;
    private static final Logger LOG = LoggerFactory.getLogger(OperatorDiscoverer.class);
    private final List<String> pathsToScan = new ArrayList<String>();
    private final ClassLoader classLoader;
    private static final String DT_OPERATOR_DOCLINK_PREFIX = "https://www.datatorrent.com/docs/apidocs/index.html";
    public static final String PORT_TYPE_INFO_KEY = "portTypeInfo";
    private final TypeGraph typeGraph = TypeGraphFactory.createTypeGraphProtoType();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+?");
    private static final String SCHEMA_REQUIRED_KEY = "schemaRequired";
    private final Map<String, OperatorClassInfo> classInfo = new HashMap<String, OperatorClassInfo>();
    private static final Pattern CAPS = Pattern.compile("([A-Z\\d][^A-Z\\d]*)");

    public OperatorDiscoverer() {
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    public OperatorDiscoverer(String[] jars) {
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            this.pathsToScan.add(jars[i]);
            try {
                urls[i] = new URL("file://" + jars[i]);
                continue;
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    private void loadOperatorClass() {
        this.buildTypeGraph();
        this.operatorClassNames = this.typeGraph.getAllDTInstantiableOperators();
    }

    public void addDefaultValue(String className, JSONObject oper) throws Exception {
        ObjectMapper defaultValueMapper = ObjectMapperFactory.getOperatorValueSerializer();
        Class<?> clazz = this.classLoader.loadClass(className);
        if (clazz != null) {
            Operator operIns = (Operator)clazz.newInstance();
            String s = defaultValueMapper.writeValueAsString((Object)operIns);
            oper.put("defaultValue", new JSONObject(s).get(className));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTypeGraph() {
        HashMap<String, JarFile> openJarFiles = new HashMap<String, JarFile>();
        HashMap<String, File> openClassFiles = new HashMap<String, File>();
        HashSet<String> resourceCacheSet = new HashSet<String>();
        try {
            for (String string : this.pathsToScan) {
                File f = null;
                try {
                    f = new File(string);
                    if (!f.exists() || f.isDirectory() || !f.getName().endsWith("jar") && !f.getName().endsWith("class") || GENERATED_CLASSES_JAR.equals(f.getName())) continue;
                    if (f.getName().endsWith("class")) {
                        this.typeGraph.addNode(f);
                        openClassFiles.put(string, f);
                        continue;
                    }
                    JarFile jar = new JarFile(string);
                    openJarFiles.put(string, jar);
                    Enumeration<JarEntry> entriesEnum = jar.entries();
                    while (entriesEnum.hasMoreElements()) {
                        JarEntry jarEntry = entriesEnum.nextElement();
                        String entryName = jarEntry.getName();
                        if (jarEntry.isDirectory()) continue;
                        if (entryName.endsWith("-javadoc.xml")) {
                            try {
                                this.processJavadocXml(jar.getInputStream(jarEntry));
                            }
                            catch (Exception ex) {
                                LOG.warn("Cannot process javadoc {} : ", (Object)entryName, (Object)ex);
                            }
                            continue;
                        }
                        if (entryName.endsWith(".class")) {
                            TypeGraph.TypeGraphVertex newNode = this.typeGraph.addNode(jarEntry, jar);
                            Iterator iter = resourceCacheSet.iterator();
                            while (iter.hasNext()) {
                                String entry = (String)iter.next();
                                if (!entry.startsWith(entryName.substring(0, entryName.length() - 6))) continue;
                                newNode.setHasResource(true);
                                iter.remove();
                            }
                            continue;
                        }
                        String className = entryName;
                        boolean foundClass = false;
                        while (className.contains("/")) {
                            TypeGraph.TypeGraphVertex tgv = this.typeGraph.getNode((className = className.substring(0, className.lastIndexOf(47))).replace('/', '.'));
                            if (tgv == null) continue;
                            tgv.setHasResource(true);
                            foundClass = true;
                            break;
                        }
                        if (foundClass) continue;
                        resourceCacheSet.add(entryName);
                    }
                }
                catch (IOException ex) {
                    LOG.warn("Cannot process file {}", (Object)f, (Object)ex);
                }
            }
            this.typeGraph.trim();
        }
        catch (Throwable throwable) {
            for (Map.Entry entry : openJarFiles.entrySet()) {
                try {
                    ((JarFile)entry.getValue()).close();
                }
                catch (IOException e) {
                    DTThrowable.wrapIfChecked((Exception)e);
                }
            }
            throw throwable;
        }
        for (Map.Entry entry : openJarFiles.entrySet()) {
            try {
                ((JarFile)entry.getValue()).close();
            }
            catch (IOException e) {
                DTThrowable.wrapIfChecked((Exception)e);
            }
        }
    }

    private void processJavadocXml(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.newSAXParser().parse(is, (DefaultHandler)new JavadocSAXHandler());
    }

    public Set<String> getOperatorClasses(String parent, String searchTerm) throws ClassNotFoundException {
        if (CollectionUtils.isEmpty(this.operatorClassNames)) {
            this.loadOperatorClass();
        }
        if (parent == null) {
            parent = Operator.class.getName();
        } else if (!this.typeGraph.isAncestor(Operator.class.getName(), parent)) {
            throw new IllegalArgumentException("Argument must be a subclass of Operator class");
        }
        Set filteredClass = Sets.filter(this.operatorClassNames, (Predicate)new Predicate<String>(){

            public boolean apply(String className) {
                OperatorClassInfo oci = (OperatorClassInfo)OperatorDiscoverer.this.classInfo.get(className);
                return oci == null || !oci.tags.containsKey("@omitFromUI");
            }
        });
        if (searchTerm == null && parent.equals(Operator.class.getName())) {
            return filteredClass;
        }
        if (searchTerm != null) {
            searchTerm = searchTerm.toLowerCase();
        }
        HashSet<String> result = new HashSet<String>();
        block0: for (String clazz : filteredClass) {
            if (!parent.equals(Operator.class.getName()) && !this.typeGraph.isAncestor(parent, clazz)) continue;
            if (searchTerm == null) {
                result.add(clazz);
                continue;
            }
            if (clazz.toLowerCase().contains(searchTerm)) {
                result.add(clazz);
                continue;
            }
            OperatorClassInfo oci = this.classInfo.get(clazz);
            if (oci == null) continue;
            if (oci.comment != null && oci.comment.toLowerCase().contains(searchTerm)) {
                result.add(clazz);
                continue;
            }
            for (Map.Entry<String, String> entry : oci.tags.entrySet()) {
                if (!entry.getValue().toLowerCase().contains(searchTerm)) continue;
                result.add(clazz);
                continue block0;
            }
        }
        return result;
    }

    public Class<? extends Operator> getOperatorClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        if (CollectionUtils.isEmpty(this.operatorClassNames)) {
            this.loadOperatorClass();
        }
        if (!Operator.class.isAssignableFrom(clazz = this.classLoader.loadClass(className))) {
            throw new IllegalArgumentException("Argument must be a subclass of Operator class");
        }
        return clazz;
    }

    public JSONObject describeOperator(String clazz) throws Exception {
        TypeGraph.TypeGraphVertex tgv = this.typeGraph.getTypeGraphVertex(clazz);
        if (tgv.isInstantiable()) {
            JSONObject response = new JSONObject();
            JSONArray inputPorts = new JSONArray();
            JSONArray outputPorts = new JSONArray();
            JSONObject operatorDescriptor = this.describeClassByASM(clazz);
            JSONArray properties = operatorDescriptor.getJSONArray("properties");
            properties = this.enrichProperties(clazz, properties);
            JSONArray portTypeInfo = operatorDescriptor.getJSONArray(PORT_TYPE_INFO_KEY);
            List<CompactFieldNode> inputPortfields = this.typeGraph.getAllInputPorts(clazz);
            List<CompactFieldNode> outputPortfields = this.typeGraph.getAllOutputPorts(clazz);
            try {
                for (CompactFieldNode field : inputPortfields) {
                    JSONObject inputPort = this.setFieldAttributes(clazz, field);
                    if (!inputPort.has("optional")) {
                        inputPort.put("optional", false);
                    }
                    if (!inputPort.has(SCHEMA_REQUIRED_KEY)) {
                        inputPort.put(SCHEMA_REQUIRED_KEY, false);
                    }
                    inputPorts.put((Object)inputPort);
                }
                for (CompactFieldNode field : outputPortfields) {
                    JSONObject outputPort = this.setFieldAttributes(clazz, field);
                    if (!outputPort.has("optional")) {
                        outputPort.put("optional", true);
                    }
                    if (!outputPort.has("error")) {
                        outputPort.put("error", false);
                    }
                    if (!outputPort.has(SCHEMA_REQUIRED_KEY)) {
                        outputPort.put(SCHEMA_REQUIRED_KEY, false);
                    }
                    outputPorts.put((Object)outputPort);
                }
                response.put("name", (Object)clazz);
                response.put("properties", (Object)properties);
                response.put(PORT_TYPE_INFO_KEY, (Object)portTypeInfo);
                response.put("inputPorts", (Object)inputPorts);
                response.put("outputPorts", (Object)outputPorts);
                OperatorClassInfo oci = this.classInfo.get(clazz);
                if (oci != null) {
                    String doclink;
                    if (oci.comment != null) {
                        String keptPrefix = "<p>";
                        String[] descriptions = oci.comment.split("<p>", 2);
                        if (descriptions.length == 0) {
                            keptPrefix = "";
                            descriptions = oci.comment.split("\n\n", 2);
                        }
                        if (descriptions.length > 0) {
                            response.put("shortDesc", (Object)descriptions[0]);
                        }
                        if (descriptions.length > 1) {
                            response.put("longDesc", (Object)(keptPrefix + descriptions[1]));
                        }
                    }
                    response.put("category", (Object)oci.tags.get("@category"));
                    String displayName = oci.tags.get("@displayName");
                    if (displayName == null) {
                        displayName = OperatorDiscoverer.decamelizeClassName(ClassUtils.getShortClassName((String)clazz));
                    }
                    response.put("displayName", (Object)displayName);
                    String tags = oci.tags.get("@tags");
                    if (tags != null) {
                        JSONArray tagArray = new JSONArray();
                        for (String tag : StringUtils.split((String)tags, (char)',')) {
                            tagArray.put((Object)tag.trim().toLowerCase());
                        }
                        response.put("tags", (Object)tagArray);
                    }
                    if ((doclink = oci.tags.get("@doclink")) != null) {
                        response.put("doclink", (Object)(doclink + "?" + OperatorDiscoverer.getDocName(clazz)));
                    } else if (clazz.startsWith("com.datatorrent.lib.") || clazz.startsWith("com.datatorrent.contrib.")) {
                        response.put("doclink", (Object)("https://www.datatorrent.com/docs/apidocs/index.html?" + OperatorDiscoverer.getDocName(clazz)));
                    }
                }
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
            return response;
        }
        throw new UnsupportedOperationException();
    }

    private JSONObject setFieldAttributes(String clazz, CompactFieldNode field) throws JSONException {
        CompactAnnotationNode firstAnnotation;
        JSONObject port = new JSONObject();
        port.put("name", (Object)field.getName());
        TypeGraph.TypeGraphVertex tgv = this.typeGraph.getTypeGraphVertex(clazz);
        this.putFieldDescription(field, port, tgv);
        List<CompactAnnotationNode> annotations = field.getVisibleAnnotations();
        if (annotations != null && !annotations.isEmpty() && (firstAnnotation = field.getVisibleAnnotations().get(0)) != null) {
            for (Map.Entry<String, Object> entry : firstAnnotation.getAnnotations().entrySet()) {
                port.put(entry.getKey(), entry.getValue());
            }
        }
        return port;
    }

    private void putFieldDescription(CompactFieldNode field, JSONObject port, TypeGraph.TypeGraphVertex tgv) throws JSONException {
        String fieldDesc;
        OperatorClassInfo oci = this.classInfo.get(tgv.typeName);
        if (oci != null && (fieldDesc = oci.fields.get(field.getName())) != null) {
            port.put("description", (Object)fieldDesc);
            return;
        }
        for (TypeGraph.TypeGraphVertex ancestor : tgv.getAncestors()) {
            this.putFieldDescription(field, port, ancestor);
        }
    }

    private JSONArray enrichProperties(String operatorClass, JSONArray properties) throws JSONException {
        JSONArray result = new JSONArray();
        for (int i = 0; i < properties.length(); ++i) {
            JSONObject propJ = properties.getJSONObject(i);
            String propName = WordUtils.capitalize((String)propJ.getString("name"));
            String getPrefix = propJ.getString("type").equals("boolean") || propJ.getString("type").equals("java.lang.Boolean") ? "is" : "get";
            String setPrefix = "set";
            OperatorClassInfo oci = this.getOperatorClassWithGetterSetter(operatorClass, setPrefix + propName, getPrefix + propName);
            if (oci == null) {
                result.put((Object)propJ);
                continue;
            }
            MethodInfo setterInfo = oci.setMethods.get(setPrefix + propName);
            MethodInfo getterInfo = oci.getMethods.get(getPrefix + propName);
            if (getterInfo != null && getterInfo.omitFromUI || setterInfo != null && setterInfo.omitFromUI) continue;
            if (setterInfo != null) {
                this.addTagsToProperties(setterInfo, propJ);
            } else if (getterInfo != null) {
                this.addTagsToProperties(getterInfo, propJ);
            }
            result.put((Object)propJ);
        }
        return result;
    }

    private OperatorClassInfo getOperatorClassWithGetterSetter(String operatorClass, String setterName, String getterName) {
        TypeGraph.TypeGraphVertex tgv = this.typeGraph.getTypeGraphVertex(operatorClass);
        return this.getOperatorClassWithGetterSetter(tgv, setterName, getterName);
    }

    private OperatorClassInfo getOperatorClassWithGetterSetter(TypeGraph.TypeGraphVertex tgv, String setterName, String getterName) {
        Iterator<TypeGraph.TypeGraphVertex> i$;
        OperatorClassInfo oci = this.classInfo.get(tgv.typeName);
        if (oci != null && (oci.getMethods.containsKey(getterName) || oci.setMethods.containsKey(setterName))) {
            return oci;
        }
        if (tgv.getAncestors() != null && (i$ = tgv.getAncestors().iterator()).hasNext()) {
            TypeGraph.TypeGraphVertex ancestor = i$.next();
            return this.getOperatorClassWithGetterSetter(ancestor, setterName, getterName);
        }
        return null;
    }

    private void addTagsToProperties(MethodInfo mi, JSONObject propJ) throws JSONException {
        JSONObject descriptionObj = new JSONObject();
        if (mi.comment != null) {
            descriptionObj.put("$", (Object)mi.comment);
        }
        for (Map.Entry<String, String> descEntry : mi.descriptions.entrySet()) {
            descriptionObj.put(descEntry.getKey(), (Object)descEntry.getValue());
        }
        if (descriptionObj.length() > 0) {
            propJ.put("descriptions", (Object)descriptionObj);
        }
        JSONObject useSchemaObj = new JSONObject();
        for (Map.Entry<String, String> useSchemaEntry : mi.useSchemas.entrySet()) {
            useSchemaObj.put(useSchemaEntry.getKey(), (Object)useSchemaEntry.getValue());
        }
        if (useSchemaObj.length() > 0) {
            propJ.put("useSchema", (Object)useSchemaObj);
        }
    }

    public JSONObject describeClass(String clazzName) throws Exception {
        return this.describeClassByASM(clazzName);
    }

    public JSONObject describeClassByASM(String clazzName) throws Exception {
        return this.typeGraph.describeClass(clazzName);
    }

    public JSONObject describeClass(Class<?> clazz) throws Exception {
        TypeDiscoverer.UI_TYPE ui_type;
        JSONObject desc = new JSONObject();
        desc.put("name", (Object)clazz.getName());
        if (clazz.isEnum()) {
            Class<?> enumClass = clazz;
            ArrayList enumNames = Lists.newArrayList();
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                enumNames.add(e.name());
            }
            desc.put("enum", (Collection)enumNames);
        }
        if ((ui_type = TypeDiscoverer.UI_TYPE.getEnumFor(clazz)) != null) {
            desc.put("uiType", (Object)ui_type.getName());
        }
        desc.put("properties", (Object)this.getClassProperties(clazz, 0));
        return desc;
    }

    private static String getDocName(String clazz) {
        return clazz.replace('.', '/').replace('$', '.') + ".html";
    }

    private JSONArray getClassProperties(Class<?> clazz, int level) throws IntrospectionException {
        JSONArray arr = new JSONArray();
        TypeDiscoverer td = new TypeDiscoverer();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                Method readMethod = pd.getReadMethod();
                if (readMethod == null ? "up".equals(pd.getName()) && Context.class.isAssignableFrom(pd.getPropertyType()) : readMethod.getDeclaringClass() == Enum.class || "class".equals(pd.getName())) continue;
                Class<?> propertyType = pd.getPropertyType();
                if (propertyType == null) continue;
                JSONObject propertyObj = new JSONObject();
                propertyObj.put("name", (Object)pd.getName());
                propertyObj.put("canGet", readMethod != null);
                propertyObj.put("canSet", pd.getWriteMethod() != null);
                if (readMethod != null) {
                    for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                        MethodInfo getMethodInfo;
                        OperatorClassInfo oci = this.classInfo.get(c.getName());
                        if (oci == null || (getMethodInfo = oci.getMethods.get(readMethod.getName())) == null) continue;
                        this.addTagsToProperties(getMethodInfo, propertyObj);
                        break;
                    }
                    td.setTypeArguments(clazz, readMethod.getGenericReturnType(), propertyObj);
                } else if (pd.getWriteMethod() != null) {
                    td.setTypeArguments(clazz, pd.getWriteMethod().getGenericParameterTypes()[0], propertyObj);
                }
                arr.put((Object)propertyObj);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return arr;
    }

    private static String decamelizeClassName(String className) {
        Matcher match = CAPS.matcher(className);
        StringBuilder deCameled = new StringBuilder();
        while (match.find()) {
            if (deCameled.length() == 0) {
                deCameled.append(match.group());
                continue;
            }
            deCameled.append(" ");
            deCameled.append(match.group().toLowerCase());
        }
        return deCameled.toString();
    }

    public void buildAdditionalPortInfo(JSONObject oper, JSONObject portClassHierarchy, JSONObject portTypesWithSchemaClasses) {
        try {
            JSONArray ports = oper.getJSONArray(PORT_TYPE_INFO_KEY);
            for (int i = 0; i < ports.length(); ++i) {
                JSONObject port = ports.getJSONObject(i);
                String portType = port.optString("type");
                if (portType == null) continue;
                if (this.typeGraph.size() == 0) {
                    this.buildTypeGraph();
                }
                try {
                    LinkedList queue = Lists.newLinkedList();
                    queue.add(portType);
                    while (!queue.isEmpty()) {
                        String currentType = (String)queue.remove();
                        if (portClassHierarchy.has(currentType)) continue;
                        List<String> immediateParents = this.typeGraph.getParents(currentType);
                        if (immediateParents == null) {
                            portClassHierarchy.put(currentType, (Collection)Lists.newArrayList());
                            continue;
                        }
                        portClassHierarchy.put(currentType, immediateParents);
                        queue.addAll(immediateParents);
                    }
                }
                catch (JSONException e) {
                    LOG.warn("building port type hierarchy {}", (Object)portType, (Object)e);
                }
                if (portTypesWithSchemaClasses.has(portType) || portType.equals("byte") || portType.equals("short") || portType.equals("char") || portType.equals("int") || portType.equals("long") || portType.equals("float") || portType.equals("double") || portType.equals("java.lang.String") || portType.equals("java.lang.Object") || port.has("typeArgs")) continue;
                boolean hasSchemaClasses = false;
                List<String> instantiableDescendants = this.typeGraph.getInstantiableDescendants(portType);
                if (instantiableDescendants != null) {
                    for (String descendant : instantiableDescendants) {
                        try {
                            if (!this.typeGraph.isInstantiableBean(descendant)) continue;
                            hasSchemaClasses = true;
                            break;
                        }
                        catch (JSONException ex) {
                            LOG.warn("checking descendant is instantiable {}", (Object)descendant);
                        }
                    }
                }
                portTypesWithSchemaClasses.put(portType, hasSchemaClasses);
            }
        }
        catch (JSONException e) {
            LOG.error("JSON Exception {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public JSONArray getDescendants(String fullClassName) {
        if (this.typeGraph.size() == 0) {
            this.buildTypeGraph();
        }
        return new JSONArray(this.typeGraph.getDescendants(fullClassName));
    }

    public TypeGraph getTypeGraph() {
        return this.typeGraph;
    }

    private class JavadocSAXHandler
    extends DefaultHandler {
        private String className = null;
        private OperatorClassInfo oci = null;
        private StringBuilder comment;
        private String fieldName = null;
        private String methodName = null;
        private final Pattern getterPattern = Pattern.compile("(?:is|get)[A-Z].*");
        private final Pattern setterPattern = Pattern.compile("(?:set)[A-Z].*");

        private JavadocSAXHandler() {
        }

        private boolean isGetter(String methodName) {
            return this.getterPattern.matcher(methodName).matches();
        }

        private boolean isSetter(String methodName) {
            return this.setterPattern.matcher(methodName).matches();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("class")) {
                this.className = attributes.getValue("qualified");
                this.oci = new OperatorClassInfo();
            } else if (qName.equalsIgnoreCase("comment")) {
                this.comment = new StringBuilder();
            } else if (qName.equalsIgnoreCase("tag")) {
                if (this.oci != null) {
                    String tagName = attributes.getValue("name");
                    String tagText = attributes.getValue("text").trim();
                    if (this.methodName != null) {
                        MethodTagType type;
                        boolean lSetterCheck;
                        boolean lGetterCheck = this.isGetter(this.methodName);
                        boolean bl = lSetterCheck = !lGetterCheck && this.isSetter(this.methodName);
                        if ((lGetterCheck || lSetterCheck) && (type = MethodTagType.from(tagName)) != null) {
                            this.addTagToMethod(lGetterCheck ? this.oci.getMethods : this.oci.setMethods, tagText, type);
                        }
                    } else if (this.fieldName == null) {
                        this.oci.tags.put(tagName, tagText);
                    }
                }
            } else if (qName.equalsIgnoreCase("field")) {
                this.fieldName = attributes.getValue("name");
            } else if (qName.equalsIgnoreCase("method")) {
                this.methodName = attributes.getValue("name");
            }
        }

        private void addTagToMethod(Map<String, MethodInfo> methods, String tagText, MethodTagType tagType) {
            MethodInfo mi = methods.get(this.methodName);
            if (mi == null) {
                mi = new MethodInfo();
                methods.put(this.methodName, mi);
            }
            if (tagType == MethodTagType.OMIT_FROM_UI) {
                mi.omitFromUI = true;
                return;
            }
            String[] tagParts = (String[])Iterables.toArray((Iterable)Splitter.on((Pattern)WHITESPACE_PATTERN).trimResults().omitEmptyStrings().limit(2).split((CharSequence)tagText), String.class);
            if (tagParts.length == 2) {
                if (tagType == MethodTagType.DESCRIPTION) {
                    mi.descriptions.put(tagParts[0], tagParts[1]);
                } else {
                    mi.useSchemas.put(tagParts[0], tagParts[1]);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("class")) {
                OperatorDiscoverer.this.classInfo.put(this.className, this.oci);
                this.className = null;
                this.oci = null;
            } else if (qName.equalsIgnoreCase("comment") && this.oci != null) {
                if (this.methodName != null) {
                    if (this.isGetter(this.methodName)) {
                        MethodInfo mi = this.oci.getMethods.get(this.methodName);
                        if (mi == null) {
                            mi = new MethodInfo();
                            this.oci.getMethods.put(this.methodName, mi);
                        }
                        mi.comment = this.comment.toString();
                    } else if (this.isSetter(this.methodName)) {
                        MethodInfo mi = this.oci.setMethods.get(this.methodName);
                        if (mi == null) {
                            mi = new MethodInfo();
                            this.oci.setMethods.put(this.methodName, mi);
                        }
                        mi.comment = this.comment.toString();
                    }
                } else if (this.fieldName != null) {
                    this.oci.fields.put(this.fieldName, this.comment.toString());
                } else {
                    this.oci.comment = this.comment.toString();
                }
                this.comment = null;
            } else if (qName.equalsIgnoreCase("field")) {
                this.fieldName = null;
            } else if (qName.equalsIgnoreCase("method")) {
                this.methodName = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.comment != null) {
                this.comment.append(ch, start, length);
            }
        }
    }

    static enum MethodTagType {
        USE_SCHEMA("@useSchema"),
        DESCRIPTION("@description"),
        OMIT_FROM_UI("@omitFromUI");

        private static final Map<String, MethodTagType> TAG_TEXT_MAPPING;
        private final String tag;

        private MethodTagType(String tag) {
            this.tag = tag;
        }

        static MethodTagType from(String tag) {
            return TAG_TEXT_MAPPING.get(tag);
        }

        static {
            TAG_TEXT_MAPPING = Maps.newHashMap();
            for (MethodTagType type : MethodTagType.values()) {
                TAG_TEXT_MAPPING.put(type.tag, type);
            }
        }
    }

    private static class MethodInfo {
        Map<String, String> descriptions = Maps.newHashMap();
        Map<String, String> useSchemas = Maps.newHashMap();
        String comment;
        boolean omitFromUI;

        private MethodInfo() {
        }
    }

    private static class OperatorClassInfo {
        String comment;
        final Map<String, String> tags = new HashMap<String, String>();
        final Map<String, MethodInfo> getMethods = Maps.newHashMap();
        final Map<String, MethodInfo> setMethods = Maps.newHashMap();
        final Map<String, String> fields = new HashMap<String, String>();

        private OperatorClassInfo() {
        }
    }
}

