/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.api.Component;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.netlet.util.DTThrowable;
import com.datatorrent.stram.webapp.asm.ClassNodeType;
import com.datatorrent.stram.webapp.asm.ClassSignatureVisitor;
import com.datatorrent.stram.webapp.asm.CompactClassNode;
import com.datatorrent.stram.webapp.asm.CompactFieldNode;
import com.datatorrent.stram.webapp.asm.CompactMethodNode;
import com.datatorrent.stram.webapp.asm.CompactUtil;
import com.datatorrent.stram.webapp.asm.FastClassIndexReader;
import com.datatorrent.stram.webapp.asm.MethodSignatureVisitor;
import com.datatorrent.stram.webapp.asm.Type;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.xbean.asm5.ClassReader;
import org.apache.xbean.asm5.ClassVisitor;
import org.codehaus.jackson.map.deser.std.FromStringDeserializer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeGraph {
    public static final String[] EXCLUDE_CLASSES = new String[]{Object.class.getName().replace('.', '/'), Enum.class.getName().replace('.', '/'), Operator.class.getName().replace('.', '/'), Component.class.getName().replace('.', '/'), BaseOperator.class.getName().replace('.', '/')};
    public static final ImmutableSet<String> JACKSON_INSTANTIABLE_CLASSES;
    private static final Logger LOG;
    private final Map<String, TypeGraphVertex> typeGraph = new HashMap<String, TypeGraphVertex>();

    public boolean isAncestor(String parentClassName, String subClassName) {
        TypeGraphVertex parentVertex = this.typeGraph.get(parentClassName);
        TypeGraphVertex classVertex = this.typeGraph.get(subClassName);
        if (parentVertex == null || classVertex == null) {
            return false;
        }
        return TypeGraph.isAncestor(parentVertex, classVertex);
    }

    public TypeGraphVertex getTypeGraphVertex(String className) {
        return this.typeGraph.get(className);
    }

    private static boolean isAncestor(TypeGraphVertex typeTgv, TypeGraphVertex tgv) {
        if (tgv == typeTgv) {
            return true;
        }
        if (tgv.ancestors == null || tgv.ancestors.size() == 0) {
            return false;
        }
        for (TypeGraphVertex vertex : tgv.ancestors) {
            if (!TypeGraph.isAncestor(typeTgv, vertex)) continue;
            return true;
        }
        return false;
    }

    public TypeGraphVertex getNode(String typeName) {
        return this.typeGraph.get(typeName);
    }

    public static List<String> getAllAncestors(TypeGraphVertex tgv, boolean include) {
        LinkedList<String> result = new LinkedList<String>();
        if (include) {
            result.add(tgv.typeName);
        }
        TypeGraph.getAllAncestors(tgv, result);
        return result;
    }

    private static void getAllAncestors(TypeGraphVertex tgv, List<String> result) {
        for (TypeGraphVertex an : tgv.ancestors) {
            result.add(an.typeName);
            TypeGraph.getAllAncestors(an, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeGraphVertex addNode(InputStream input, String resName) throws IOException {
        try {
            TypeGraphVertex ptgv;
            TypeGraphVertex tgv;
            FastClassIndexReader fastClassIndexReader = new FastClassIndexReader(input);
            String typeName = fastClassIndexReader.getName().replace('/', '.');
            if (this.typeGraph.containsKey(typeName)) {
                tgv = this.typeGraph.get(typeName);
                tgv.setIsRealNode(true);
                tgv.setJarName(resName);
                tgv.setIsInstantiable(fastClassIndexReader.isInstantiable());
            } else {
                tgv = new TypeGraphVertex(this, typeName, resName, true, fastClassIndexReader.isInstantiable());
                this.typeGraph.put(typeName, tgv);
            }
            String immediateP = fastClassIndexReader.getSuperName();
            if (immediateP != null) {
                ptgv = this.typeGraph.get(immediateP = immediateP.replace('/', '.'));
                if (ptgv == null) {
                    ptgv = new TypeGraphVertex(this, immediateP, resName);
                    this.typeGraph.put(immediateP, ptgv);
                }
                tgv.ancestors.add(ptgv);
                ptgv.descendants.add(tgv);
            }
            if (fastClassIndexReader.getInterfaces() != null) {
                for (String iface : fastClassIndexReader.getInterfaces()) {
                    ptgv = this.typeGraph.get(iface = iface.replace('/', '.'));
                    if (ptgv == null) {
                        ptgv = new TypeGraphVertex(this, iface, resName);
                        this.typeGraph.put(iface, ptgv);
                    }
                    tgv.ancestors.add(ptgv);
                    ptgv.descendants.add(tgv);
                }
            }
            this.updateInstantiableDescendants(tgv);
            TypeGraphVertex typeGraphVertex = tgv;
            return typeGraphVertex;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public TypeGraphVertex addNode(File file) throws IOException {
        return this.addNode(new FileInputStream(file), file.getAbsolutePath());
    }

    public TypeGraphVertex addNode(JarEntry jarEntry, JarFile jar) throws IOException {
        return this.addNode(jar.getInputStream(jarEntry), jar.getName());
    }

    private void updateInstantiableDescendants(TypeGraphVertex tgv) {
        if (tgv.isInstantiable()) {
            tgv.allInstantiableDescendants.add(tgv);
        }
        for (TypeGraphVertex parent : tgv.ancestors) {
            this.updateInstantiableDescendants(parent, tgv.allInstantiableDescendants);
        }
    }

    private void updateInstantiableDescendants(TypeGraphVertex tgv, Set<TypeGraphVertex> allChildren) {
        tgv.allInstantiableDescendants.addAll(allChildren);
        for (TypeGraphVertex parent : tgv.ancestors) {
            this.updateInstantiableDescendants(parent, allChildren);
        }
    }

    public int size() {
        return this.typeGraph.size();
    }

    public Set<String> getAllDTInstantiableOperators() {
        TypeGraphVertex tgv = this.typeGraph.get(Operator.class.getName());
        if (tgv == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (TypeGraphVertex node : tgv.allInstantiableDescendants) {
            if (!this.isAncestor(InputOperator.class.getName(), node.typeName) && this.getAllInputPorts(node).isEmpty()) continue;
            result.add(node.typeName);
        }
        return result;
    }

    public Set<String> getDescendants(String fullClassName) {
        HashSet<String> result = new HashSet<String>();
        TypeGraphVertex tgv = this.typeGraph.get(fullClassName);
        if (tgv != null) {
            this.tranverse(tgv, false, result, Integer.MAX_VALUE);
        }
        return result;
    }

    public List<String> getInstantiableDescendants(String fullClassName) {
        return this.getInstantiableDescendants(fullClassName, null, null, null);
    }

    private void tranverse(TypeGraphVertex tgv, boolean onlyInstantiable, Set<String> result, int limit) {
        if (!onlyInstantiable) {
            result.add(tgv.typeName);
        }
        if (onlyInstantiable && tgv.numberOfInstantiableDescendants() > limit) {
            throw new RuntimeException("Too many public concrete sub types!");
        }
        if (onlyInstantiable && tgv.isInstantiable()) {
            result.add(tgv.typeName);
        }
        if (tgv.descendants.size() > 0) {
            for (TypeGraphVertex child : tgv.descendants) {
                this.tranverse(child, onlyInstantiable, result, limit);
            }
        }
    }

    public List<String> getInstantiableDescendants(String clazz, String filter, String packagePrefix, String startsWith) {
        TypeGraphVertex tgv = this.typeGraph.get(clazz);
        if (tgv == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        if (tgv != null) {
            for (TypeGraphVertex node : tgv.allInstantiableDescendants) {
                String typeName = node.typeName;
                if (filter != null && !Pattern.matches(filter, node.typeName) || packagePrefix != null && !node.typeName.startsWith(packagePrefix) || startsWith != null && !typeName.substring(typeName.lastIndexOf(46) + 1).toLowerCase().startsWith(startsWith.toLowerCase())) continue;
                result.add(node.typeName);
            }
        }
        return result;
    }

    public JSONObject describeClass(String clazzName) throws JSONException {
        UI_TYPE uType;
        JSONObject desc = new JSONObject();
        desc.put("name", (Object)clazzName);
        TypeGraphVertex tgv = this.typeGraph.get(clazzName);
        if (tgv == null) {
            return desc;
        }
        CompactClassNode cn = tgv.getOrLoadClassNode();
        if (cn.isEnum()) {
            List<String> enumNames = cn.getEnumValues();
            desc.put("enum", enumNames);
            desc.put("uiType", (Object)UI_TYPE.ENUM.getName());
        }
        if ((uType = UI_TYPE.getEnumFor(tgv.typeName, this.typeGraph)) != null) {
            desc.put("uiType", (Object)uType.getName());
        }
        this.addClassPropertiesAndPorts(clazzName, desc);
        if (tgv.hasResource()) {
            desc.put("hasResource", (Object)"true");
        } else {
            desc.put("hasResource", (Object)"false");
        }
        return desc;
    }

    private Collection<JSONObject> getPortTypeInfo(String clazzName, Map<Type, Type> typeReplacement, List<CompactFieldNode> ports) throws JSONException {
        TypeGraphVertex tgv = this.typeGraph.get(clazzName);
        if (tgv == null) {
            return null;
        }
        ArrayList<JSONObject> portInfo = new ArrayList<JSONObject>();
        for (CompactFieldNode port : ports) {
            Type fieldType;
            Type t = fieldType = port.getFieldSignatureNode().getFieldType();
            if (fieldType instanceof Type.ParameterizedTypeNode) {
                t = ((Type.ParameterizedTypeNode)fieldType).getActualTypeArguments()[0];
            } else {
                TypeGraphVertex portVertex = this.typeGraph.get(port.getDescription());
                t = this.findTypeArgument(portVertex, typeReplacement);
                LOG.debug("Field is of type {}", fieldType.getClass());
            }
            JSONObject meta = new JSONObject();
            try {
                meta.put("name", (Object)port.getName());
                this.setTypes(meta, t, typeReplacement);
                portInfo.add(meta);
            }
            catch (Exception e) {
                DTThrowable.wrapIfChecked((Exception)e);
            }
        }
        return portInfo;
    }

    public static Type getParameterizedTypeArgument(Type type) {
        if (type instanceof Type.ParameterizedTypeNode) {
            return ((Type.ParameterizedTypeNode)type).getActualTypeArguments()[0];
        }
        return null;
    }

    private Type findTypeArgument(TypeGraphVertex tgv, Map<Type, Type> typeReplacement) {
        Iterator<Type> i$;
        if (tgv == null) {
            return null;
        }
        ClassSignatureVisitor csv = tgv.getOrLoadClassNode().getCsv();
        Type superC = csv.getSuperClass();
        this.addReplacement(superC, typeReplacement);
        Type t = TypeGraph.getParameterizedTypeArgument(superC);
        if (t != null) {
            return t;
        }
        if (csv.getInterfaces() != null) {
            i$ = csv.getInterfaces().iterator();
            while (i$.hasNext()) {
                Type it = i$.next();
                this.addReplacement(it, typeReplacement);
                t = TypeGraph.getParameterizedTypeArgument(it);
                if (t == null) continue;
                return t;
            }
        }
        if ((i$ = tgv.ancestors.iterator()).hasNext()) {
            TypeGraphVertex ancestor = (TypeGraphVertex)((Object)i$.next());
            return this.findTypeArgument(ancestor, typeReplacement);
        }
        return null;
    }

    public List<CompactFieldNode> getAllInputPorts(String clazzName) {
        TypeGraphVertex tgv = this.typeGraph.get(clazzName);
        return this.getAllInputPorts(tgv);
    }

    public List<CompactFieldNode> getAllInputPorts(TypeGraphVertex tgv) {
        ArrayList<CompactFieldNode> ports = new ArrayList<CompactFieldNode>();
        if (tgv == null) {
            return ports;
        }
        TypeGraphVertex portVertex = this.typeGraph.get(Operator.InputPort.class.getName());
        this.getAllPortsWithAncestor(portVertex, tgv, ports);
        Collections.sort(ports, new Comparator<CompactFieldNode>(){

            @Override
            public int compare(CompactFieldNode a, CompactFieldNode b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return ports;
    }

    public List<CompactFieldNode> getAllOutputPorts(String clazzName) {
        TypeGraphVertex tgv = this.typeGraph.get(clazzName);
        ArrayList<CompactFieldNode> ports = new ArrayList<CompactFieldNode>();
        TypeGraphVertex portVertex = this.typeGraph.get(Operator.OutputPort.class.getName());
        this.getAllPortsWithAncestor(portVertex, tgv, ports);
        Collections.sort(ports, new Comparator<CompactFieldNode>(){

            @Override
            public int compare(CompactFieldNode a, CompactFieldNode b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return ports;
    }

    private void getAllPortsWithAncestor(TypeGraphVertex portVertex, TypeGraphVertex tgv, List<CompactFieldNode> ports) {
        List<CompactFieldNode> fields = tgv.getOrLoadClassNode().getPorts();
        if (fields != null) {
            for (CompactFieldNode field : fields) {
                TypeGraphVertex fieldVertex = this.typeGraph.get(field.getDescription());
                if (!TypeGraph.isAncestor(portVertex, fieldVertex)) continue;
                ports.add(field);
            }
        }
        for (TypeGraphVertex ancestor : tgv.ancestors) {
            this.getAllPortsWithAncestor(portVertex, ancestor, ports);
        }
    }

    private void addClassPropertiesAndPorts(String clazzName, JSONObject desc) throws JSONException {
        TypeGraphVertex tgv = this.typeGraph.get(clazzName);
        if (tgv == null) {
            return;
        }
        TreeMap<String, JSONObject> results = new TreeMap<String, JSONObject>();
        LinkedList<CompactMethodNode> getters = new LinkedList<CompactMethodNode>();
        LinkedList<CompactMethodNode> setters = new LinkedList<CompactMethodNode>();
        HashMap<Type, Type> typeReplacement = new HashMap<Type, Type>();
        LinkedList<CompactFieldNode> ports = new LinkedList<CompactFieldNode>();
        this.getPublicSetterGetterAndPorts(tgv, setters, getters, typeReplacement, ports);
        desc.put("portTypeInfo", this.getPortTypeInfo(clazzName, typeReplacement, ports));
        for (CompactMethodNode setter : setters) {
            String prop = WordUtils.uncapitalize((String)setter.getName().substring(3));
            JSONObject propJ = (JSONObject)results.get(prop);
            if (propJ == null) {
                propJ = new JSONObject();
                propJ.put("name", (Object)prop);
                results.put(prop, propJ);
            }
            propJ.put("canSet", true);
            propJ.put("canGet", false);
            MethodSignatureVisitor msv = null;
            msv = setter.getMethodSignatureNode();
            if (msv == null) continue;
            List<Type> param = msv.getParameters();
            if (CollectionUtils.isEmpty(param)) {
                propJ.put("type", (Object)"UNKNOWN");
                continue;
            }
            this.setTypes(propJ, param.get(0), typeReplacement);
        }
        for (CompactMethodNode getter : getters) {
            int si = getter.getName().startsWith("is") ? 2 : 3;
            String prop = WordUtils.uncapitalize((String)getter.getName().substring(si));
            JSONObject propJ = (JSONObject)results.get(prop);
            if (propJ == null) {
                propJ = new JSONObject();
                propJ.put("name", (Object)prop);
                results.put(prop, propJ);
                propJ.put("canSet", false);
                MethodSignatureVisitor msv = null;
                msv = getter.getMethodSignatureNode();
                if (msv == null) continue;
                Type rt = msv.getReturnType();
                if (rt == null) {
                    propJ.put("type", (Object)"UNKNOWN");
                } else {
                    this.setTypes(propJ, rt, typeReplacement);
                }
            }
            propJ.put("canGet", true);
        }
        desc.put("properties", results.values());
    }

    private void getPublicSetterGetterAndPorts(TypeGraphVertex tgv, List<CompactMethodNode> setters, List<CompactMethodNode> getters, Map<Type, Type> typeReplacement, List<CompactFieldNode> ports) {
        CompactClassNode exClass = null;
        for (String e : EXCLUDE_CLASSES) {
            if (!e.equals(tgv.getOrLoadClassNode().getName())) continue;
            exClass = tgv.getOrLoadClassNode();
            break;
        }
        if (exClass != null) {
            CompactMethodNode cmn;
            for (CompactMethodNode compactMethodNode : exClass.getGetterMethods()) {
                Iterator<CompactMethodNode> iterator = getters.iterator();
                while (iterator.hasNext()) {
                    cmn = iterator.next();
                    if (!cmn.getName().equals(compactMethodNode.getName())) continue;
                    iterator.remove();
                }
            }
            for (CompactMethodNode compactMethodNode : exClass.getSetterMethods()) {
                Iterator<CompactMethodNode> iterator = setters.iterator();
                while (iterator.hasNext()) {
                    cmn = iterator.next();
                    if (!cmn.getName().equals(compactMethodNode.getName())) continue;
                    iterator.remove();
                }
            }
        } else {
            if (tgv.getOrLoadClassNode().getSetterMethods() != null) {
                setters.addAll(tgv.getOrLoadClassNode().getSetterMethods());
            }
            if (tgv.getOrLoadClassNode().getGetterMethods() != null) {
                getters.addAll(tgv.getOrLoadClassNode().getGetterMethods());
            }
        }
        TypeGraphVertex portVertex = this.typeGraph.get(Operator.Port.class.getName());
        List<CompactFieldNode> fields = tgv.getOrLoadClassNode().getPorts();
        if (fields != null) {
            for (CompactFieldNode field : fields) {
                TypeGraphVertex fieldVertex = this.typeGraph.get(field.getDescription());
                if (!TypeGraph.isAncestor(portVertex, fieldVertex)) continue;
                ports.add(field);
            }
        }
        ClassSignatureVisitor csv = tgv.getOrLoadClassNode().getCsv();
        Type superC = csv.getSuperClass();
        this.addReplacement(superC, typeReplacement);
        if (csv.getInterfaces() != null) {
            for (Type it : csv.getInterfaces()) {
                this.addReplacement(it, typeReplacement);
            }
        }
        for (TypeGraphVertex ancestor : tgv.ancestors) {
            this.getPublicSetterGetterAndPorts(ancestor, setters, getters, typeReplacement, ports);
        }
    }

    private void addReplacement(Type superT, Map<Type, Type> typeReplacement) {
        if (superT != null && superT instanceof Type.ParameterizedTypeNode) {
            Type[] actualTypes = ((Type.ParameterizedTypeNode)superT).getActualTypeArguments();
            List<Type.TypeVariableNode> tvs = this.typeGraph.get(((Type.ParameterizedTypeNode)superT).getTypeObj().getClassName()).getOrLoadClassNode().getCsv().getTypeV();
            int i = 0;
            for (Type.TypeVariableNode typeVariableNode : tvs) {
                typeReplacement.put(typeVariableNode, actualTypes[i++]);
            }
        }
    }

    private void setTypes(JSONObject propJ, Type rawType, Map<Type, Type> typeReplacement) throws JSONException {
        this.setTypes(propJ, rawType, typeReplacement, new HashSet<Type>());
    }

    private void setTypes(JSONObject propJ, Type rawType, Map<Type, Type> typeReplacement, Set<Type> visitedType) throws JSONException {
        boolean stopRecursive = visitedType.contains(rawType);
        visitedType.add(rawType);
        Type t = this.resolveType(rawType, typeReplacement);
        if (propJ == null) {
            return;
        }
        if (t instanceof Type.WildcardTypeNode) {
            propJ.put("type", (Object)"?");
        } else if (t instanceof Type.TypeNode) {
            Type.TypeNode tn = (Type.TypeNode)t;
            String typeS = tn.getTypeObj().getClassName();
            propJ.put("type", (Object)typeS);
            UI_TYPE uiType = UI_TYPE.getEnumFor(typeS, this.typeGraph);
            if (uiType != null) {
                switch (uiType) {
                    case FLOAT: 
                    case LONG: 
                    case INT: 
                    case DOUBLE: 
                    case BYTE: 
                    case SHORT: 
                    case STRING: {
                        propJ.put("type", (Object)uiType.getName());
                        break;
                    }
                    default: {
                        propJ.put("uiType", (Object)uiType.getName());
                    }
                }
            }
            if (t instanceof Type.ParameterizedTypeNode) {
                JSONArray jArray = new JSONArray();
                for (Type ttn : ((Type.ParameterizedTypeNode)t).getActualTypeArguments()) {
                    JSONObject objJ = new JSONObject();
                    if (!stopRecursive) {
                        this.setTypes(objJ, ttn, typeReplacement, visitedType);
                    }
                    jArray.put((Object)objJ);
                }
                propJ.put("typeArgs", (Object)jArray);
            }
        }
        if (t instanceof Type.WildcardTypeNode) {
            JSONObject typeBounds = new JSONObject();
            JSONArray jArray = new JSONArray();
            Type[] bounds = ((Type.WildcardTypeNode)t).getUpperBounds();
            if (bounds != null) {
                for (Type type : bounds) {
                    jArray.put((Object)type.toString());
                }
            }
            typeBounds.put("upper", (Object)jArray);
            bounds = ((Type.WildcardTypeNode)t).getLowerBounds();
            jArray = new JSONArray();
            if (bounds != null) {
                for (Type type : bounds) {
                    jArray.put((Object)type.toString());
                }
            }
            typeBounds.put("lower", (Object)jArray);
            propJ.put("typeBounds", (Object)typeBounds);
        }
        if (t instanceof Type.ArrayTypeNode) {
            propJ.put("type", (Object)t.getByteString());
            propJ.put("uiType", (Object)UI_TYPE.LIST.getName());
            JSONObject jObj = new JSONObject();
            if (!stopRecursive) {
                this.setTypes(jObj, ((Type.ArrayTypeNode)t).getActualArrayType(), typeReplacement, visitedType);
            }
            propJ.put("itemType", (Object)jObj);
        }
        if (t instanceof Type.TypeVariableNode) {
            propJ.put("typeLiteral", (Object)((Type.TypeVariableNode)t).getTypeLiteral());
            if (!stopRecursive) {
                this.setTypes(propJ, ((Type.TypeVariableNode)t).getRawTypeBound(), typeReplacement, visitedType);
            }
        }
    }

    public void trim() {
        LinkedList<TypeGraphVertex> invalidVertexes = new LinkedList<TypeGraphVertex>();
        for (TypeGraphVertex tgv : this.typeGraph.values()) {
            if (tgv.isRealNode()) continue;
            invalidVertexes.add(tgv);
        }
        for (TypeGraphVertex removeV : invalidVertexes) {
            this.removeSubGraph(removeV);
        }
    }

    private void removeSubGraph(TypeGraphVertex v) {
        LinkedList<TypeGraphVertex> removingQueue = new LinkedList<TypeGraphVertex>();
        removingQueue.add(v);
        while (!removingQueue.isEmpty()) {
            TypeGraphVertex tgv = (TypeGraphVertex)removingQueue.poll();
            if (this.typeGraph.get(tgv.typeName) == null) continue;
            for (TypeGraphVertex child : tgv.descendants) {
                removingQueue.offer(child);
            }
            this.typeGraph.remove(tgv.typeName);
            if (!tgv.allInstantiableDescendants.isEmpty() && !tgv.ancestors.isEmpty()) {
                for (TypeGraphVertex p : tgv.ancestors) {
                    this.removeFromInstantiableDescendants(p, tgv.allInstantiableDescendants);
                }
            }
            for (TypeGraphVertex parent : tgv.ancestors) {
                parent.descendants.remove(tgv);
            }
            tgv.ancestors.clear();
        }
    }

    private void removeFromInstantiableDescendants(TypeGraphVertex parentT, Set<TypeGraphVertex> childT) {
        for (TypeGraphVertex vertex : childT) {
            parentT.allInstantiableDescendants.remove(vertex);
        }
        for (TypeGraphVertex pt : parentT.ancestors) {
            this.removeFromInstantiableDescendants(pt, childT);
        }
    }

    private Type resolveType(Type t, Map<Type, Type> typeReplacement) {
        if (typeReplacement.containsKey(t)) {
            return this.resolveType(typeReplacement.get(t), typeReplacement);
        }
        return t;
    }

    public List<String> getParents(String className) {
        TypeGraphVertex tgv = this.typeGraph.get(className);
        if (tgv == null || tgv.ancestors == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (TypeGraphVertex p : tgv.ancestors) {
            result.add(p.typeName);
        }
        return result;
    }

    public boolean isInstantiableBean(String className) throws JSONException {
        JSONObject classDesc = this.describeClass(className);
        if (classDesc.has("typeArgs")) {
            return false;
        }
        JSONArray classProps = classDesc.optJSONArray("properties");
        if (classProps == null || classProps.length() == 0) {
            return false;
        }
        for (int p = 0; p < classProps.length(); ++p) {
            JSONObject propDesc = classProps.getJSONObject(p);
            if (!propDesc.optBoolean("canGet", false)) continue;
            return true;
        }
        return false;
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Class pc : Primitives.allWrapperTypes()) {
            b.add((Object)pc.getName());
        }
        for (FromStringDeserializer fsd : FromStringDeserializer.all()) {
            b.add((Object)fsd.getValueClass().getName());
        }
        JACKSON_INSTANTIABLE_CLASSES = b.build();
        LOG = LoggerFactory.getLogger(TypeGraph.class);
    }

    public static class TypeGraphSerializer
    extends Serializer<TypeGraph> {
        public void write(Kryo kryo, Output output, TypeGraph tg) {
            HashMap<String, Integer> indexes = new HashMap<String, Integer>();
            kryo.writeObject(output, (Object)tg.typeGraph.size());
            int i = 0;
            for (Map.Entry e : tg.typeGraph.entrySet()) {
                indexes.put((String)e.getKey(), i++);
                kryo.writeObject(output, e.getValue());
            }
            for (Map.Entry e : tg.typeGraph.entrySet()) {
                int[] refs = this.fromSet(((TypeGraphVertex)e.getValue()).descendants, indexes);
                kryo.writeObject(output, (Object)refs);
                refs = this.fromSet(((TypeGraphVertex)e.getValue()).allInstantiableDescendants, indexes);
                kryo.writeObject(output, (Object)refs);
            }
        }

        private int[] fromSet(Set<TypeGraphVertex> tgvSet, Map<String, Integer> indexes) {
            int[] result = new int[tgvSet.size()];
            int j = 0;
            for (TypeGraphVertex t : tgvSet) {
                result[j++] = indexes.get(t.typeName);
            }
            return result;
        }

        public TypeGraph read(Kryo kryo, Input input, Class<TypeGraph> type) {
            int i;
            int vertexNo = (Integer)kryo.readObject(input, Integer.class);
            TypeGraphVertex[] tgv = new TypeGraphVertex[vertexNo];
            for (i = 0; i < vertexNo; ++i) {
                tgv[i] = (TypeGraphVertex)kryo.readObject(input, TypeGraphVertex.class);
            }
            for (i = 0; i < tgv.length; ++i) {
                int j;
                int[] ref = (int[])kryo.readObject(input, int[].class);
                for (j = 0; j < ref.length; ++j) {
                    tgv[i].descendants.add(tgv[ref[j]]);
                    tgv[ref[j]].ancestors.add(tgv[i]);
                }
                ref = (int[])kryo.readObject(input, int[].class);
                for (j = 0; j < ref.length; ++j) {
                    tgv[i].allInstantiableDescendants.add(tgv[ref[j]]);
                }
            }
            TypeGraph result = new TypeGraph();
            for (TypeGraphVertex typeGraphVertex : tgv) {
                result.typeGraph.put(typeGraphVertex.typeName, typeGraphVertex);
                typeGraphVertex.setOwner(result);
            }
            return result;
        }
    }

    public static class TypeGraphVertex {
        public final String typeName;
        private CompactClassNode classNode = null;
        private final transient SortedSet<TypeGraphVertex> allInstantiableDescendants = new TreeSet<TypeGraphVertex>(new Comparator<TypeGraphVertex>(){

            @Override
            public int compare(TypeGraphVertex o1, TypeGraphVertex o2) {
                String n1 = o1.typeName;
                String n2 = o2.typeName;
                if (n1.startsWith("java")) {
                    n1 = "0" + n1;
                }
                if (n2.startsWith("java")) {
                    n2 = "0" + n2;
                }
                return n1.compareTo(n2);
            }
        });
        private final transient Set<TypeGraphVertex> ancestors = new HashSet<TypeGraphVertex>();
        private final transient Set<TypeGraphVertex> descendants = new HashSet<TypeGraphVertex>();
        private transient TypeGraph owner;
        private String jarName;
        private boolean hasResource = false;
        private boolean isRealNode = false;
        private boolean isInstantiable = false;

        private TypeGraphVertex() {
            this.jarName = "";
            this.typeName = "";
        }

        public TypeGraphVertex(TypeGraph owner, String typeName, String jarName, boolean isRealNode, boolean isInstantiable) {
            this.typeName = typeName;
            this.jarName = jarName;
            this.isRealNode = isRealNode;
            this.isInstantiable = isInstantiable;
            this.owner = owner;
        }

        public TypeGraphVertex(TypeGraph owner, String typeName, String jarName) {
            this(owner, typeName, jarName, false, false);
        }

        public void setOwner(TypeGraph owner) {
            this.owner = owner;
        }

        public TypeGraph getOwner() {
            return this.owner;
        }

        public Set<TypeGraphVertex> getAncestors() {
            return this.ancestors;
        }

        public int numberOfInstantiableDescendants() {
            return this.allInstantiableDescendants.size() + (this.isInstantiable() ? 1 : 0);
        }

        public boolean hasResource() {
            return this.hasResource;
        }

        public void setHasResource(boolean hasResource) {
            this.hasResource = hasResource;
        }

        public boolean isInstantiable() {
            return this.isInstantiable || JACKSON_INSTANTIABLE_CLASSES.contains((Object)this.typeName);
        }

        public void setIsInstantiable(boolean isInstantiable) {
            this.isInstantiable = isInstantiable;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeGraphVertex other = (TypeGraphVertex)obj;
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }

        public String getJarName() {
            return this.jarName;
        }

        public void setJarName(String jarName) {
            this.jarName = jarName;
        }

        public synchronized CompactClassNode getOrLoadClassNode() {
            if (this.classNode == null) {
                try {
                    this.loadClass();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.classNode;
        }

        public void setIsRealNode(boolean isRealNode) {
            this.isRealNode = isRealNode;
        }

        public boolean isRealNode() {
            return this.isRealNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadClass() throws IOException {
            if (this.classNode != null) {
                return;
            }
            for (TypeGraphVertex ancestor : this.getAncestors()) {
                ancestor.loadClass();
            }
            Closeable jarFile = null;
            InputStream inputStream = null;
            try {
                CompactClassNode ccn;
                if (this.jarName.endsWith(".jar")) {
                    JarFile jarfile = new JarFile(this.jarName);
                    inputStream = jarfile.getInputStream(jarfile.getEntry(this.typeName.replace('.', '/') + ".class"));
                } else {
                    inputStream = new FileInputStream(this.jarName);
                }
                ClassReader reader = new ClassReader(inputStream);
                ClassNodeType classN = new ClassNodeType();
                reader.accept((ClassVisitor)classN, 1);
                this.classNode = ccn = CompactUtil.compactClassNode(classN);
                if (this.owner.isAncestor(Operator.class.getName(), this.typeName)) {
                    CompactUtil.updateCompactClassPortInfo(classN, ccn);
                    LinkedList<CompactFieldNode> prunedFields = new LinkedList<CompactFieldNode>();
                    TypeGraphVertex portVertex = this.owner.getTypeGraphVertex(Operator.Port.class.getName());
                    for (CompactFieldNode field : ccn.getPorts()) {
                        TypeGraphVertex fieldVertex = this.owner.getTypeGraphVertex(field.getDescription());
                        if (fieldVertex == null || !TypeGraph.isAncestor(portVertex, fieldVertex)) continue;
                        prunedFields.add(field);
                    }
                    ccn.setPorts(prunedFields);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarFile);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(jarFile);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    static enum UI_TYPE {
        LIST("List", Collection.class.getName()),
        ENUM("Enum", Enum.class.getName()),
        MAP("Map", Map.class.getName()),
        STRING("java.lang.String", UI_TYPE.GetStringTypes()),
        INT("int", Integer.class.getName()),
        BYTE("byte", Byte.class.getName()),
        SHORT("short", Short.class.getName()),
        LONG("long", Long.class.getName()),
        DOUBLE("double", Double.class.getName()),
        FLOAT("float", Float.class.getName()),
        CHARACTER("char", Character.class.getName()),
        BOOLEAN("boolean", Boolean.class.getName());

        private final String[] allAssignableTypes;
        private final String name;

        private static String[] GetStringTypes() {
            ArrayList<String> l = new ArrayList<String>();
            l.add(Class.class.getName());
            for (FromStringDeserializer fsd : FromStringDeserializer.all()) {
                l.add(fsd.getValueClass().getName());
            }
            String[] a = new String[l.size()];
            return l.toArray(a);
        }

        private UI_TYPE(String name, String ... allAssignableTypes) {
            this.allAssignableTypes = allAssignableTypes;
            this.name = name;
        }

        public static UI_TYPE getEnumFor(String clazzName, Map<String, TypeGraphVertex> typeGraph) {
            TypeGraphVertex tgv = typeGraph.get(clazzName);
            if (tgv == null) {
                return null;
            }
            for (UI_TYPE type : UI_TYPE.values()) {
                for (String assignable : type.allAssignableTypes) {
                    TypeGraphVertex typeTgv = typeGraph.get(assignable);
                    if (typeTgv == null || !TypeGraph.isAncestor(typeTgv, tgv)) continue;
                    return type;
                }
            }
            return null;
        }

        public static UI_TYPE getEnumFor(TypeGraphVertex tgv) {
            List<String> allTypes = TypeGraph.getAllAncestors(tgv, true);
            for (UI_TYPE type : UI_TYPE.values()) {
                for (String assignable : type.allAssignableTypes) {
                    if (!allTypes.contains(assignable)) continue;
                    return type;
                }
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

