/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp.asm;

import java.util.LinkedList;
import java.util.List;
import org.apache.xbean.asm5.Type;
import org.apache.xbean.asm5.tree.ClassNode;
import org.apache.xbean.asm5.tree.FieldNode;
import org.apache.xbean.asm5.tree.MethodNode;

public class ASMUtil {
    public static final String CONSTRUCTOR_NAME = "<init>";

    public static boolean isEnum(ClassNode cn) {
        return (cn.access & 0x4000) == 16384;
    }

    public static boolean isEnumValue(FieldNode fn) {
        return (fn.access & 0x4000) == 16384;
    }

    public static List<String> getEnumValues(ClassNode cn) {
        LinkedList<String> result = new LinkedList<String>();
        for (FieldNode fn : cn.fields) {
            if (!ASMUtil.isEnumValue(fn)) continue;
            result.add(fn.name);
        }
        return result;
    }

    public static List<FieldNode> getPorts(ClassNode asmNode) {
        LinkedList<FieldNode> result = new LinkedList<FieldNode>();
        List fields = asmNode.fields;
        for (FieldNode fn : fields) {
            if (fn.desc.charAt(0) != 'L') continue;
            result.add(fn);
        }
        return result;
    }

    public static List<MethodNode> getPublicSetter(ClassNode asmNode) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        List mList = asmNode.methods;
        for (MethodNode methodNode : mList) {
            if (!methodNode.name.startsWith("set") || !ASMUtil.isPublic(methodNode.access) || Type.getArgumentTypes((String)methodNode.desc).length != 1 || Type.getReturnType((String)methodNode.desc) != Type.VOID_TYPE) continue;
            result.add(methodNode);
        }
        return result;
    }

    public static List<MethodNode> getPublicGetter(ClassNode asmNode) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        List mList = asmNode.methods;
        for (MethodNode methodNode : mList) {
            if (Type.getArgumentTypes((String)methodNode.desc).length != 0 || Type.getReturnType((String)methodNode.desc) == Type.VOID_TYPE || !methodNode.name.startsWith("get") && (!methodNode.name.startsWith("is") || Type.getReturnType((String)methodNode.desc) != Type.BOOLEAN_TYPE) || !ASMUtil.isPublic(methodNode.access)) continue;
            result.add(methodNode);
        }
        return result;
    }

    public static MethodNode getPublicDefaultConstructor(ClassNode asmNode) {
        List mList = asmNode.methods;
        for (MethodNode methodNode : mList) {
            if (!methodNode.name.equals(CONSTRUCTOR_NAME) || !ASMUtil.isPublic(methodNode.access) || Type.getArgumentTypes((String)methodNode.desc).length != 0) continue;
            return methodNode;
        }
        return null;
    }

    public static boolean isPublic(int opCode) {
        return (opCode & 1) == 1;
    }

    public static boolean isAbstract(int opCode) {
        return (opCode & 0x400) == 1024;
    }

    public static boolean isTransient(int opCode) {
        return (opCode & 0x80) == 128;
    }

    public static boolean isFinal(int opCode) {
        return (opCode & 0x10) == 16;
    }
}

