/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp.asm;

import com.datatorrent.stram.webapp.asm.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.xbean.asm5.signature.SignatureVisitor;

public abstract class BaseSignatureVisitor
extends SignatureVisitor {
    protected List<Type.TypeVariableNode> typeV = new LinkedList<Type.TypeVariableNode>();
    protected int stage = -1;
    public static final int VISIT_FORMAL_TYPE = 0;
    protected Stack<Type> visitingStack = new Stack();

    public BaseSignatureVisitor() {
        super(327680);
    }

    public SignatureVisitor visitArrayType() {
        Type.ArrayTypeNode at = new Type.ArrayTypeNode();
        this.visitingStack.push(at);
        return this;
    }

    public void visitBaseType(char baseType) {
        Type.TypeNode tn = new Type.TypeNode();
        tn.setObjByteCode(baseType + "");
        this.visitingStack.push(tn);
        this.resolveStack();
    }

    public void visitClassType(String classType) {
        Type.TypeNode tn = new Type.TypeNode();
        tn.setObjByteCode("L" + classType + ";");
        this.visitingStack.push(tn);
    }

    private void resolveStack() {
        if (this.visitingStack.isEmpty() || this.visitingStack.size() == 1) {
            return;
        }
        Type top = this.visitingStack.pop();
        Type peek = this.visitingStack.peek();
        if (peek instanceof Type.ParameterizedTypeNode) {
            ((Type.ParameterizedTypeNode)peek).actualTypeArguments.add(top);
            return;
        }
        if (peek instanceof Type.ArrayTypeNode) {
            ((Type.ArrayTypeNode)peek).actualArrayType = top;
            this.resolveStack();
        } else if (peek instanceof Type.WildcardTypeNode) {
            ((Type.WildcardTypeNode)peek).bounds.add(top);
            this.resolveStack();
        } else if (peek instanceof Type.TypeVariableNode) {
            ((Type.TypeVariableNode)peek).bounds.add(top);
            this.resolveStack();
        } else {
            this.visitingStack.push(top);
            return;
        }
    }

    public void visitEnd() {
        this.resolveStack();
    }

    public void visitInnerClassType(String classType) {
        this.visitClassType(classType);
    }

    public void visitTypeArgument() {
        this.visitTypeArgument('+');
        this.visitClassType(Object.class.getName());
        this.visitEnd();
    }

    public SignatureVisitor visitTypeArgument(char typeArg) {
        Type.TypeNode t = (Type.TypeNode)this.visitingStack.pop();
        if (t instanceof Type.ParameterizedTypeNode) {
            this.visitingStack.push(t);
        } else {
            Type.ParameterizedTypeNode pt = new Type.ParameterizedTypeNode();
            pt.setObjByteCode(t.getObjByteCode());
            this.visitingStack.push(pt);
        }
        if (typeArg == '=') {
            return this;
        }
        Type.WildcardTypeNode wtn = new Type.WildcardTypeNode();
        wtn.boundChar = typeArg;
        this.visitingStack.push(wtn);
        return this;
    }

    public void visitTypeVariable(String typeVariable) {
        boolean found = false;
        for (Type.TypeVariableNode typeVariableNode : this.typeV) {
            if (!typeVariableNode.typeLiteral.equals(typeVariable)) continue;
            this.visitingStack.push(typeVariableNode);
            found = true;
            break;
        }
        if (!found) {
            Type.TypeNode tn = new Type.TypeNode();
            tn.setObjByteCode("T" + typeVariable + ";");
            this.visitingStack.push(tn);
        }
        this.resolveStack();
    }

    public SignatureVisitor visitInterface() {
        throw new UnsupportedOperationException();
    }

    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public void visitFormalTypeParameter(String typeVariable) {
        if (this.stage == 0 && !this.visitingStack.isEmpty()) {
            this.visitingStack.pop();
        }
        this.stage = 0;
        Type.TypeVariableNode tvn = new Type.TypeVariableNode();
        tvn.typeLiteral = typeVariable;
        this.visitingStack.push(tvn);
        this.typeV.add(tvn);
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public List<Type.TypeVariableNode> getTypeV() {
        return this.typeV;
    }
}

