/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp.asm;

import com.datatorrent.stram.webapp.asm.ASMUtil;
import com.datatorrent.stram.webapp.asm.ClassNodeType;
import com.datatorrent.stram.webapp.asm.CompactAnnotationNode;
import com.datatorrent.stram.webapp.asm.CompactClassNode;
import com.datatorrent.stram.webapp.asm.CompactFieldNode;
import com.datatorrent.stram.webapp.asm.CompactMethodNode;
import com.datatorrent.stram.webapp.asm.FieldNode;
import com.datatorrent.stram.webapp.asm.MethodNode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.xbean.asm5.Type;
import org.apache.xbean.asm5.tree.AnnotationNode;
import org.apache.xbean.asm5.tree.ClassNode;
import org.apache.xbean.asm5.tree.InnerClassNode;

public class CompactUtil {
    public static CompactClassNode compactClassNode(ClassNode cn) {
        if (cn == null) {
            return null;
        }
        CompactClassNode ccn = new CompactClassNode();
        ccn.setAccess(cn.access);
        ccn.setDefaultConstructor(CompactUtil.compactMethodNode(ASMUtil.getPublicDefaultConstructor(cn)));
        LinkedList<CompactMethodNode> cmns = new LinkedList<CompactMethodNode>();
        for (org.apache.xbean.asm5.tree.MethodNode mn : ASMUtil.getPublicGetter(cn)) {
            cmns.add(CompactUtil.compactMethodNode(mn));
        }
        ccn.setGetterMethods(cmns);
        cmns = new LinkedList();
        for (org.apache.xbean.asm5.tree.MethodNode mn : ASMUtil.getPublicSetter(cn)) {
            cmns.add(CompactUtil.compactMethodNode(mn));
        }
        ccn.setSetterMethods(cmns);
        ccn.setPorts(new LinkedList<CompactFieldNode>());
        ccn.setName(cn.name);
        LinkedList<CompactClassNode> ccns = new LinkedList<CompactClassNode>();
        for (Object icn : cn.innerClasses) {
            CompactClassNode inner = new CompactClassNode();
            inner.setName(((InnerClassNode)icn).name);
            inner.setAccess(((InnerClassNode)icn).access);
        }
        ccn.setInnerClasses(ccns);
        if (ASMUtil.isEnum(cn)) {
            ccn.setEnumValues(ASMUtil.getEnumValues(cn));
        }
        if (cn instanceof ClassNodeType) {
            ccn.setCsv(((ClassNodeType)cn).csv);
        }
        return ccn;
    }

    public static void updateCompactClassPortInfo(ClassNode cn, CompactClassNode ccn) {
        List<org.apache.xbean.asm5.tree.FieldNode> fields = ASMUtil.getPorts(cn);
        LinkedList<CompactFieldNode> ports = new LinkedList<CompactFieldNode>();
        for (org.apache.xbean.asm5.tree.FieldNode fn : fields) {
            ports.add(CompactUtil.compactFieldNode(fn));
        }
        ccn.setPorts(ports);
    }

    private static CompactMethodNode compactMethodNode(org.apache.xbean.asm5.tree.MethodNode mn) {
        if (mn == null) {
            return null;
        }
        CompactMethodNode cmn = new CompactMethodNode();
        cmn.setName(mn.name);
        if (mn instanceof MethodNode) {
            cmn.setMethodSignatureNode(((MethodNode)mn).signatureNode);
        }
        return cmn;
    }

    private static CompactFieldNode compactFieldNode(org.apache.xbean.asm5.tree.FieldNode fn) {
        if (fn == null) {
            return null;
        }
        CompactFieldNode cfn = new CompactFieldNode();
        cfn.setName(fn.name);
        String className = Type.getObjectType((String)fn.desc).getClassName();
        if (className.charAt(0) == 'L') {
            className = className.substring(1);
        }
        if (className.endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        cfn.setDescription(className);
        cfn.setSignature(fn.signature);
        if (fn.visibleAnnotations != null) {
            CompactUtil.setAnnotationNode(fn, cfn);
        }
        if (fn instanceof FieldNode) {
            cfn.setFieldSignatureNode(((FieldNode)fn).signatureNode);
        }
        return cfn;
    }

    private static void setAnnotationNode(org.apache.xbean.asm5.tree.FieldNode fn, CompactFieldNode cfn) {
        LinkedList<CompactAnnotationNode> annotations = new LinkedList<CompactAnnotationNode>();
        for (Object visibleAnnotation : fn.visibleAnnotations) {
            CompactAnnotationNode node = new CompactAnnotationNode();
            HashMap<String, Object> annotationMap = new HashMap<String, Object>();
            if (visibleAnnotation instanceof AnnotationNode) {
                List annotationValues;
                AnnotationNode annotation = (AnnotationNode)visibleAnnotation;
                if ((annotation.desc.contains("InputPortFieldAnnotation") || annotation.desc.contains("OutputPortFieldAnnotation")) && (annotationValues = annotation.values) != null) {
                    int index = 0;
                    while (index <= annotationValues.size() - 2) {
                        String key = (String)annotationValues.get(index++);
                        Object value = annotationValues.get(index++);
                        annotationMap.put(key, value);
                    }
                    node.setAnnotations(annotationMap);
                    annotations.add(node);
                }
            }
            cfn.setVisibleAnnotations(annotations);
        }
    }
}

