/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp.asm;

import java.util.ArrayList;

public interface Type {
    public String getByteString();

    public static class ArrayTypeNode
    implements Type {
        Type actualArrayType;

        public Type getActualArrayType() {
            return this.actualArrayType;
        }

        @Override
        public String getByteString() {
            return "[" + this.actualArrayType.getByteString();
        }
    }

    public static class ParameterizedTypeNode
    extends TypeNode {
        ArrayList<Type> actualTypeArguments = new ArrayList();

        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments.toArray(new Type[0]);
        }
    }

    public static class TypeVariableNode
    implements Type {
        String typeLiteral;
        ArrayList<Type> bounds = new ArrayList();

        @Override
        public String getByteString() {
            return this.bounds.get(0).getByteString();
        }

        public Type[] getBounds() {
            return this.bounds.toArray(new Type[0]);
        }

        public String getTypeLiteral() {
            return this.typeLiteral;
        }

        public TypeNode getRawTypeBound() {
            Type t = this.bounds.get(0);
            if (t instanceof TypeNode) {
                return (TypeNode)t;
            }
            return ((TypeVariableNode)t).getRawTypeBound();
        }
    }

    public static class WildcardTypeNode
    implements Type {
        char boundChar;
        ArrayList<Type> bounds = new ArrayList();

        public Type[] getUpperBounds() {
            if (this.boundChar == '+') {
                return this.bounds.toArray(new Type[0]);
            }
            return null;
        }

        public Type[] getLowerBounds() {
            if (this.boundChar == '-') {
                return this.bounds.toArray(new Type[0]);
            }
            return null;
        }

        @Override
        public String getByteString() {
            return this.boundChar + "";
        }
    }

    public static class TypeNode
    implements Type {
        private transient org.apache.xbean.asm5.Type typeObj;
        private String objByteCode;

        public org.apache.xbean.asm5.Type getTypeObj() {
            if (this.typeObj == null) {
                this.typeObj = org.apache.xbean.asm5.Type.getType((String)this.objByteCode);
            }
            return this.typeObj;
        }

        public String toString() {
            if (this.typeObj == null) {
                this.typeObj = org.apache.xbean.asm5.Type.getType((String)this.objByteCode);
            }
            if (this.typeObj.getSort() == 10) {
                return "class " + this.typeObj.getClassName();
            }
            return this.typeObj.getClassName();
        }

        @Override
        public String getByteString() {
            if (this.typeObj == null) {
                this.typeObj = org.apache.xbean.asm5.Type.getType((String)this.objByteCode);
            }
            if (this.typeObj.getSort() == 10) {
                return "L" + this.typeObj.getClassName() + ";";
            }
            return this.typeObj.toString();
        }

        public String getObjByteCode() {
            return this.objByteCode;
        }

        public void setObjByteCode(String objByteCode) {
            this.objByteCode = objByteCode;
        }
    }
}

