/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;

public class DTLoggerFactory
implements LoggerFactory {
    public static final String DT_LOGGERS_LEVEL = "dt.loggers.level";
    private static DTLoggerFactory SINGLETON;
    private final ConcurrentMap<String, Logger> loggerMap = Maps.newConcurrentMap();
    private final Map<String, Level> patternLevel = Maps.newHashMap();
    private final Map<String, Pattern> patterns = Maps.newHashMap();
    private boolean initialized = false;
    private static final Logger LOG;

    public static synchronized DTLoggerFactory getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new DTLoggerFactory();
        }
        return SINGLETON;
    }

    public ImmutableMap<String, String> getPatternLevels() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.patternLevel, (Function)new Function<Level, String>(){

            public String apply(Level input) {
                return input == null ? "" : input.toString();
            }
        }));
    }

    private DTLoggerFactory() {
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            LOG.debug((Object)"initializing DT Logger Factory");
            new RepositorySelectorImpl().initialize();
            String loggersLevel = System.getProperty(DT_LOGGERS_LEVEL);
            if (!Strings.isNullOrEmpty((String)loggersLevel)) {
                String[] targets;
                HashMap targetChanges = Maps.newHashMap();
                for (String target : targets = loggersLevel.split(",")) {
                    String[] parts = target.split(":");
                    targetChanges.put(parts[0], parts[1]);
                }
                this.changeLoggersLevel(targetChanges);
            }
            this.initialized = true;
        } else {
            LOG.warn((Object)"DT Logger Factory already initialized.");
        }
    }

    public synchronized void changeLoggersLevel(@Nonnull Map<String, String> targetChanges) {
        for (Map.Entry<String, String> changeEntry : targetChanges.entrySet()) {
            Iterator<Map.Entry<String, Pattern>> patternsIterator = this.patterns.entrySet().iterator();
            while (patternsIterator.hasNext()) {
                Map.Entry<String, Pattern> entry = patternsIterator.next();
                String finer = entry.getKey();
                String wider = changeEntry.getKey();
                if (finer.length() < wider.length()) continue;
                boolean remove = false;
                for (int i = 0; i < wider.length(); ++i) {
                    if (wider.charAt(i) == '*') {
                        remove = true;
                        break;
                    }
                    if (wider.charAt(i) != finer.charAt(i)) break;
                    if (i != wider.length() - 1) continue;
                    remove = true;
                }
                if (!remove) continue;
                patternsIterator.remove();
                this.patternLevel.remove(finer);
            }
        }
        for (Map.Entry<String, String> loggerEntry : targetChanges.entrySet()) {
            String target = loggerEntry.getKey();
            this.patternLevel.put(target, Level.toLevel((String)loggerEntry.getValue()));
            this.patterns.put(target, Pattern.compile(target));
        }
        if (!this.patternLevel.isEmpty()) {
            Enumeration loggerEnumeration = LogManager.getCurrentLoggers();
            while (loggerEnumeration.hasMoreElements()) {
                Logger classLogger = (Logger)loggerEnumeration.nextElement();
                Level oldLevel = classLogger.getLevel();
                Level newLevel = this.getLevelFor(classLogger.getName());
                if (newLevel == null || oldLevel != null && newLevel.equals((Object)oldLevel)) continue;
                LOG.info((Object)("changing level of " + classLogger.getName() + " to " + newLevel));
                classLogger.setLevel(newLevel);
            }
        }
    }

    public Logger makeNewLoggerInstance(String name) {
        Logger newInstance = new Logger(name);
        Level level = this.getLevelFor(name);
        if (level != null) {
            newInstance.setLevel(level);
        }
        this.loggerMap.put(name, newInstance);
        return newInstance;
    }

    private synchronized Level getLevelFor(String name) {
        if (this.patternLevel.isEmpty()) {
            return null;
        }
        String longestPatternKey = null;
        for (String partternKey : this.patternLevel.keySet()) {
            Pattern pattern = this.patterns.get(partternKey);
            if (!pattern.matcher(name).matches() || longestPatternKey != null && longestPatternKey.length() >= partternKey.length()) continue;
            longestPatternKey = partternKey;
        }
        if (longestPatternKey != null) {
            return this.patternLevel.get(longestPatternKey);
        }
        return null;
    }

    public synchronized ImmutableMap<String, String> getClassesMatching(@Nonnull String searchKey) {
        Pattern searchPattern = Pattern.compile(searchKey);
        HashMap matchedClasses = Maps.newHashMap();
        Enumeration loggerEnumeration = LogManager.getCurrentLoggers();
        while (loggerEnumeration.hasMoreElements()) {
            Logger logger = (Logger)loggerEnumeration.nextElement();
            if (!searchPattern.matcher(logger.getName()).matches()) continue;
            Level level = logger.getLevel();
            matchedClasses.put(logger.getName(), level == null ? "" : level.toString());
        }
        return ImmutableMap.copyOf((Map)matchedClasses);
    }

    static {
        LOG = LogManager.getLogger(DTLoggerFactory.class);
    }

    private static class LoggerRepositoryImpl
    extends Hierarchy {
        private LoggerRepositoryImpl(Logger root) {
            super(root);
        }

        public Logger getLogger(String name) {
            return super.getLogger(name, (LoggerFactory)DTLoggerFactory.getInstance());
        }
    }

    private static class RepositorySelectorImpl
    implements RepositorySelector {
        private boolean initialized = false;
        private Logger guard;
        private Hierarchy hierarchy;

        private RepositorySelectorImpl() {
        }

        private void initialize() {
            if (!this.initialized) {
                LOG.debug((Object)"initializing logger repository selector impl");
                this.guard = LogManager.getRootLogger();
                LogManager.setRepositorySelector((RepositorySelector)this, (Object)this.guard);
                this.hierarchy = new LoggerRepositoryImpl(this.guard);
                this.initialized = true;
            }
        }

        public LoggerRepository getLoggerRepository() {
            return this.hierarchy;
        }
    }
}

