/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.aerospike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.datatorrent.lib.db.Connectable;
import com.datatorrent.netlet.util.DTThrowable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeStore
implements Connectable {
    protected static final Logger logger = LoggerFactory.getLogger(AerospikeStore.class);
    private String userName;
    private String password;
    @NotNull
    private String node;
    private int port;
    protected transient AerospikeClient client = null;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @NotNull
    public String getNode() {
        return this.node;
    }

    public void setNode(@NotNull String node) {
        this.node = node;
    }

    public AerospikeClient getClient() {
        return this.client;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() {
        try {
            this.client = new AerospikeClient(this.node, this.port);
            logger.debug("Aerospike connection Success");
        }
        catch (AerospikeException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
        catch (Throwable t) {
            DTThrowable.rethrow((Throwable)t);
        }
    }

    public void disconnect() {
        this.client.close();
    }

    public boolean isConnected() {
        return !this.client.isConnected();
    }
}

