/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.apachelog;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheLogInputGenerator
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext> {
    private static final String delimiter = ";";
    private transient Random random;
    private transient int ipAddressCount;
    private transient int agentsCount;
    private transient int urlCount;
    private transient int refererCount;
    private transient SimpleDateFormat sdf;
    private transient List<String> ipAddress;
    private transient List<String> url;
    private transient List<String> agents;
    private transient List<Integer> bytes;
    private transient List<Integer> status;
    private transient List<String> referers;
    @NotNull
    private String ipAddressFile;
    @NotNull
    private String urlFile;
    @NotNull
    private String agentFile;
    @NotNull
    private String refererFile;
    private int maxDelay = 1000;
    private long numberOfTuples = Long.MAX_VALUE;
    private int bufferSize = 0x100000;
    protected transient ArrayBlockingQueue<String> holdingBuffer;
    protected transient Thread thread;
    public final transient DefaultOutputPort<String> output = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(ApacheLogInputGenerator.class);

    public void beginWindow(long arg0) {
        this.random.setSeed(System.currentTimeMillis());
    }

    public void endWindow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(String file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File f = new File(file);
        InputStream in = f.exists() ? new FileInputStream(f) : this.getClass().getResourceAsStream(file);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public void setup(Context.OperatorContext arg0) {
        this.holdingBuffer = new ArrayBlockingQueue(this.bufferSize);
        try {
            this.ipAddress = this.readLines(this.ipAddressFile);
            List<String> urlByteStatus = this.readLines(this.urlFile);
            this.referers = this.readLines(this.refererFile);
            this.agents = this.readLines(this.agentFile);
            if (urlByteStatus.get(0).startsWith("#")) {
                urlByteStatus.remove(0);
            }
            LOG.info("Number of IP Addresses: {}", (Object)this.ipAddress.size());
            LOG.info("Number of URLs: {}", (Object)urlByteStatus.size());
            LOG.info("Number of Referers: {}", (Object)this.referers.size());
            LOG.info("Number of User Agents: {}", (Object)this.agents.size());
            this.url = new ArrayList<String>();
            this.bytes = new ArrayList<Integer>();
            this.status = new ArrayList<Integer>();
            for (String str : urlByteStatus) {
                StringTokenizer token = new StringTokenizer(str, delimiter);
                this.url.add(token.nextToken().trim());
                this.bytes.add(Integer.parseInt(token.nextToken().trim()));
                this.status.add(Integer.parseInt(token.nextToken().trim()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.random = new Random();
        this.ipAddressCount = this.ipAddress.size();
        this.agentsCount = this.agents.size();
        this.urlCount = this.url.size();
        this.refererCount = this.referers.size();
        this.sdf = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    }

    public void teardown() {
    }

    public void emitTuples() {
        String entry;
        long ntuples = this.numberOfTuples;
        if (ntuples > (long)this.holdingBuffer.size()) {
            ntuples = this.holdingBuffer.size();
        }
        long i = ntuples;
        while (i-- > 0L && (entry = this.holdingBuffer.poll()) != null) {
            this.output.emit((Object)entry);
        }
    }

    public void activate(Context.OperatorContext context) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while ((long)i++ <= ApacheLogInputGenerator.this.numberOfTuples) {
                    StringBuilder builder = new StringBuilder();
                    builder.append((String)ApacheLogInputGenerator.this.ipAddress.get(ApacheLogInputGenerator.this.random.nextInt(ApacheLogInputGenerator.this.ipAddressCount)));
                    builder.append(" - - ");
                    builder.append("[").append(ApacheLogInputGenerator.this.sdf.format(new Date())).append("] ");
                    int urlIndex = ApacheLogInputGenerator.this.random.nextInt(ApacheLogInputGenerator.this.urlCount);
                    builder.append((String)ApacheLogInputGenerator.this.url.get(urlIndex)).append(" ");
                    builder.append(ApacheLogInputGenerator.this.status.get(urlIndex)).append(" ");
                    builder.append(ApacheLogInputGenerator.this.bytes.get(urlIndex)).append(" ");
                    builder.append((String)ApacheLogInputGenerator.this.referers.get(ApacheLogInputGenerator.this.random.nextInt(ApacheLogInputGenerator.this.refererCount))).append(" ");
                    builder.append((String)ApacheLogInputGenerator.this.agents.get(ApacheLogInputGenerator.this.random.nextInt(ApacheLogInputGenerator.this.agentsCount))).append(" ");
                    ApacheLogInputGenerator.this.holdingBuffer.add(builder.toString());
                    if (ApacheLogInputGenerator.this.maxDelay <= 0) continue;
                    try {
                        Thread.sleep(ApacheLogInputGenerator.this.random.nextInt(ApacheLogInputGenerator.this.maxDelay));
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                return;
            }
        });
        this.thread.start();
    }

    public void deactivate() {
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getMaxDelay() {
        return this.maxDelay;
    }

    public void setMaxDelay(int maxDelay) {
        this.maxDelay = maxDelay;
    }

    public long getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public void setNumberOfTuples(int numberOfTuples) {
        this.numberOfTuples = numberOfTuples;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getIpAddressFile() {
        return this.ipAddressFile;
    }

    public void setIpAddressFile(String ipAddressFile) {
        this.ipAddressFile = ipAddressFile;
    }

    public String getUrlFile() {
        return this.urlFile;
    }

    public void setUrlFile(String urlFile) {
        this.urlFile = urlFile;
    }

    public String getAgentFile() {
        return this.agentFile;
    }

    public void setAgentFile(String agentFile) {
        this.agentFile = agentFile;
    }

    public String getRefererFile() {
        return this.refererFile;
    }

    public void setRefererFile(String refererFile) {
        this.refererFile = refererFile;
    }
}

