/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.apachelog;

import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.api.StreamingApplication;
import com.datatorrent.contrib.apachelog.ApacheLogInputGenerator;
import com.datatorrent.contrib.apachelog.GeoIPExtractor;
import com.datatorrent.contrib.apachelog.TimestampExtractor;
import com.datatorrent.contrib.apachelog.UserAgentExtractor;
import com.datatorrent.lib.io.ConsoleOutputOperator;
import com.datatorrent.lib.logs.ApacheLogParseMapOutputOperator;
import com.datatorrent.lib.logs.InformationExtractor;
import org.apache.hadoop.conf.Configuration;

public class ApplicationLogGenerator
implements StreamingApplication {
    public void populateDAG(DAG dag, Configuration conf) {
        ApacheLogInputGenerator log = (ApacheLogInputGenerator)dag.addOperator("log", (Operator)new ApacheLogInputGenerator());
        log.setIpAddressFile("/com/datatorrent/contrib/apachelog/ipaddress.txt");
        log.setUrlFile("/com/datatorrent/contrib/apachelog/urls.txt");
        log.setAgentFile("/com/datatorrent/contrib/apachelog/agents.txt");
        log.setRefererFile("/com/datatorrent/contrib/apachelog/referers.txt");
        ApacheLogParseMapOutputOperator parse = (ApacheLogParseMapOutputOperator)dag.addOperator("parse", (Operator)new ApacheLogParseMapOutputOperator());
        GeoIPExtractor geoIPExtractor = new GeoIPExtractor();
        geoIPExtractor.setDatabasePath("/home/david/GeoLiteCity.dat");
        parse.registerInformationExtractor("ip", (InformationExtractor)geoIPExtractor);
        parse.registerInformationExtractor("agent", (InformationExtractor)new UserAgentExtractor());
        TimestampExtractor timestampExtractor = new TimestampExtractor();
        timestampExtractor.setDateFormatString("dd/MMM/yyyy:HH:mm:ss Z");
        parse.registerInformationExtractor("time", (InformationExtractor)timestampExtractor);
        ConsoleOutputOperator console = (ConsoleOutputOperator)dag.addOperator("console", (Operator)new ConsoleOutputOperator());
        dag.addStream("log-parse", log.output, (Operator.InputPort)parse.data);
        dag.addStream("parse-console", (Operator.OutputPort)parse.output, (Operator.InputPort)console.input).setLocality(DAG.Locality.CONTAINER_LOCAL);
    }
}

