/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.apachelog;

import com.datatorrent.lib.logs.InformationExtractor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.service.UADetectorServiceFactory;

public class UserAgentExtractor
implements InformationExtractor {
    private static final long serialVersionUID = 201404221817L;
    private transient UserAgentStringParser parser;

    public void setup() {
        this.parser = new CachedUserAgentStringParser();
    }

    public void teardown() {
        this.parser.shutdown();
    }

    public Map<String, Object> extractInformation(Object value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        ReadableUserAgent agent = this.parser.parse(value.toString());
        m.put("browser", agent.getName());
        m.put("os", agent.getOperatingSystem().getName());
        return m;
    }

    public static class CachedUserAgentStringParser
    implements UserAgentStringParser {
        private final UserAgentStringParser parser = UADetectorServiceFactory.getCachingAndUpdatingParser();
        private final Cache<String, ReadableUserAgent> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(2L, TimeUnit.HOURS).build();

        public String getDataVersion() {
            return this.parser.getDataVersion();
        }

        public ReadableUserAgent parse(String userAgentString) {
            ReadableUserAgent result = (ReadableUserAgent)this.cache.getIfPresent((Object)userAgentString);
            if (result == null) {
                result = this.parser.parse(userAgentString);
                this.cache.put((Object)userAgentString, (Object)result);
            }
            return result;
        }

        public void shutdown() {
            this.parser.shutdown();
        }
    }
}

