/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.avro;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class AvroToPojo
extends BaseOperator {
    private transient Class<?> pojoClass;
    private static final String FIELD_SEPARATOR = ":";
    private static final String RECORD_SEPARATOR = ",";
    private String genericRecordToPOJOFieldsMapping = null;
    private List<FieldInfo> fieldInfos;
    private List<ActiveFieldInfo> columnFieldSetters;
    @AutoMetric
    @VisibleForTesting
    int recordCount = 0;
    @AutoMetric
    @VisibleForTesting
    int errorCount = 0;
    @AutoMetric
    @VisibleForTesting
    int fieldErrorCount = 0;
    public final transient DefaultOutputPort<GenericRecord> errorPort = new DefaultOutputPort();
    public final transient DefaultInputPort<GenericRecord> data = new DefaultInputPort<GenericRecord>(){

        public void process(GenericRecord tuple) {
            AvroToPojo.this.processTuple(tuple);
        }
    };
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> output = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            AvroToPojo.this.setPojoClass((Class)context.getValue(Context.PortContext.TUPLE_CLASS));
            AvroToPojo.this.columnFieldSetters = Lists.newArrayList();
            if (AvroToPojo.this.getGenericRecordToPOJOFieldsMapping() == null) {
                AvroToPojo.this.setFieldInfos(AvroToPojo.this.createFieldInfoMap(AvroToPojo.this.generateFieldInfoInputs(AvroToPojo.this.getPojoClass())));
            } else {
                AvroToPojo.this.setFieldInfos(AvroToPojo.this.createFieldInfoMap(AvroToPojo.this.getGenericRecordToPOJOFieldsMapping()));
            }
            AvroToPojo.this.initColumnFieldSetters(AvroToPojo.this.getFieldInfos());
            AvroToPojo.this.initializeActiveFieldSetters();
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(AvroToPojo.class);

    public String getGenericRecordToPOJOFieldsMapping() {
        return this.genericRecordToPOJOFieldsMapping;
    }

    public void setGenericRecordToPOJOFieldsMapping(String genericRecordToPOJOFieldsMapping) {
        this.genericRecordToPOJOFieldsMapping = genericRecordToPOJOFieldsMapping;
    }

    protected void processTuple(GenericRecord tuple) {
        try {
            Object obj = this.getPOJOFromGenericRecord(tuple);
            if (obj != null) {
                this.output.emit(obj);
                ++this.recordCount;
            } else if (this.errorPort.isConnected()) {
                this.errorPort.emit((Object)tuple);
                ++this.errorCount;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Could not initialize object of class -" + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
            ++this.errorCount;
        }
    }

    private Object getPOJOFromGenericRecord(GenericRecord tuple) throws InstantiationException, IllegalAccessException {
        Object newObj = this.getPojoClass().newInstance();
        try {
            for (int i = 0; i < this.columnFieldSetters.size(); ++i) {
                ActiveFieldInfo afi = this.columnFieldSetters.get(i);
                FieldInfo.SupportType st = afi.fieldInfo.getType();
                Object val = null;
                try {
                    val = tuple.get(afi.fieldInfo.getColumnName());
                }
                catch (Exception e) {
                    LOG.error("Could not find field -" + afi.fieldInfo.getColumnName() + "- in the generic record", (Throwable)e);
                    val = null;
                    ++this.fieldErrorCount;
                }
                if (val == null) continue;
                try {
                    switch (st) {
                        case BOOLEAN: {
                            ((PojoUtils.SetterBoolean)afi.setterOrGetter).set(newObj, ((Boolean)tuple.get(afi.fieldInfo.getColumnName())).booleanValue());
                            break;
                        }
                        case DOUBLE: {
                            ((PojoUtils.SetterDouble)afi.setterOrGetter).set(newObj, ((Double)tuple.get(afi.fieldInfo.getColumnName())).doubleValue());
                            break;
                        }
                        case FLOAT: {
                            ((PojoUtils.SetterFloat)afi.setterOrGetter).set(newObj, ((Float)tuple.get(afi.fieldInfo.getColumnName())).floatValue());
                            break;
                        }
                        case INTEGER: {
                            ((PojoUtils.SetterInt)afi.setterOrGetter).set(newObj, ((Integer)tuple.get(afi.fieldInfo.getColumnName())).intValue());
                            break;
                        }
                        case STRING: {
                            ((PojoUtils.Setter)afi.setterOrGetter).set(newObj, (Object)new String(tuple.get(afi.fieldInfo.getColumnName()).toString()));
                            break;
                        }
                        case LONG: {
                            ((PojoUtils.SetterLong)afi.setterOrGetter).set(newObj, ((Long)tuple.get(afi.fieldInfo.getColumnName())).longValue());
                            break;
                        }
                        default: {
                            throw new AvroRuntimeException("Invalid Support Type");
                        }
                    }
                    continue;
                }
                catch (AvroRuntimeException e) {
                    LOG.error("Exception in setting value", (Throwable)e);
                    ++this.fieldErrorCount;
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Generic Exception in setting value" + ex.getMessage());
            ++this.errorCount;
            newObj = null;
        }
        return newObj;
    }

    private String generateFieldInfoInputs(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Class c = ClassUtils.primitiveToWrapper(f.getType());
            sb.append(f.getName()).append(FIELD_SEPARATOR).append(f.getName()).append(FIELD_SEPARATOR).append(c.getSimpleName().toUpperCase()).append(RECORD_SEPARATOR);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private List<FieldInfo> createFieldInfoMap(String str) {
        this.fieldInfos = new ArrayList<FieldInfo>();
        StringTokenizer strtok = new StringTokenizer(str, RECORD_SEPARATOR);
        while (strtok.hasMoreTokens()) {
            String[] token = strtok.nextToken().split(FIELD_SEPARATOR);
            try {
                this.fieldInfos.add(new FieldInfo(token[0], token[1], FieldInfo.SupportType.valueOf((String)token[2])));
            }
            catch (Exception e) {
                LOG.error("Invalid support type", (Throwable)e);
            }
        }
        return this.fieldInfos;
    }

    public void endWindow() {
        this.errorCount = 0;
        this.fieldErrorCount = 0;
        this.recordCount = 0;
    }

    private Class<?> getPojoClass() {
        return this.pojoClass;
    }

    public void setPojoClass(Class<?> pojoClass) {
        this.pojoClass = pojoClass;
    }

    private List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    private void initColumnFieldSetters(List<FieldInfo> fieldInfos) {
        for (FieldInfo fi : fieldInfos) {
            if (this.columnFieldSetters == null) {
                this.columnFieldSetters = Lists.newArrayList();
            }
            this.columnFieldSetters.add(new ActiveFieldInfo(fi));
        }
    }

    private void setFieldInfos(List<FieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    private void initializeActiveFieldSetters() {
        for (int i = 0; i < this.columnFieldSetters.size(); ++i) {
            ActiveFieldInfo activeFieldInfo = this.columnFieldSetters.get(i);
            FieldInfo.SupportType st = activeFieldInfo.fieldInfo.getType();
            switch (st) {
                case BOOLEAN: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterBoolean(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case DOUBLE: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterDouble(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case FLOAT: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterFloat(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case INTEGER: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterInt(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case STRING: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression(), (Class)activeFieldInfo.fieldInfo.getType().getJavaType());
                    break;
                }
                case LONG: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                default: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression(), Byte.class);
                }
            }
            this.columnFieldSetters.get((int)i).setterOrGetter = activeFieldInfo.setterOrGetter;
        }
    }

    protected static class ActiveFieldInfo {
        final FieldInfo fieldInfo;
        Object setterOrGetter;

        ActiveFieldInfo(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }
    }
}

