/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.contrib.cassandra.AbstractCassandraInputOperator;
import com.datatorrent.contrib.cassandra.CassandraStore;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class CassandraPOJOInputOperator
extends AbstractCassandraInputOperator<Object>
implements Operator.ActivationListener<Context.OperatorContext> {
    private String tokenQuery;
    @NotNull
    private List<FieldInfo> fieldInfos;
    private Number startRow;
    private Long startRowToken = Long.MIN_VALUE;
    @NotNull
    private String tablename;
    @NotNull
    private String query;
    @NotNull
    private String primaryKeyColumn;
    @Min(value=1L)
    private int limit = 10;
    protected final transient List<Object> setters;
    protected final transient List<DataType> columnDataTypes;
    protected transient Class<?> pojoClass;
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> outputPort = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            CassandraPOJOInputOperator.this.pojoClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPOJOInputOperator.class);

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public Number getStartRow() {
        return this.startRow;
    }

    public void setStartRow(Number startRow) {
        this.startRow = startRow;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public void setFieldInfos(List<FieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public CassandraPOJOInputOperator() {
        this.columnDataTypes = new ArrayList<DataType>();
        this.setters = new ArrayList<Object>();
        this.store = new CassandraStore();
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.tokenQuery = "select token(" + this.primaryKeyColumn + ") from " + ((CassandraStore)this.store).keyspace + "." + this.tablename + " where " + this.primaryKeyColumn + " =  ?";
    }

    public void activate(Context.OperatorContext context) {
        Long keyToken;
        if (this.startRow != null && (keyToken = this.fetchKeyTokenFromDB(this.startRow)) != null) {
            this.startRowToken = keyToken;
        }
        ResultSet rs = ((CassandraStore)this.store).getSession().execute("select * from " + ((CassandraStore)this.store).keyspace + "." + this.tablename + " LIMIT " + 1);
        ColumnDefinitions rsMetaData = rs.getColumnDefinitions();
        if (this.query.contains("%t")) {
            this.query = this.query.replace("%t", this.tablename);
        }
        if (this.query.contains("%p")) {
            this.query = this.query.replace("%p", this.primaryKeyColumn);
        }
        if (this.query.contains("%l")) {
            this.query = this.query.replace("%l", this.limit + "");
        }
        LOG.debug("query is {}", (Object)this.query);
        for (FieldInfo fieldInfo : this.fieldInfos) {
            PojoUtils.SetterBoolean setter;
            DataType type = rsMetaData.getType(fieldInfo.getColumnName());
            this.columnDataTypes.add(type);
            String setterExpr = fieldInfo.getPojoFieldExpression();
            switch (type.getName()) {
                case ASCII: 
                case TEXT: 
                case VARCHAR: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, String.class);
                    break;
                }
                case BOOLEAN: {
                    setter = PojoUtils.createSetterBoolean(this.pojoClass, (String)setterExpr);
                    break;
                }
                case INT: {
                    setter = PojoUtils.createSetterInt(this.pojoClass, (String)setterExpr);
                    break;
                }
                case BIGINT: 
                case COUNTER: {
                    setter = PojoUtils.createSetterLong(this.pojoClass, (String)setterExpr);
                    break;
                }
                case FLOAT: {
                    setter = PojoUtils.createSetterFloat(this.pojoClass, (String)setterExpr);
                    break;
                }
                case DOUBLE: {
                    setter = PojoUtils.createSetterDouble(this.pojoClass, (String)setterExpr);
                    break;
                }
                case DECIMAL: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, BigDecimal.class);
                    break;
                }
                case SET: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, Set.class);
                    break;
                }
                case MAP: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, Map.class);
                    break;
                }
                case LIST: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, List.class);
                    break;
                }
                case TIMESTAMP: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, Date.class);
                    break;
                }
                case UUID: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, UUID.class);
                    break;
                }
                default: {
                    setter = PojoUtils.createSetter(this.pojoClass, (String)setterExpr, Object.class);
                }
            }
            this.setters.add(setter);
        }
    }

    @Override
    public Object getTuple(Row row) {
        Object obj;
        try {
            obj = this.pojoClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        block16: for (int i = 0; i < this.columnDataTypes.size(); ++i) {
            DataType type = this.columnDataTypes.get(i);
            String columnName = this.fieldInfos.get(i).getColumnName();
            switch (type.getName()) {
                case UUID: {
                    UUID id = row.getUUID(columnName);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)id);
                    continue block16;
                }
                case ASCII: 
                case TEXT: 
                case VARCHAR: {
                    String ascii = row.getString(columnName);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)ascii);
                    continue block16;
                }
                case BOOLEAN: {
                    boolean bool = row.getBool(columnName);
                    ((PojoUtils.SetterBoolean)this.setters.get(i)).set(obj, bool);
                    continue block16;
                }
                case INT: {
                    int intValue = row.getInt(columnName);
                    ((PojoUtils.SetterInt)this.setters.get(i)).set(obj, intValue);
                    continue block16;
                }
                case BIGINT: 
                case COUNTER: {
                    long longValue = row.getLong(columnName);
                    ((PojoUtils.SetterLong)this.setters.get(i)).set(obj, longValue);
                    continue block16;
                }
                case FLOAT: {
                    float floatValue = row.getFloat(columnName);
                    ((PojoUtils.SetterFloat)this.setters.get(i)).set(obj, floatValue);
                    continue block16;
                }
                case DOUBLE: {
                    double doubleValue = row.getDouble(columnName);
                    ((PojoUtils.SetterDouble)this.setters.get(i)).set(obj, doubleValue);
                    continue block16;
                }
                case DECIMAL: {
                    BigDecimal decimal = row.getDecimal(columnName);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)decimal);
                    continue block16;
                }
                case SET: {
                    Set set = row.getSet(columnName, Object.class);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)set);
                    continue block16;
                }
                case MAP: {
                    Map map = row.getMap(columnName, Object.class, Object.class);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)map);
                    continue block16;
                }
                case LIST: {
                    List list = row.getList(columnName, Object.class);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)list);
                    continue block16;
                }
                case TIMESTAMP: {
                    Date date = row.getDate(columnName);
                    ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)date);
                    continue block16;
                }
                default: {
                    throw new RuntimeException("unsupported data type " + type.getName());
                }
            }
        }
        return obj;
    }

    @Override
    public String queryToRetrieveData() {
        if (this.query.contains("%v")) {
            return this.query.replace("%v", this.startRowToken + "");
        }
        return this.query;
    }

    private Long fetchKeyTokenFromDB(Object keyValue) {
        PreparedStatement statement = ((CassandraStore)this.store).getSession().prepare(this.tokenQuery);
        BoundStatement boundStatement = new BoundStatement(statement);
        boundStatement.bind(new Object[]{keyValue});
        ResultSet rs = ((CassandraStore)this.store).getSession().execute((Statement)boundStatement);
        Long keyTokenValue = rs.one().getLong(0);
        return keyTokenValue;
    }

    @Override
    protected void emit(Object tuple) {
        this.outputPort.emit(tuple);
    }

    public void deactivate() {
    }
}

