/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datatorrent.lib.db.Connectable;
import com.datatorrent.netlet.util.DTThrowable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStore
implements Connectable {
    protected static final Logger logger = LoggerFactory.getLogger(CassandraStore.class);
    private String userName;
    private String password;
    @NotNull
    private String node;
    protected transient Cluster cluster = null;
    protected transient Session session = null;
    private String protocolVersion;
    @NotNull
    protected String keyspace;

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @NotNull
    public String getNode() {
        return this.node;
    }

    public void setNode(@NotNull String node) {
        this.node = node;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Session getSession() {
        return this.session;
    }

    public void buildCluster() {
        try {
            if (this.protocolVersion != null && this.protocolVersion.length() != 0) {
                ProtocolVersion version = this.getCassandraProtocolVersion();
                this.cluster = Cluster.builder().addContactPoint(this.node).withCredentials(this.userName, this.password).withProtocolVersion(version).build();
            } else {
                this.cluster = Cluster.builder().addContactPoint(this.node).withCredentials(this.userName, this.password).build();
            }
        }
        catch (DriverException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
        catch (Throwable t) {
            DTThrowable.rethrow((Throwable)t);
        }
    }

    private ProtocolVersion getCassandraProtocolVersion() {
        switch (this.protocolVersion.toUpperCase()) {
            case "V1": {
                return ProtocolVersion.V1;
            }
            case "V2": {
                return ProtocolVersion.V2;
            }
            case "V3": {
                return ProtocolVersion.V3;
            }
        }
        throw new RuntimeException("Unsupported Cassandra Protocol Version.");
    }

    public void connect() {
        try {
            if (this.cluster == null) {
                this.buildCluster();
            }
            this.session = this.cluster.connect();
            logger.debug("Cassandra connection Success");
        }
        catch (DriverException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
        catch (Throwable t) {
            DTThrowable.rethrow((Throwable)t);
        }
    }

    public void disconnect() {
        try {
            this.session.close();
            this.cluster.close();
        }
        catch (DriverException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
        catch (Throwable t) {
            DTThrowable.rethrow((Throwable)t);
        }
    }

    public boolean isConnected() {
        try {
            return !this.session.isClosed();
        }
        catch (DriverException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
    }
}

