/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.CouchbaseConnectionFactoryBuilder;
import com.couchbase.client.vbucket.ConfigurationProviderHTTP;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.datatorrent.lib.db.Connectable;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchBaseStore
implements Connectable {
    private static final Logger logger = LoggerFactory.getLogger(CouchBaseStore.class);
    @Nonnull
    protected String bucket = "default";
    @Nonnull
    protected String password;
    @Nonnull
    protected String userConfig;
    @Nonnull
    protected String passwordConfig;
    @Nonnull
    protected String uriString;
    protected transient CouchbaseClient client = null;
    @Min(value=1L)
    protected Integer queueSize = 100;
    protected Integer maxTuples = 1000;
    protected int blockTime = 1000;
    protected long timeout = 10000L;
    protected int shutdownTimeout = 60;
    transient List<URI> baseURIs = new ArrayList<URI>();

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getUserConfig() {
        return this.userConfig;
    }

    public void setUserConfig(String userConfig) {
        this.userConfig = userConfig;
    }

    public String getPasswordConfig() {
        return this.passwordConfig;
    }

    public void setPasswordConfig(String passwordConfig) {
        this.passwordConfig = passwordConfig;
    }

    public Integer getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getBlockTime() {
        return this.blockTime;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setBlockTime(int blockTime) {
        this.blockTime = blockTime;
    }

    public Integer getMaxTuples() {
        return this.maxTuples;
    }

    public void setMaxTuples(Integer maxTuples) {
        this.maxTuples = maxTuples;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public CouchbaseClient getInstance() {
        return this.client;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUriString(String uriString) {
        this.uriString = uriString;
    }

    public Config getConf() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            DTThrowable.rethrow((Exception)ex);
        }
        ConfigurationProviderHTTP configurationProvider = new ConfigurationProviderHTTP(this.baseURIs, this.userConfig, this.passwordConfig);
        Bucket configBucket = configurationProvider.getBucketConfiguration(this.bucket);
        Config conf = configBucket.getConfig();
        try {
            this.disconnect();
        }
        catch (IOException ex) {
            DTThrowable.rethrow((Exception)ex);
        }
        return conf;
    }

    public void connect() throws IOException {
        String[] tokens = this.uriString.split(",");
        URI uri = null;
        for (String url : tokens) {
            try {
                uri = new URI("http", url, "/pools", null, null);
            }
            catch (URISyntaxException ex) {
                DTThrowable.rethrow((Exception)ex);
            }
            this.baseURIs.add(uri);
        }
        try {
            CouchbaseConnectionFactoryBuilder cfb = new CouchbaseConnectionFactoryBuilder();
            cfb.setOpTimeout(this.timeout);
            cfb.setOpQueueMaxBlockTime((long)this.blockTime);
            this.client = new CouchbaseClient(cfb.buildCouchbaseConnection(this.baseURIs, this.bucket, this.password));
        }
        catch (IOException e) {
            logger.error("Error connecting to Couchbase:", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public CouchbaseClient connectServer(String urlString) throws IOException {
        ArrayList<URI> nodes = new ArrayList<URI>();
        CouchbaseClient clientPartition = null;
        try {
            nodes.add(new URI("http", urlString, "/pools", null, null));
        }
        catch (URISyntaxException ex) {
            DTThrowable.rethrow((Exception)ex);
        }
        try {
            clientPartition = new CouchbaseClient(nodes, this.bucket, this.password);
        }
        catch (IOException e) {
            logger.error("Error connecting to Couchbase:", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        return clientPartition;
    }

    public boolean isConnected() {
        return false;
    }

    public void disconnect() throws IOException {
        if (this.client != null) {
            this.client.shutdown((long)this.shutdownTimeout, TimeUnit.SECONDS);
        }
    }
}

