/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchbase;

import com.datatorrent.contrib.couchbase.AbstractCouchBaseSetOperator;
import com.datatorrent.contrib.couchbase.CouchBaseStore;
import com.datatorrent.lib.util.PojoUtils;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class CouchbasePOJOSetOperator
extends AbstractCouchBaseSetOperator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CouchBaseStore.class);
    private transient PojoUtils.Getter<Object, String> keyGetter;
    private transient PojoUtils.Getter<Object, ? extends Object> valueGetter;
    @NotNull
    private ArrayList<String> expressions;

    public ArrayList<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<String> expressions) {
        this.expressions = expressions;
    }

    @Override
    public String getKey(Object tuple) {
        if (null == this.keyGetter) {
            Class<?> tupleClass = tuple.getClass();
            this.keyGetter = PojoUtils.createGetter(tupleClass, (String)this.expressions.get(0), String.class);
        }
        String key = (String)this.keyGetter.get(tuple);
        logger.debug("key is {}", (Object)key);
        return key;
    }

    @Override
    public Object getValue(Object tuple) {
        Object value = null;
        if (null == this.valueGetter) {
            Class<?> tupleClass = tuple.getClass();
            String getterExpression = this.expressions.get(1);
            this.valueGetter = PojoUtils.createGetter(tupleClass, (String)getterExpression, Object.class);
        }
        if (this.valueGetter != null) {
            value = this.valueGetter.get(tuple);
        }
        logger.debug("value is {}", value);
        return value;
    }
}

