/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchdb;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.couchdb.AbstractCouchDBInputOperator;
import com.datatorrent.contrib.couchdb.CouchDbStore;
import com.datatorrent.lib.util.PojoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;

@InterfaceStability.Evolving
public class CouchDBPOJOInputOperator
extends AbstractCouchDBInputOperator<Object> {
    @NotNull
    private List<String> expressions;
    private String expressionForDocId;
    @NotNull
    private List<String> columns;
    @NotNull
    private String designDocumentName;
    @NotNull
    private String viewName;
    private transient ViewQuery query;
    private transient PojoUtils.Setter<Object, String> setterDocId;
    private transient List<Object> setterDoc;
    private boolean descending;
    private final transient ObjectMapper mapper = new ObjectMapper();
    private transient Class<?> objectClass = null;
    private String outputClass;
    private final transient List<Class<?>> fieldType = new ArrayList();

    public CouchDBPOJOInputOperator() {
        this.store = new CouchDbStore();
    }

    public List<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<String> expressions) {
        this.expressions = expressions;
    }

    public String getDesignDocumentName() {
        return this.designDocumentName;
    }

    public void setDesignDocumentName(String designDocumentName) {
        this.designDocumentName = designDocumentName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String getExpressionForDocId() {
        return this.expressionForDocId;
    }

    public void setExpressionForDocId(String expressionForDocId) {
        this.expressionForDocId = expressionForDocId;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.setterDoc = new ArrayList<Object>();
        this.query = new ViewQuery().designDocId(this.designDocumentName).viewName(this.viewName).descending(this.descending);
        try {
            this.objectClass = Class.forName(this.outputClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        if (this.expressionForDocId != null) {
            this.setterDocId = PojoUtils.createSetter(this.objectClass, (String)this.expressionForDocId, String.class);
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Class<?> type = null;
            try {
                type = this.objectClass.getDeclaredField(this.columns.get(i)).getType();
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            this.fieldType.add(type);
            if (type.isPrimitive()) {
                this.setterDoc.add(PojoUtils.constructSetter(this.objectClass, (String)this.expressions.get(i), type));
                continue;
            }
            this.setterDoc.add(PojoUtils.createSetter(this.objectClass, (String)this.expressions.get(i), type));
        }
    }

    @Override
    public Object getTuple(ViewResult.Row value) throws IOException {
        Object obj;
        try {
            obj = this.objectClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (this.setterDocId != null) {
            this.setterDocId.set(obj, (Object)value.getId());
        }
        JsonNode val = value.getValueAsNode();
        for (int i = 0; i < this.setterDoc.size(); ++i) {
            Class<?> type = this.fieldType.get(i);
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    ((PojoUtils.SetterInt)this.setterDoc.get(i)).set(obj, val.get(this.columns.get(i)).getIntValue());
                    continue;
                }
                if (type == Boolean.TYPE) {
                    ((PojoUtils.SetterBoolean)this.setterDoc.get(i)).set(obj, val.get(this.columns.get(i)).getBooleanValue());
                    continue;
                }
                if (type == Long.TYPE) {
                    ((PojoUtils.SetterLong)this.setterDoc.get(i)).set(obj, val.get(this.columns.get(i)).getLongValue());
                    continue;
                }
                if (type == Double.TYPE) {
                    ((PojoUtils.SetterDouble)this.setterDoc.get(i)).set(obj, val.get(this.columns.get(i)).getDoubleValue());
                    continue;
                }
                throw new RuntimeException("Type is not supported");
            }
            ((PojoUtils.Setter)this.setterDoc.get(i)).set(obj, this.mapper.readValue(val.get(this.columns.get(i)), type));
        }
        return obj;
    }

    @Override
    public ViewQuery getViewQuery() {
        return this.query;
    }
}

