/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.couchdb;

import com.datatorrent.lib.db.Connectable;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbInstance;

public class CouchDbStore
implements Connectable {
    private String dbUrl;
    private String userName;
    private String password;
    @NotNull
    private String dbName;
    private transient CouchDbConnector dbConnector;
    private transient StdCouchDbInstance couchInstance;

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(@Nonnull String dbName) {
        this.dbName = dbName;
    }

    public boolean containsDocument(String docId) {
        return this.dbConnector.contains(docId);
    }

    public void insertDocument(String docId, @Nonnull Object document) {
        this.dbConnector.create(docId, document);
    }

    @Nullable
    public <T> T getDocument(String docId, Class<T> docType) {
        return (T)this.dbConnector.get(docType, docId);
    }

    public void upsertDocument(String docId, @Nonnull Object document) {
        if (docId != null && this.dbConnector.contains(docId)) {
            this.dbConnector.update(document);
        } else {
            this.dbConnector.create(document);
        }
    }

    public ViewResult queryStore(ViewQuery viewQuery) {
        return this.dbConnector.queryView(viewQuery);
    }

    public void connect() throws IOException {
        StdHttpClient.Builder builder = new StdHttpClient.Builder();
        if (this.dbUrl != null) {
            try {
                builder.url(this.dbUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (this.userName != null) {
            builder.username(this.userName);
        }
        if (this.password != null) {
            builder.password(this.password);
        }
        HttpClient httpClient = builder.build();
        this.couchInstance = new StdCouchDbInstance(httpClient);
        this.dbConnector = this.couchInstance.createConnector(this.dbName, false);
    }

    public void disconnect() throws IOException {
        this.couchInstance.getConnection().shutdown();
        this.dbConnector = null;
    }

    public boolean isConnected() {
        return this.dbConnector == null;
    }
}

